import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SourcerepoRepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#id SourcerepoRepository#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource name of the repository, of the form '{{repo}}'.
  The repo name may contain slashes. eg, 'name/with/slash'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#name SourcerepoRepository#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#project SourcerepoRepository#project}
    */
    readonly project?: string;
    /**
    * pubsub_configs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#pubsub_configs SourcerepoRepository#pubsub_configs}
    */
    readonly pubsubConfigs?: SourcerepoRepositoryPubsubConfigs[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#timeouts SourcerepoRepository#timeouts}
    */
    readonly timeouts?: SourcerepoRepositoryTimeouts;
}
export interface SourcerepoRepositoryPubsubConfigs {
    /**
    * The format of the Cloud Pub/Sub messages.
  - PROTOBUF: The message payload is a serialized protocol buffer of SourceRepoEvent.
  - JSON: The message payload is a JSON string of SourceRepoEvent. Possible values: ["PROTOBUF", "JSON"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#message_format SourcerepoRepository#message_format}
    */
    readonly messageFormat: string;
    /**
    * Email address of the service account used for publishing Cloud Pub/Sub messages.
  This service account needs to be in the same project as the PubsubConfig. When added,
  the caller needs to have iam.serviceAccounts.actAs permission on this service account.
  If unspecified, it defaults to the compute engine default service account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#service_account_email SourcerepoRepository#service_account_email}
    */
    readonly serviceAccountEmail?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#topic SourcerepoRepository#topic}
    */
    readonly topic: string;
}
export declare function sourcerepoRepositoryPubsubConfigsToTerraform(struct?: SourcerepoRepositoryPubsubConfigs | cdktf.IResolvable): any;
export declare class SourcerepoRepositoryPubsubConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SourcerepoRepositoryPubsubConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: SourcerepoRepositoryPubsubConfigs | cdktf.IResolvable | undefined);
    private _messageFormat?;
    get messageFormat(): string;
    set messageFormat(value: string);
    get messageFormatInput(): string | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    resetServiceAccountEmail(): void;
    get serviceAccountEmailInput(): string | undefined;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
}
export declare class SourcerepoRepositoryPubsubConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SourcerepoRepositoryPubsubConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SourcerepoRepositoryPubsubConfigsOutputReference;
}
export interface SourcerepoRepositoryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#create SourcerepoRepository#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#delete SourcerepoRepository#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository#update SourcerepoRepository#update}
    */
    readonly update?: string;
}
export declare function sourcerepoRepositoryTimeoutsToTerraform(struct?: SourcerepoRepositoryTimeoutsOutputReference | SourcerepoRepositoryTimeouts | cdktf.IResolvable): any;
export declare class SourcerepoRepositoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SourcerepoRepositoryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SourcerepoRepositoryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository google_sourcerepo_repository}
*/
export declare class SourcerepoRepository extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_sourcerepo_repository";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository google_sourcerepo_repository} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SourcerepoRepositoryConfig
    */
    constructor(scope: Construct, id: string, config: SourcerepoRepositoryConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get size(): number;
    get url(): string;
    private _pubsubConfigs;
    get pubsubConfigs(): SourcerepoRepositoryPubsubConfigsList;
    putPubsubConfigs(value: SourcerepoRepositoryPubsubConfigs[] | cdktf.IResolvable): void;
    resetPubsubConfigs(): void;
    get pubsubConfigsInput(): cdktf.IResolvable | SourcerepoRepositoryPubsubConfigs[] | undefined;
    private _timeouts;
    get timeouts(): SourcerepoRepositoryTimeoutsOutputReference;
    putTimeouts(value: SourcerepoRepositoryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SourcerepoRepositoryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
