import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * The deletion policy for the user. Setting ABANDON allows the resource
                  to be abandoned rather than deleted. This is useful for Postgres, where users cannot be deleted from the API if they
                  have been granted SQL roles. Possible values are: "ABANDON".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#deletion_policy SqlUser#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * The host the user can connect from. This is only supported for MySQL instances. Don't set this field for PostgreSQL instances. Can be an IP address. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#host SqlUser#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#id SqlUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Cloud SQL instance. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#instance SqlUser#instance}
    */
    readonly instance: string;
    /**
    * The name of the user. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#name SqlUser#name}
    */
    readonly name: string;
    /**
    * The password for the user. Can be updated. For Postgres instances this is a Required field, unless type is set to
                  either CLOUD_IAM_USER or CLOUD_IAM_SERVICE_ACCOUNT.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#password SqlUser#password}
    */
    readonly password?: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#project SqlUser#project}
    */
    readonly project?: string;
    /**
    * The user type. It determines the method to authenticate the user during login.
                  The default is the database's built-in user type. Flags include "BUILT_IN", "CLOUD_IAM_USER", or "CLOUD_IAM_SERVICE_ACCOUNT".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#type SqlUser#type}
    */
    readonly type?: string;
    /**
    * password_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#password_policy SqlUser#password_policy}
    */
    readonly passwordPolicy?: SqlUserPasswordPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#timeouts SqlUser#timeouts}
    */
    readonly timeouts?: SqlUserTimeouts;
}
export interface SqlUserSqlServerUserDetails {
}
export declare function sqlUserSqlServerUserDetailsToTerraform(struct?: SqlUserSqlServerUserDetails): any;
export declare class SqlUserSqlServerUserDetailsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SqlUserSqlServerUserDetails | undefined;
    set internalValue(value: SqlUserSqlServerUserDetails | undefined);
    get disabled(): cdktf.IResolvable;
    get serverRoles(): string[];
}
export declare class SqlUserSqlServerUserDetailsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SqlUserSqlServerUserDetailsOutputReference;
}
export interface SqlUserPasswordPolicyStatus {
}
export declare function sqlUserPasswordPolicyStatusToTerraform(struct?: SqlUserPasswordPolicyStatus): any;
export declare class SqlUserPasswordPolicyStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SqlUserPasswordPolicyStatus | undefined;
    set internalValue(value: SqlUserPasswordPolicyStatus | undefined);
    get locked(): cdktf.IResolvable;
    get passwordExpirationTime(): string;
}
export declare class SqlUserPasswordPolicyStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SqlUserPasswordPolicyStatusOutputReference;
}
export interface SqlUserPasswordPolicy {
    /**
    * Number of failed attempts allowed before the user get locked.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#allowed_failed_attempts SqlUser#allowed_failed_attempts}
    */
    readonly allowedFailedAttempts?: number;
    /**
    * If true, the check that will lock user after too many failed login attempts will be enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#enable_failed_attempts_check SqlUser#enable_failed_attempts_check}
    */
    readonly enableFailedAttemptsCheck?: boolean | cdktf.IResolvable;
    /**
    * If true, the user must specify the current password before changing the password. This flag is supported only for MySQL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#enable_password_verification SqlUser#enable_password_verification}
    */
    readonly enablePasswordVerification?: boolean | cdktf.IResolvable;
    /**
    * Password expiration duration with one week grace period.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#password_expiration_duration SqlUser#password_expiration_duration}
    */
    readonly passwordExpirationDuration?: string;
}
export declare function sqlUserPasswordPolicyToTerraform(struct?: SqlUserPasswordPolicyOutputReference | SqlUserPasswordPolicy): any;
export declare class SqlUserPasswordPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlUserPasswordPolicy | undefined;
    set internalValue(value: SqlUserPasswordPolicy | undefined);
    private _allowedFailedAttempts?;
    get allowedFailedAttempts(): number;
    set allowedFailedAttempts(value: number);
    resetAllowedFailedAttempts(): void;
    get allowedFailedAttemptsInput(): number | undefined;
    private _enableFailedAttemptsCheck?;
    get enableFailedAttemptsCheck(): boolean | cdktf.IResolvable;
    set enableFailedAttemptsCheck(value: boolean | cdktf.IResolvable);
    resetEnableFailedAttemptsCheck(): void;
    get enableFailedAttemptsCheckInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePasswordVerification?;
    get enablePasswordVerification(): boolean | cdktf.IResolvable;
    set enablePasswordVerification(value: boolean | cdktf.IResolvable);
    resetEnablePasswordVerification(): void;
    get enablePasswordVerificationInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordExpirationDuration?;
    get passwordExpirationDuration(): string;
    set passwordExpirationDuration(value: string);
    resetPasswordExpirationDuration(): void;
    get passwordExpirationDurationInput(): string | undefined;
    private _status;
    get status(): SqlUserPasswordPolicyStatusList;
}
export interface SqlUserTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#create SqlUser#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#delete SqlUser#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_user#update SqlUser#update}
    */
    readonly update?: string;
}
export declare function sqlUserTimeoutsToTerraform(struct?: SqlUserTimeoutsOutputReference | SqlUserTimeouts | cdktf.IResolvable): any;
export declare class SqlUserTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlUserTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SqlUserTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/sql_user google_sql_user}
*/
export declare class SqlUser extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_sql_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/sql_user google_sql_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SqlUserConfig
    */
    constructor(scope: Construct, id: string, config: SqlUserConfig);
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _sqlServerUserDetails;
    get sqlServerUserDetails(): SqlUserSqlServerUserDetailsList;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _passwordPolicy;
    get passwordPolicy(): SqlUserPasswordPolicyOutputReference;
    putPasswordPolicy(value: SqlUserPasswordPolicy): void;
    resetPasswordPolicy(): void;
    get passwordPolicyInput(): SqlUserPasswordPolicy | undefined;
    private _timeouts;
    get timeouts(): SqlUserTimeoutsOutputReference;
    putTimeouts(value: SqlUserTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SqlUserTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
