import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VertexAiEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the Endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_endpoint#description VertexAiEndpoint#description}
    */
    readonly description?: string;
    /**
    * Required. The display name of the Endpoint. The name can be up to 128 characters long and can consist of any UTF-8 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_endpoint#display_name VertexAiEndpoint#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_endpoint#id VertexAiEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The labels with user-defined metadata to organize your Endpoints. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_endpoint#labels VertexAiEndpoint#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_endpoint#location VertexAiEndpoint#location}
    */
    readonly location: string;
    /**
    * The resource name of the Endpoint. The name must be numeric with no leading zeros and can be at most 10 digits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_endpoint#name VertexAiEndpoint#name}
    */
    readonly name: string;
    /**
    * The full name of the Google Compute Engine [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks) to which the Endpoint should be peered. Private services access must already be configured for the network. If left unspecified, the Endpoint is not peered with any network. Only one of the fields, network or enable_private_service_connect, can be set. [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert): 'projects/{project}/global/networks/{network}'. Where '{project}' is a project number, as in '12345', and '{network}' is network name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_endpoint#network VertexAiEndpoint#network}
    */
    readonly network?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_endpoint#project VertexAiEndpoint#project}
    */
    readonly project?: string;
    /**
    * encryption_spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_endpoint#encryption_spec VertexAiEndpoint#encryption_spec}
    */
    readonly encryptionSpec?: VertexAiEndpointEncryptionSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_endpoint#timeouts VertexAiEndpoint#timeouts}
    */
    readonly timeouts?: VertexAiEndpointTimeouts;
}
export interface VertexAiEndpointDeployedModelsAutomaticResources {
}
export declare function vertexAiEndpointDeployedModelsAutomaticResourcesToTerraform(struct?: VertexAiEndpointDeployedModelsAutomaticResources): any;
export declare class VertexAiEndpointDeployedModelsAutomaticResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VertexAiEndpointDeployedModelsAutomaticResources | undefined;
    set internalValue(value: VertexAiEndpointDeployedModelsAutomaticResources | undefined);
    get maxReplicaCount(): number;
    get minReplicaCount(): number;
}
export declare class VertexAiEndpointDeployedModelsAutomaticResourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VertexAiEndpointDeployedModelsAutomaticResourcesOutputReference;
}
export interface VertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecs {
}
export declare function vertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecsToTerraform(struct?: VertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecs): any;
export declare class VertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecs | undefined;
    set internalValue(value: VertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecs | undefined);
    get metricName(): string;
    get target(): number;
}
export declare class VertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecsOutputReference;
}
export interface VertexAiEndpointDeployedModelsDedicatedResourcesMachineSpec {
}
export declare function vertexAiEndpointDeployedModelsDedicatedResourcesMachineSpecToTerraform(struct?: VertexAiEndpointDeployedModelsDedicatedResourcesMachineSpec): any;
export declare class VertexAiEndpointDeployedModelsDedicatedResourcesMachineSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VertexAiEndpointDeployedModelsDedicatedResourcesMachineSpec | undefined;
    set internalValue(value: VertexAiEndpointDeployedModelsDedicatedResourcesMachineSpec | undefined);
    get acceleratorCount(): number;
    get acceleratorType(): string;
    get machineType(): string;
}
export declare class VertexAiEndpointDeployedModelsDedicatedResourcesMachineSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VertexAiEndpointDeployedModelsDedicatedResourcesMachineSpecOutputReference;
}
export interface VertexAiEndpointDeployedModelsDedicatedResources {
}
export declare function vertexAiEndpointDeployedModelsDedicatedResourcesToTerraform(struct?: VertexAiEndpointDeployedModelsDedicatedResources): any;
export declare class VertexAiEndpointDeployedModelsDedicatedResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VertexAiEndpointDeployedModelsDedicatedResources | undefined;
    set internalValue(value: VertexAiEndpointDeployedModelsDedicatedResources | undefined);
    private _autoscalingMetricSpecs;
    get autoscalingMetricSpecs(): VertexAiEndpointDeployedModelsDedicatedResourcesAutoscalingMetricSpecsList;
    private _machineSpec;
    get machineSpec(): VertexAiEndpointDeployedModelsDedicatedResourcesMachineSpecList;
    get maxReplicaCount(): number;
    get minReplicaCount(): number;
}
export declare class VertexAiEndpointDeployedModelsDedicatedResourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VertexAiEndpointDeployedModelsDedicatedResourcesOutputReference;
}
export interface VertexAiEndpointDeployedModelsPrivateEndpoints {
}
export declare function vertexAiEndpointDeployedModelsPrivateEndpointsToTerraform(struct?: VertexAiEndpointDeployedModelsPrivateEndpoints): any;
export declare class VertexAiEndpointDeployedModelsPrivateEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VertexAiEndpointDeployedModelsPrivateEndpoints | undefined;
    set internalValue(value: VertexAiEndpointDeployedModelsPrivateEndpoints | undefined);
    get explainHttpUri(): string;
    get healthHttpUri(): string;
    get predictHttpUri(): string;
    get serviceAttachment(): string;
}
export declare class VertexAiEndpointDeployedModelsPrivateEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VertexAiEndpointDeployedModelsPrivateEndpointsOutputReference;
}
export interface VertexAiEndpointDeployedModels {
}
export declare function vertexAiEndpointDeployedModelsToTerraform(struct?: VertexAiEndpointDeployedModels): any;
export declare class VertexAiEndpointDeployedModelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VertexAiEndpointDeployedModels | undefined;
    set internalValue(value: VertexAiEndpointDeployedModels | undefined);
    private _automaticResources;
    get automaticResources(): VertexAiEndpointDeployedModelsAutomaticResourcesList;
    get createTime(): string;
    private _dedicatedResources;
    get dedicatedResources(): VertexAiEndpointDeployedModelsDedicatedResourcesList;
    get displayName(): string;
    get enableAccessLogging(): cdktf.IResolvable;
    get enableContainerLogging(): cdktf.IResolvable;
    get id(): string;
    get model(): string;
    get modelVersionId(): string;
    private _privateEndpoints;
    get privateEndpoints(): VertexAiEndpointDeployedModelsPrivateEndpointsList;
    get serviceAccount(): string;
    get sharedResources(): string;
}
export declare class VertexAiEndpointDeployedModelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VertexAiEndpointDeployedModelsOutputReference;
}
export interface VertexAiEndpointEncryptionSpec {
    /**
    * Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: 'projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key'. The key needs to be in the same region as where the compute resource is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_endpoint#kms_key_name VertexAiEndpoint#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function vertexAiEndpointEncryptionSpecToTerraform(struct?: VertexAiEndpointEncryptionSpecOutputReference | VertexAiEndpointEncryptionSpec): any;
export declare class VertexAiEndpointEncryptionSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VertexAiEndpointEncryptionSpec | undefined;
    set internalValue(value: VertexAiEndpointEncryptionSpec | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface VertexAiEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_endpoint#create VertexAiEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_endpoint#delete VertexAiEndpoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_endpoint#update VertexAiEndpoint#update}
    */
    readonly update?: string;
}
export declare function vertexAiEndpointTimeoutsToTerraform(struct?: VertexAiEndpointTimeoutsOutputReference | VertexAiEndpointTimeouts | cdktf.IResolvable): any;
export declare class VertexAiEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VertexAiEndpointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VertexAiEndpointTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_endpoint google_vertex_ai_endpoint}
*/
export declare class VertexAiEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_endpoint";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_endpoint google_vertex_ai_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VertexAiEndpointConfig
    */
    constructor(scope: Construct, id: string, config: VertexAiEndpointConfig);
    get createTime(): string;
    private _deployedModels;
    get deployedModels(): VertexAiEndpointDeployedModelsList;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get modelDeploymentMonitoringJob(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _encryptionSpec;
    get encryptionSpec(): VertexAiEndpointEncryptionSpecOutputReference;
    putEncryptionSpec(value: VertexAiEndpointEncryptionSpec): void;
    resetEncryptionSpec(): void;
    get encryptionSpecInput(): VertexAiEndpointEncryptionSpec | undefined;
    private _timeouts;
    get timeouts(): VertexAiEndpointTimeoutsOutputReference;
    putTimeouts(value: VertexAiEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VertexAiEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
