import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VertexAiFeaturestoreEntitytypeFeatureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the feature.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype_feature#description VertexAiFeaturestoreEntitytypeFeature#description}
    */
    readonly description?: string;
    /**
    * The name of the Featurestore to use, in the format projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entitytype}.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype_feature#entitytype VertexAiFeaturestoreEntitytypeFeature#entitytype}
    */
    readonly entitytype: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype_feature#id VertexAiFeaturestoreEntitytypeFeature#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs to assign to the feature.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype_feature#labels VertexAiFeaturestoreEntitytypeFeature#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the feature. The feature can be up to 64 characters long and can consist only of ASCII Latin letters A-Z and a-z, underscore(_), and ASCII digits 0-9 starting with a letter. The value will be unique given an entity type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype_feature#name VertexAiFeaturestoreEntitytypeFeature#name}
    */
    readonly name?: string;
    /**
    * Type of Feature value. Immutable. https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.featurestores.entityTypes.features#ValueType
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype_feature#value_type VertexAiFeaturestoreEntitytypeFeature#value_type}
    */
    readonly valueType: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype_feature#timeouts VertexAiFeaturestoreEntitytypeFeature#timeouts}
    */
    readonly timeouts?: VertexAiFeaturestoreEntitytypeFeatureTimeouts;
}
export interface VertexAiFeaturestoreEntitytypeFeatureTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype_feature#create VertexAiFeaturestoreEntitytypeFeature#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype_feature#delete VertexAiFeaturestoreEntitytypeFeature#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype_feature#update VertexAiFeaturestoreEntitytypeFeature#update}
    */
    readonly update?: string;
}
export declare function vertexAiFeaturestoreEntitytypeFeatureTimeoutsToTerraform(struct?: VertexAiFeaturestoreEntitytypeFeatureTimeoutsOutputReference | VertexAiFeaturestoreEntitytypeFeatureTimeouts | cdktf.IResolvable): any;
export declare class VertexAiFeaturestoreEntitytypeFeatureTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VertexAiFeaturestoreEntitytypeFeatureTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VertexAiFeaturestoreEntitytypeFeatureTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype_feature google_vertex_ai_featurestore_entitytype_feature}
*/
export declare class VertexAiFeaturestoreEntitytypeFeature extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_featurestore_entitytype_feature";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_featurestore_entitytype_feature google_vertex_ai_featurestore_entitytype_feature} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VertexAiFeaturestoreEntitytypeFeatureConfig
    */
    constructor(scope: Construct, id: string, config: VertexAiFeaturestoreEntitytypeFeatureConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _entitytype?;
    get entitytype(): string;
    set entitytype(value: string);
    get entitytypeInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get updateTime(): string;
    private _valueType?;
    get valueType(): string;
    set valueType(value: string);
    get valueTypeInput(): string | undefined;
    private _timeouts;
    get timeouts(): VertexAiFeaturestoreEntitytypeFeatureTimeoutsOutputReference;
    putTimeouts(value: VertexAiFeaturestoreEntitytypeFeatureTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VertexAiFeaturestoreEntitytypeFeatureTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
