import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpcAccessConnectorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#id VpcAccessConnector#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The range of internal addresses that follows RFC 4632 notation. Example: '10.132.0.0/28'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#ip_cidr_range VpcAccessConnector#ip_cidr_range}
    */
    readonly ipCidrRange?: string;
    /**
    * Machine type of VM Instance underlying connector. Default is e2-micro
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#machine_type VpcAccessConnector#machine_type}
    */
    readonly machineType?: string;
    /**
    * Maximum value of instances in autoscaling group underlying the connector.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#max_instances VpcAccessConnector#max_instances}
    */
    readonly maxInstances?: number;
    /**
    * Maximum throughput of the connector in Mbps, must be greater than 'min_throughput'. Default is 300.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#max_throughput VpcAccessConnector#max_throughput}
    */
    readonly maxThroughput?: number;
    /**
    * Minimum value of instances in autoscaling group underlying the connector.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#min_instances VpcAccessConnector#min_instances}
    */
    readonly minInstances?: number;
    /**
    * Minimum throughput of the connector in Mbps. Default and min is 200.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#min_throughput VpcAccessConnector#min_throughput}
    */
    readonly minThroughput?: number;
    /**
    * The name of the resource (Max 25 characters).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#name VpcAccessConnector#name}
    */
    readonly name: string;
    /**
    * Name or self_link of the VPC network. Required if 'ip_cidr_range' is set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#network VpcAccessConnector#network}
    */
    readonly network?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#project VpcAccessConnector#project}
    */
    readonly project?: string;
    /**
    * Region where the VPC Access connector resides. If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#region VpcAccessConnector#region}
    */
    readonly region?: string;
    /**
    * subnet block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#subnet VpcAccessConnector#subnet}
    */
    readonly subnet?: VpcAccessConnectorSubnet;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#timeouts VpcAccessConnector#timeouts}
    */
    readonly timeouts?: VpcAccessConnectorTimeouts;
}
export interface VpcAccessConnectorSubnet {
    /**
    * Subnet name (relative, not fully qualified). E.g. if the full subnet selfLink is
  https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetName} the correct input for this field would be {subnetName}"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#name VpcAccessConnector#name}
    */
    readonly name?: string;
    /**
    * Project in which the subnet exists. If not set, this project is assumed to be the project for which the connector create request was issued.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#project_id VpcAccessConnector#project_id}
    */
    readonly projectId?: string;
}
export declare function vpcAccessConnectorSubnetToTerraform(struct?: VpcAccessConnectorSubnetOutputReference | VpcAccessConnectorSubnet): any;
export declare class VpcAccessConnectorSubnetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpcAccessConnectorSubnet | undefined;
    set internalValue(value: VpcAccessConnectorSubnet | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
}
export interface VpcAccessConnectorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#create VpcAccessConnector#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector#delete VpcAccessConnector#delete}
    */
    readonly delete?: string;
}
export declare function vpcAccessConnectorTimeoutsToTerraform(struct?: VpcAccessConnectorTimeoutsOutputReference | VpcAccessConnectorTimeouts | cdktf.IResolvable): any;
export declare class VpcAccessConnectorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpcAccessConnectorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VpcAccessConnectorTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector google_vpc_access_connector}
*/
export declare class VpcAccessConnector extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vpc_access_connector";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector google_vpc_access_connector} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpcAccessConnectorConfig
    */
    constructor(scope: Construct, id: string, config: VpcAccessConnectorConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipCidrRange?;
    get ipCidrRange(): string;
    set ipCidrRange(value: string);
    resetIpCidrRange(): void;
    get ipCidrRangeInput(): string | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _maxInstances?;
    get maxInstances(): number;
    set maxInstances(value: number);
    resetMaxInstances(): void;
    get maxInstancesInput(): number | undefined;
    private _maxThroughput?;
    get maxThroughput(): number;
    set maxThroughput(value: number);
    resetMaxThroughput(): void;
    get maxThroughputInput(): number | undefined;
    private _minInstances?;
    get minInstances(): number;
    set minInstances(value: number);
    resetMinInstances(): void;
    get minInstancesInput(): number | undefined;
    private _minThroughput?;
    get minThroughput(): number;
    set minThroughput(value: number);
    resetMinThroughput(): void;
    get minThroughputInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    get state(): string;
    private _subnet;
    get subnet(): VpcAccessConnectorSubnetOutputReference;
    putSubnet(value: VpcAccessConnectorSubnet): void;
    resetSubnet(): void;
    get subnetInput(): VpcAccessConnectorSubnet | undefined;
    private _timeouts;
    get timeouts(): VpcAccessConnectorTimeoutsOutputReference;
    putTimeouts(value: VpcAccessConnectorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VpcAccessConnectorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
