"use strict";
/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(globalThis["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] = globalThis["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] || []).push([["vendors-node_modules_jupyterlab_observables_lib_observablelist_js"],{

/***/ "../../node_modules/@jupyterlab/observables/lib/observablelist.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/observables/lib/observablelist.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ObservableList\": () => (/* binding */ ObservableList)\n/* harmony export */ });\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/algorithm */ \"webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm\");\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_1__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n/**\n * A concrete implementation of [[IObservableList]].\n */\nclass ObservableList {\n    /**\n     * Construct a new observable map.\n     */\n    constructor(options = {}) {\n        this._array = [];\n        this._isDisposed = false;\n        this._changed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);\n        if (options.values !== void 0) {\n            (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.each)(options.values, value => {\n                this._array.push(value);\n            });\n        }\n        this._itemCmp = options.itemCmp || Private.itemCmp;\n    }\n    /**\n     * The type of this object.\n     */\n    get type() {\n        return 'List';\n    }\n    /**\n     * A signal emitted when the list has changed.\n     */\n    get changed() {\n        return this._changed;\n    }\n    /**\n     * The length of the list.\n     */\n    get length() {\n        return this._array.length;\n    }\n    /**\n     * Test whether the list has been disposed.\n     */\n    get isDisposed() {\n        return this._isDisposed;\n    }\n    /**\n     * Dispose of the resources held by the list.\n     */\n    dispose() {\n        if (this._isDisposed) {\n            return;\n        }\n        this._isDisposed = true;\n        _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal.clearData(this);\n        this.clear();\n    }\n    /**\n     * Create an iterator over the values in the list.\n     *\n     * @returns A new iterator starting at the front of the list.\n     *\n     * #### Complexity\n     * Constant.\n     *\n     * #### Iterator Validity\n     * No changes.\n     */\n    iter() {\n        return new _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayIterator(this._array);\n    }\n    /**\n     * Get the value at the specified index.\n     *\n     * @param index - The positive integer index of interest.\n     *\n     * @returns The value at the specified index.\n     *\n     * #### Undefined Behavior\n     * An `index` which is non-integral or out of range.\n     */\n    get(index) {\n        return this._array[index];\n    }\n    /**\n     * Set the value at the specified index.\n     *\n     * @param index - The positive integer index of interest.\n     *\n     * @param value - The value to set at the specified index.\n     *\n     * #### Complexity\n     * Constant.\n     *\n     * #### Iterator Validity\n     * No changes.\n     *\n     * #### Undefined Behavior\n     * An `index` which is non-integral or out of range.\n     */\n    set(index, value) {\n        const oldValue = this._array[index];\n        if (value === undefined) {\n            throw new Error('Cannot set an undefined item');\n        }\n        // Bail if the value does not change.\n        const itemCmp = this._itemCmp;\n        if (itemCmp(oldValue, value)) {\n            return;\n        }\n        this._array[index] = value;\n        this._changed.emit({\n            type: 'set',\n            oldIndex: index,\n            newIndex: index,\n            oldValues: [oldValue],\n            newValues: [value]\n        });\n    }\n    /**\n     * Add a value to the end of the list.\n     *\n     * @param value - The value to add to the end of the list.\n     *\n     * @returns The new length of the list.\n     *\n     * #### Complexity\n     * Constant.\n     *\n     * #### Notes\n     * By convention, the oldIndex is set to -1 to indicate\n     * an push operation.\n     *\n     * #### Iterator Validity\n     * No changes.\n     */\n    push(value) {\n        const num = this._array.push(value);\n        this._changed.emit({\n            type: 'add',\n            oldIndex: -1,\n            newIndex: this.length - 1,\n            oldValues: [],\n            newValues: [value]\n        });\n        return num;\n    }\n    /**\n     * Insert a value into the list at a specific index.\n     *\n     * @param index - The index at which to insert the value.\n     *\n     * @param value - The value to set at the specified index.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Iterator Validity\n     * No changes.\n     *\n     * #### Notes\n     * The `index` will be clamped to the bounds of the list.\n     *\n     * By convention, the oldIndex is set to -2 to indicate\n     * an insert operation.\n     *\n     * The value -2 as oldIndex can be used to distinguish from the push\n     * method which will use a value -1.\n     *\n     * #### Undefined Behavior\n     * An `index` which is non-integral.\n     */\n    insert(index, value) {\n        if (index === this._array.length) {\n            this._array.push(value);\n        }\n        else {\n            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.insert(this._array, index, value);\n        }\n        this._changed.emit({\n            type: 'add',\n            oldIndex: -2,\n            newIndex: index,\n            oldValues: [],\n            newValues: [value]\n        });\n    }\n    /**\n     * Remove the first occurrence of a value from the list.\n     *\n     * @param value - The value of interest.\n     *\n     * @returns The index of the removed value, or `-1` if the value\n     *   is not contained in the list.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Iterator Validity\n     * Iterators pointing at the removed value and beyond are invalidated.\n     */\n    removeValue(value) {\n        const itemCmp = this._itemCmp;\n        const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.findFirstIndex(this._array, item => {\n            return itemCmp(item, value);\n        });\n        this.remove(index);\n        return index;\n    }\n    /**\n     * Remove and return the value at a specific index.\n     *\n     * @param index - The index of the value of interest.\n     *\n     * @returns The value at the specified index, or `undefined` if the\n     *   index is out of range.\n     *\n     * #### Complexity\n     * Constant.\n     *\n     * #### Iterator Validity\n     * Iterators pointing at the removed value and beyond are invalidated.\n     *\n     * #### Undefined Behavior\n     * An `index` which is non-integral.\n     */\n    remove(index) {\n        const value = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.removeAt(this._array, index);\n        if (value === undefined) {\n            return;\n        }\n        this._changed.emit({\n            type: 'remove',\n            oldIndex: index,\n            newIndex: -1,\n            newValues: [],\n            oldValues: [value]\n        });\n        return value;\n    }\n    /**\n     * Remove all values from the list.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Iterator Validity\n     * All current iterators are invalidated.\n     */\n    clear() {\n        const copy = this._array.slice();\n        this._array.length = 0;\n        this._changed.emit({\n            type: 'remove',\n            oldIndex: 0,\n            newIndex: 0,\n            newValues: [],\n            oldValues: copy\n        });\n    }\n    /**\n     * Move a value from one index to another.\n     *\n     * @parm fromIndex - The index of the element to move.\n     *\n     * @param toIndex - The index to move the element to.\n     *\n     * #### Complexity\n     * Constant.\n     *\n     * #### Iterator Validity\n     * Iterators pointing at the lesser of the `fromIndex` and the `toIndex`\n     * and beyond are invalidated.\n     *\n     * #### Undefined Behavior\n     * A `fromIndex` or a `toIndex` which is non-integral.\n     */\n    move(fromIndex, toIndex) {\n        if (this.length <= 1 || fromIndex === toIndex) {\n            return;\n        }\n        const values = [this._array[fromIndex]];\n        _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.move(this._array, fromIndex, toIndex);\n        this._changed.emit({\n            type: 'move',\n            oldIndex: fromIndex,\n            newIndex: toIndex,\n            oldValues: values,\n            newValues: values\n        });\n    }\n    /**\n     * Push a set of values to the back of the list.\n     *\n     * @param values - An iterable or array-like set of values to add.\n     *\n     * @returns The new length of the list.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Notes\n     * By convention, the oldIndex is set to -1 to indicate\n     * an push operation.\n     *\n     * #### Iterator Validity\n     * No changes.\n     */\n    pushAll(values) {\n        const newIndex = this.length;\n        (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.each)(values, value => {\n            this._array.push(value);\n        });\n        this._changed.emit({\n            type: 'add',\n            oldIndex: -1,\n            newIndex,\n            oldValues: [],\n            newValues: (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.toArray)(values)\n        });\n        return this.length;\n    }\n    /**\n     * Insert a set of items into the list at the specified index.\n     *\n     * @param index - The index at which to insert the values.\n     *\n     * @param values - The values to insert at the specified index.\n     *\n     * #### Complexity.\n     * Linear.\n     *\n     * #### Iterator Validity\n     * No changes.\n     *\n     * #### Notes\n     * The `index` will be clamped to the bounds of the list.\n     * By convention, the oldIndex is set to -2 to indicate\n     * an insert operation.\n     *\n     * #### Undefined Behavior.\n     * An `index` which is non-integral.\n     */\n    insertAll(index, values) {\n        const newIndex = index;\n        (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.each)(values, value => {\n            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.insert(this._array, index++, value);\n        });\n        this._changed.emit({\n            type: 'add',\n            oldIndex: -2,\n            newIndex,\n            oldValues: [],\n            newValues: (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.toArray)(values)\n        });\n    }\n    /**\n     * Remove a range of items from the list.\n     *\n     * @param startIndex - The start index of the range to remove (inclusive).\n     *\n     * @param endIndex - The end index of the range to remove (exclusive).\n     *\n     * @returns The new length of the list.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Iterator Validity\n     * Iterators pointing to the first removed value and beyond are invalid.\n     *\n     * #### Undefined Behavior\n     * A `startIndex` or `endIndex` which is non-integral.\n     */\n    removeRange(startIndex, endIndex) {\n        const oldValues = this._array.slice(startIndex, endIndex);\n        for (let i = startIndex; i < endIndex; i++) {\n            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.removeAt(this._array, startIndex);\n        }\n        this._changed.emit({\n            type: 'remove',\n            oldIndex: startIndex,\n            newIndex: -1,\n            oldValues,\n            newValues: []\n        });\n        return this.length;\n    }\n}\n/**\n * The namespace for module private data.\n */\nvar Private;\n(function (Private) {\n    /**\n     * The default strict equality item cmp.\n     */\n    function itemCmp(first, second) {\n        return first === second;\n    }\n    Private.itemCmp = itemCmp;\n})(Private || (Private = {}));\n//# sourceMappingURL=observablelist.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../../node_modules/@jupyterlab/observables/lib/observablelist.js?");

/***/ })

}]);