"""Generated by emqxlwm2m.codegen at 2020-11-22 12:13:49

LwM2M Object: LwM2M Server
ID: 1, URN: urn:oma:lwm2m:oma:1, Mandatory, Multiple
"""

from emqxlwm2m.lwm2m import *


class ShortServerID(Resource):
    """Short Server ID 0 - Integer, Single, Mandatory

    Used as link to associate server Object Instance.
    """

    rid = 0
    operations = R
    type = 'integer'
    range = '1-65535'
    unit = 'N/A'
    mandatory = True
    multiple = False


class Lifetime(Resource):
    """Lifetime 1 - Integer, Single, Mandatory

    Specify the lifetime of the registration in seconds (see Section 5.3
    Registration).
    """

    rid = 1
    operations = RW
    type = 'integer'
    range = 'N/A'
    unit = 's'
    mandatory = True
    multiple = False


class DefaultMinimumPeriod(Resource):
    """Default Minimum Period 2 - Integer, Single, Optional

    The default value the LwM2M Client should use for the Minimum Period
    of an Observation in the absence of this parameter being included in
    an Observation.

    If this Resource doesn’t exist, the default value is 0.
    """

    rid = 2
    operations = RW
    type = 'integer'
    range = 'N/A'
    unit = 's'
    mandatory = False
    multiple = False


class DefaultMaximumPeriod(Resource):
    """Default Maximum Period 3 - Integer, Single, Optional

    The default value the LwM2M Client should use for the Maximum Period
    of an Observation in the absence of this parameter being included in
    an Observation.
    """

    rid = 3
    operations = RW
    type = 'integer'
    range = 'N/A'
    unit = 's'
    mandatory = False
    multiple = False


class Disable(Resource):
    """Disable 4 - N/a, Single, Optional

    If this Resource is executed, this LwM2M Server Object is disabled
    for a certain period defined in the Disabled Timeout Resource. After
    receiving “Execute” operation, LwM2M Client MUST send response of
    the operation and perform de-registration process, and underlying
    network connection between the Client and Server MUST be
    disconnected to disable the LwM2M Server account.

    After the above process, the LwM2M Client MUST NOT send any message
    to the Server and ignore all the messages from the LwM2M Server for
    the period.
    """

    rid = 4
    operations = E
    type = 'N/A'
    range = 'N/A'
    unit = 'N/A'
    mandatory = False
    multiple = False


class DisableTimeout(Resource):
    """Disable Timeout 5 - Integer, Single, Optional

    A period to disable the Server. After this period, the LwM2M Client
    MUST perform registration process to the Server. If this Resource is
    not set, a default timeout value is 86400 (1 day).
    """

    rid = 5
    operations = RW
    type = 'integer'
    range = 'N/A'
    unit = 's'
    mandatory = False
    multiple = False


class NotificationStoringWhenDisabledOrOffline(Resource):
    """Notification Storing When Disabled or Offline 6 - Boolean, Single, Mandatory

    If true, the LwM2M Client stores “Notify” operations to the LwM2M
    Server while the LwM2M Server account is disabled or the LwM2M
    Client is offline. After the LwM2M Server account is enabled or the
    LwM2M Client is online, the LwM2M Client reports the stored “Notify”
    operations to the Server.

    If false, the LwM2M Client discards all the “Notify” operations or
    temporarily disables the Observe function while the LwM2M Server is
    disabled or the LwM2M Client is offline.

    The default value is true.
    The maximum number of storing Notifications per Server is up to the
    implementation.
    """

    rid = 6
    operations = RW
    type = 'boolean'
    range = 'N/A'
    unit = 'N/A'
    mandatory = True
    multiple = False


class Binding(Resource):
    """Binding 7 - String, Single, Mandatory

    This Resource defines the transport binding configured for the LwM2M
    Client.

    If the LwM2M Client supports the binding specified in this Resource,
    the LwM2M Client MUST use that transport for the Current Binding
    Mode.
    """

    rid = 7
    operations = RW
    type = 'string'
    range = 'The possible values of Resource are listed in 5.3.1.1'
    unit = 'N/A'
    mandatory = True
    multiple = False


class RegistrationUpdateTrigger(Resource):
    """Registration Update Trigger 8 - N/a, Single, Mandatory

    If this Resource is executed the LwM2M Client MUST perform an
    “Update” operation with this LwM2M Server using that transport for
    the Current Binding Mode.
    """

    rid = 8
    operations = E
    type = 'N/A'
    range = 'N/A'
    unit = 'N/A'
    mandatory = True
    multiple = False


class LwM2MServer(ObjectDef):
    """LwM2M Server Object 1 - Mandatory, Multiple

    This LwM2M Objects provides the data related to a LwM2M Server. A
    Bootstrap-Server has no such an Object Instance associated to it.
    """

    oid = 1
    mandatory = True
    multiple = True

    # ID=0, Integer, R, Single, Mandatory, range: 1-65535, unit: N/A
    short_server_id = ShortServerID()

    # ID=1, Integer, RW, Single, Mandatory, range: N/A, unit: s
    lifetime = Lifetime()

    # ID=2, Integer, RW, Single, Optional, range: N/A, unit: s
    default_minimum_period = DefaultMinimumPeriod()

    # ID=3, Integer, RW, Single, Optional, range: N/A, unit: s
    default_maximum_period = DefaultMaximumPeriod()

    # ID=4, N/a, E, Single, Optional, range: N/A, unit: N/A
    disable = Disable()

    # ID=5, Integer, RW, Single, Optional, range: N/A, unit: s
    disable_timeout = DisableTimeout()

    # ID=6, Boolean, RW, Single, Mandatory, range: N/A, unit: N/A
    notification_storing_when_disabled_or_offline = NotificationStoringWhenDisabledOrOffline()

    # ID=7, String, RW, Single, Mandatory, range: The possible values of Resource are listed in 5.3.1.1, unit: N/A
    binding = Binding()

    # ID=8, N/a, E, Single, Mandatory, range: N/A, unit: N/A
    registration_update_trigger = RegistrationUpdateTrigger()

