# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ansitoimg']

package_data = \
{'': ['*'], 'ansitoimg': ['resources/*']}

install_requires = \
['pillow>=7.1.2,<8.0.0',
 'pyppeteer>=0.2.2,<0.3.0',
 'pyyaml>=5.3.1,<6.0.0',
 'svgwrite>=1.4,<2.0']

setup_kwargs = {
    'name': 'ansitoimg',
    'version': '2020.2',
    'description': 'Convert an ansi string to an image. Great for adding terminal output into a readme.',
    'long_description': '[![Github top language](https://img.shields.io/github/languages/top/FHPythonUtils/AnsiToImg.svg?style=for-the-badge)](../../)\n[![Codacy grade](https://img.shields.io/codacy/grade/[proj].svg?style=for-the-badge)](https://www.codacy.com/gh/FHPythonUtils/AnsiToImg)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/AnsiToImg.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/AnsiToImg.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/AnsiToImg.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/AnsiToImg.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/AnsiToImg.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/ansitoimg.svg?style=for-the-badge)](https://pypi.org/project/ansitoimg/)\n[![PyPI Version](https://img.shields.io/pypi/v/ansitoimg.svg?style=for-the-badge)](https://pypi.org/project/ansitoimg/)\n\n<!-- omit in toc -->\n# AnsiToImg\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nConvert an ansi string to an image. Great for adding terminal output into a readme.\n\n- [Examples](#examples)\n\t- [SVG Image](#svg-image)\n\t- [Raster Image](#raster-image)\n\t- [SVGRaster Image](#svgraster-image)\n\t- [Windows Terminal](#windows-terminal)\n- [Choosing ansiToSVG ansiToRaster or ansiToSVGRaster](#choosing-ansitosvg-ansitoraster-or-ansitosvgraster)\n\t- [ansiToSVG](#ansitosvg)\n\t- [ansiToRaster](#ansitoraster)\n\t- [ansiToSVGRaster](#ansitosvgraster)\n- [Changelog](#changelog)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Download](#download)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n- [How to run](#how-to-run)\n\t- [With VSCode](#with-vscode)\n\t- [From the Terminal](#from-the-terminal)\n- [How to update, build and publish](#how-to-update-build-and-publish)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog-1)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\n## Examples\n\nHere is an example of some code and the images it produces:\n\nFunctions accept the following arguments:\n- ansiText - text to process\n- fileName - name of the file to write to\n- theme - a base24 theme. Defaults to atom one dark\n\n```python\nimport sys\nimport os\nfrom pathlib import Path\nimport platform\nimport ctypes\nfrom catimage.catimage import generateHDColour\n\nTHISDIR = str(Path(__file__).resolve().parent)\nsys.path.insert(0, os.path.dirname(THISDIR))\nfrom ansitoimg.txtrender import ansiToSVG, ansiToRaster\n\n\nif platform.system() == "Windows":\n\tkernel32 = ctypes.windll.kernel32\n\tkernel32.SetConsoleMode(kernel32.GetStdHandle(-11), 7)\n\nexample = "👋\\033[32mHello\\033[0m, \\033[34mWorld\\033[0m🌏\\033[31m!\\033[0m\\n\\033[41m👋\\033[0m\\033[43m🦄\\033[0m\\033[42m🐘\\033[0m\\033[3m\\033[9m13\\033[0m\\033[1m3\\033[0m\\033[4m7\\033[0m\\033[46m🍄\\033[0m\\033[44m🎃\\033[0m\\033[45m🐦\\033[0m"\nansiToSVG(example, THISDIR + "/example.svg")\nansiToRaster(example, THISDIR + "/example.png")\nansiToSVGRaster(example, THISDIR + "/svgExample.png")\n\nexample2 = "hello\\nworld\\n\\033[42m\\033[31mwe meet again\\033[0m\\nABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz😁😂🤣😃😄😅😆😉😊😋😎😍😘🥰😗😙😚☺🙂🤗🤩🤔🤨😐😑😶🙄😏😣😥😮🤐😯😪asdfghjk"\nansiToSVG(example2, THISDIR + "/example2.svg")\nansiToRaster(example2, THISDIR + "/example2.png")\nansiToSVGRaster(example2, THISDIR + "/svgExample2.png")\n\nexample3 = generateHDColour(THISDIR + "/test.png", 40)\nansiToSVG(example3, THISDIR + "/example3.svg")\nansiToRaster(example3, THISDIR + "/example3.png")\nansiToSVGRaster(example3, THISDIR + "/svgExample3.png")\n```\n\n### SVG Image\n![example](test/example.svg)\n\n![example2](test/example2.svg)\n\n![example3](test/example3.svg)\n\n### Raster Image\n![example](test/example.png)\n\n![example2](test/example2.png)\n\n![example3](test/example3.png)\n\n### SVGRaster Image\n![example](test/svgExample.png)\n\n![example2](test/svgExample2.png)\n\n![example3](test/svgExample3.png)\n\n### Windows Terminal\n\n![winterm](readme-assets/terminal.png)\n\n## Choosing ansiToSVG ansiToRaster or ansiToSVGRaster\n\n### ansiToSVG\nThis is better for the vast majority of cases as the image sizes are smaller\nfor reasonably simple ansi sequences. The image size scales proportionally\nwith the length of the ansi sequence. A large number of applications tend to\nopt for shorter sequences for output making `ansiToSVG` the better option.\n`ansiToSVG` also handles emoji as well as the OS does. For instance, on Windows\n10 one can expect full colour emoji. Image sizes can get out of hand for some\ncases such as catimage output as those tend to be very long ansi sequences.\n\n### ansiToRaster\nThe image size does not scale to the length of the ansi sequence but does scale\nto the number of lines of terminal output. This is ideal for output of complex\nansi sequences that would be huge if `ansiToSVG` were used. However, emojis are\nin black and white and show quite poorly on coloured backgrounds.\n\n### ansiToSVGRaster\nTakes the advantages that `ansiToRaster` has whilst keeping colour emojis, Yay!\nThis uses pyppeteer to fire up a headless browser which opens the svg and takes\na screenshot\n\n## Changelog\nSee the [CHANGELOG](/CHANGELOG.md) for more information.\n\n## Install With PIP\n\n```python\npip install ansitoimg\n```\n\nHead to https://pypi.org/project/ansitoimg/ for more info\n\n## Language information\n### Built for\nThis program has been written for Python 3 and has been tested with\nPython version 3.8.0 <https://www.python.org/downloads/release/python-380/>.\n\n## Install Python on Windows\n### Chocolatey\n```powershell\nchoco install python\n```\n### Download\nTo install Python, go to <https://www.python.org/> and download the latest\nversion.\n\n## Install Python on Linux\n### Apt\n```bash\nsudo apt install python3.8\n```\n\n## How to run\n### With VSCode\n1. Open the .py file in vscode\n2. Ensure a python 3.8 interpreter is selected (Ctrl+Shift+P > Python:Select\nInterpreter > Python 3.8)\n3. Run by pressing Ctrl+F5 (if you are prompted to install any modules, accept)\n### From the Terminal\n```bash\n./[file].py\n```\n\n## How to update, build and publish\n\n1. Ensure you have installed the following dependencies\n\tLinux\n\t```bash\n\twget dephell.org/install | python3.8\n\twget https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py | python3.8\n\t```\n\tWindows\n\t```powershell\n\t(wget dephell.org/install -UseBasicParsing).Content | python\n\t(wget https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py -UseBasicParsing).Content | python\n\t```\n2. Use poetry for the heavy lifting and dephell to generate requirements\n\t```bash\n\tpoetry update\n\tdephell deps convert\n\t```\n3. Build/ Publish\n\t```bash\n\tpoetry build\n\tpoetry publish\n\t```\n\tor\n\t```bash\n\tpoetry publish --build\n\t```\n## Community Files\n### Licence\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\nIn the interest of fostering an open and welcoming environment, we\nas contributors and maintainers pledge to make participation in our\nproject and our community a harassment-free experience for everyone.\nPlease see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md) for more information.\n\n### Contributing\nContributions are welcome, please see the [Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md) for more information.\n\n### Security\nThank you for improving the security of the project, please see the [Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md) for more information.\n\n### Support\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the [Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md) for more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/AnsiToImg',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
