# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-06-26 14:45
from __future__ import unicode_literals

import datetime
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='CandidateScrapedElection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('last_modified', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=200)),
                ('scraped_id', models.CharField(blank=True, max_length=3, verbose_name='election identification number')),
                ('sort_index', models.IntegerField(help_text='The index value is used to preserve sorting of elections, since multiple elections may occur in a year. A greater sort index corresponds to a more recent election.', null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='IncumbentScrapedElection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('last_modified', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=200)),
                ('session', models.IntegerField(verbose_name='session start year')),
                ('date', models.DateField(verbose_name='election date')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PropositionScrapedElection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('last_modified', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=200)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ScrapedCandidate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('last_modified', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=200, verbose_name='candidate name')),
                ('scraped_id', models.CharField(blank=True, max_length=7, verbose_name='candidate identification number')),
                ('office_name', models.CharField(blank=True, max_length=100, verbose_name='name of the office for which this candidate is running')),
                ('election', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='candidates', to='calaccess_scraped.CandidateScrapedElection')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ScrapedCandidateCommittee',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('last_modified', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=500, verbose_name='committee name')),
                ('scraped_id', models.CharField(max_length=7, verbose_name='committee identification number')),
                ('candidate_id', models.CharField(max_length=100)),
                ('status', models.CharField(max_length=100)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ScrapedDataVersion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('process_start_datetime', models.DateTimeField(default=datetime.datetime.now, help_text='Date and time when the scraping started', null=True, verbose_name='date and time processing started')),
                ('process_finish_datetime', models.DateTimeField(help_text='Date and time when the scraping finished', null=True, verbose_name='date and time update finished')),
            ],
            options={
                'ordering': ('-process_start_datetime',),
                'get_latest_by': 'process_start_datetime',
                'verbose_name': 'TRACKING: CAL-ACCESS scraped data version',
            },
        ),
        migrations.CreateModel(
            name='ScrapedIncumbent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('last_modified', models.DateTimeField(auto_now=True)),
                ('session', models.IntegerField(verbose_name='session start year')),
                ('category', models.CharField(max_length=100, verbose_name='office category')),
                ('office_name', models.CharField(max_length=100, verbose_name='name of the office')),
                ('name', models.CharField(max_length=200, verbose_name='name of the incumbent')),
                ('scraped_id', models.CharField(max_length=7, verbose_name='scraped identification number')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ScrapedProposition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('last_modified', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=200, verbose_name='proposition name')),
                ('scraped_id', models.CharField(max_length=200, verbose_name='proposition identification number')),
                ('election', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='propositions', to='calaccess_scraped.PropositionScrapedElection')),
            ],
            options={
                'ordering': ('-election', 'name'),
            },
        ),
        migrations.CreateModel(
            name='ScrapedPropositionCommittee',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('last_modified', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=500, verbose_name='committee name')),
                ('scraped_id', models.CharField(max_length=7, verbose_name='committee identification number')),
                ('position', models.CharField(help_text='Whether the committee supports or opposes the proposition', max_length=100)),
                ('proposition', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='calaccess_scraped.ScrapedProposition')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
