import sys
import os
sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))


import unittest
from pucktrick.duplicated import *
from pucktrick.utils import *
import pandas as pd
import numpy as np
from pandas.testing import assert_frame_equal


class Test_outlies(unittest.TestCase):
 
 def test_duplicateClassExtended(self):
     percentage=0.5
     num_rows = 20
     selection_criteria = "f4=='apple' or f3=='apple'"
     #selection_criteria='all'
     fake_df=create_fake_table(num_rows)
     column=['f4','f3']
     if selection_criteria=='all':
          old_len=len(fake_df)
     else:
         old_len=len(fake_df.query(selection_criteria))
     print("original")
     print(fake_df)
     strategy =  {'affected_features': column, 'selection_criteria': selection_criteria, 'function':None, 'percentage': percentage,'mode': 'new', 'perturbate_data': {'distribution': 'random', 'param': None, 'value': None, 'condition_logic': None}}
     error,noise_df=duplicate(fake_df,strategy)
     print("prima modifica")
     print(noise_df)
     percentage=0.7
     strategy =  {'affected_features': column, 'selection_criteria': selection_criteria, 'function':None, 'percentage': percentage,'mode': 'extended', 'perturbate_data': {'distribution': 'random', 'param': None, 'value': None, 'condition_logic': None}}
     error,noise1_df=duplicate(noise_df,strategy,fake_df)
     if error==0:
            noise_df=noise1_df
     print("seconda modifica")
     print(noise_df)
     
     if selection_criteria == "all" or selection_criteria is None:
          new_len=len(noise_df)
          print(new_len)
          diff=round((new_len-old_len)/old_len,1)
          print(diff)
     else:
          #selection_criteria,isAffected=affectedSelected(column,selection_criteria)
          #if isAffected==1:
          #      df_pref2=fake_df[column].add_prefix("puck_")
          #      fake_df=pd.concat([fake_df,df_pref2],axis=1)
          #      noise_df=pd.concat([noise_df,df_pref2],axis=1)
          new_len=len(noise_df.query(selection_criteria)[column])
          diff=round((new_len-old_len)/old_len,1)
          print(diff)
        
        # Verifica che il numero di modifiche sia corretto
     self.assertLessEqual(abs(diff-percentage),0.1)

if __name__ == "__main__":
    unittest.main()
