# -*- coding: utf-8 -*-
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

from google.cloud.gkehub_v1beta1.services.gke_hub_membership_service.client import (
    GkeHubMembershipServiceClient,
)
from google.cloud.gkehub_v1beta1.services.gke_hub_membership_service.async_client import (
    GkeHubMembershipServiceAsyncClient,
)

from google.cloud.gkehub_v1beta1.types.membership import Authority
from google.cloud.gkehub_v1beta1.types.membership import ConnectAgent
from google.cloud.gkehub_v1beta1.types.membership import ConnectAgentResource
from google.cloud.gkehub_v1beta1.types.membership import CreateMembershipRequest
from google.cloud.gkehub_v1beta1.types.membership import DeleteMembershipRequest
from google.cloud.gkehub_v1beta1.types.membership import GenerateConnectManifestRequest
from google.cloud.gkehub_v1beta1.types.membership import GenerateConnectManifestResponse
from google.cloud.gkehub_v1beta1.types.membership import (
    GenerateExclusivityManifestRequest,
)
from google.cloud.gkehub_v1beta1.types.membership import (
    GenerateExclusivityManifestResponse,
)
from google.cloud.gkehub_v1beta1.types.membership import GetMembershipRequest
from google.cloud.gkehub_v1beta1.types.membership import GkeCluster
from google.cloud.gkehub_v1beta1.types.membership import KubernetesMetadata
from google.cloud.gkehub_v1beta1.types.membership import KubernetesResource
from google.cloud.gkehub_v1beta1.types.membership import ListMembershipsRequest
from google.cloud.gkehub_v1beta1.types.membership import ListMembershipsResponse
from google.cloud.gkehub_v1beta1.types.membership import Membership
from google.cloud.gkehub_v1beta1.types.membership import MembershipEndpoint
from google.cloud.gkehub_v1beta1.types.membership import MembershipState
from google.cloud.gkehub_v1beta1.types.membership import OperationMetadata
from google.cloud.gkehub_v1beta1.types.membership import ResourceManifest
from google.cloud.gkehub_v1beta1.types.membership import ResourceOptions
from google.cloud.gkehub_v1beta1.types.membership import TypeMeta
from google.cloud.gkehub_v1beta1.types.membership import UpdateMembershipRequest
from google.cloud.gkehub_v1beta1.types.membership import ValidateExclusivityRequest
from google.cloud.gkehub_v1beta1.types.membership import ValidateExclusivityResponse

__all__ = (
    "GkeHubMembershipServiceClient",
    "GkeHubMembershipServiceAsyncClient",
    "Authority",
    "ConnectAgent",
    "ConnectAgentResource",
    "CreateMembershipRequest",
    "DeleteMembershipRequest",
    "GenerateConnectManifestRequest",
    "GenerateConnectManifestResponse",
    "GenerateExclusivityManifestRequest",
    "GenerateExclusivityManifestResponse",
    "GetMembershipRequest",
    "GkeCluster",
    "KubernetesMetadata",
    "KubernetesResource",
    "ListMembershipsRequest",
    "ListMembershipsResponse",
    "Membership",
    "MembershipEndpoint",
    "MembershipState",
    "OperationMetadata",
    "ResourceManifest",
    "ResourceOptions",
    "TypeMeta",
    "UpdateMembershipRequest",
    "ValidateExclusivityRequest",
    "ValidateExclusivityResponse",
)
