# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['coveo_stew', 'coveo_stew.ci', 'coveo_stew.metadata']

package_data = \
{'': ['*'], 'coveo_stew': ['package_resources/*']}

install_requires = \
['click>=8.1',
 'coveo-functools>=2.0.0,<3.0.0',
 'coveo-itertools>=2.0.0,<3.0.0',
 'coveo-styles>=2.1.2,<3.0.0',
 'coveo-systools>=2.0.10,<3.0.0',
 'junit-xml',
 'packaging',
 'toml',
 'tomlkit']

entry_points = \
{'console_scripts': ['stew = coveo_stew.commands:stew']}

setup_kwargs = {
    'name': 'coveo-stew',
    'version': '3.0.17a1',
    'description': 'Opinionated python packaging and development utilities',
    'long_description': '# Upgrading from 2.x?\n\nThe 3.0 update contains breaking changes: \n`poetry`, `mypy` and `black` are no longer distributed with `coveo-stew`.\n\nPlease refer to the [upgrade guide](./README_UPGRADE.md#upgrading-from-2x-to-3x) for more information and resolution steps. \n\n\n# coveo-stew\n\ncoveo-stew delivers a complete Continuous Integration (CI) and Continuous Delivery (CD) solution\nusing [poetry](https://python-poetry.org) as its backend.\n\n\n## CI tools\n- Config-free pytest, mypy and black runners\n- Add your own linters and tools\n- JUnit report generation\n- GitHub Action that runs all your CI tools\n\nSimilar to: tox\n\n## CD tools\n- GitHub Action for Continuous Delivery (CD) (publish to pypi)\n- Automated "patch" version bumps (requires a `pypi` server)\n- Can download locked dependencies into a folder, for offline distribution\n\nSimilar to: poetry, flit, pbr, setuptools\n\n## Multiple projects\n- Support for several isolated poetry projects in one GitHub repository\n- Support for local path references\n- A "one ring to rule them all" virtual environment that includes all subprojects within the repository\n- Batch operations\n- Note: Single projects are also supported! 😅\n\nSimilar to: nothing! it\'s unique! 😎 \n\n\n# Prerequisites\n\n*Changed in 3.0*: `poetry` is no longer provided out-of-the-box.\n\nYou need [poetry](https://python-poetry.org/) installed on your system, and it must be available through the `PATH`.\n\nThe `3.0` version of `coveo-stew` is designed to work with poetry `1.1.13`, `1.1.14` and `1.1.15`. \n\n\nWhile it is compatible with older versions, old poetry issues \nsuch as [this](https://github.com/python-poetry/poetry/issues/3189) \nand [this](https://github.com/python-poetry/poetry/issues/3254) \nwill cause `stew` to misbehave.\n\nIf you need to work with an older version of poetry, \nconsider using `coveo-stew < 3.0` which had workarounds implemented around these issues.\n\n\n# Installation\n\nJust like poetry, `stew` is a CLI tool that you install in your system.\n\nIt is recommended to install using [pipx](https://github.com/pipxproject/pipx) in order to isolate this into a nice little space:\n\n```\npip install pipx --user\npipx install coveo-stew\n```\n\nIf you don\'t use pipx, make sure to isolate the installation into a virtual environment.\n\n\n# GitHub Action\n\nThis action checkouts the code, installs python, poetry and stew, and proceeds to run "stew ci" on a python project.\n\n## Usage\n\n```yml\njobs:\n  stew-ci:\n    runs-on: ubuntu-latest\n    steps:\n      - uses: coveo/stew@main\n        with:\n          python-version: "3.10"\n          project-name: your-project-name\n```\n\nSee additional options and documentation in [the action file.](action.yml)\n\n\n## GitHub Action Step Report\n\nWhen running in a GitHub context, a step summary will automatically be generated.\nThis summary can be seen in the `Summary` tab of a workflow run view in GitHub.\n\nYou can disable this feature by launching `stew ci` with `--no-github-step-report`.\n\n\n# Repository Structure\n\nPlease read these guides in order to learn how to organize your repository for maximum compatibility:\n\n- [For a single library](README_SINGLE_LIBRARY.md)\n- [For multiple libraries](README_MULTIPLE_LIBRARIES.md)\n\n\n# Commands\n\n## General command usage\n\nUnless a project name is specified, most commands will operate on all projects in a git repository based on the current working folder:\n\n- `stew <command>`\n    - Perform a command on all projects\n- `stew <command> --help`\n    - Obtain help about a particular command\n- `stew <command> <project-name>`\n    - Perform the command on all projects with `<project-name>` in their name (partial match)\n- `stew <command> <project-name> --exact-match`\n    - Disable partial project name matching\n\nThe main commands are explained below.\n\n\n## `stew ci`\n\nThe main show; it runs all CI tools on one or multiple projects.\n\nErrors will show in the console, and junit xml reports will be generated inside the `.ci` folder.\n\nWithout configuration, this command will run the following checks:\n\n- mypy (using opinionated, strict rules)\n  - Note: `mypy` is not provided with `coveo-stew`. See [builtin-runners](#builtin-runners) for info.\n- poetry check\n- stew check-outdated\n\nOptions:\n\n- `--fix` will reformat the code if `black` fails. Additional fix routines may be added in the future.\n- `--check <runner>` will launch only that runner. This option can be repeated.\n- `--skip <runner>` will skip that runner. Takes precedence over `--check`. This option can be repeated.\n- `--quick` skips running `poetry install --remove-untracked` before running the checks.\n- `--no-github-step-report` can be used to disable Step Report generation when running in a GitHub context.\n\nThe configuration for this feature is explained in more details in the [runners](#runners-stew-ci) section.\n\n## `stew build`\n\nStore the project and its **locked dependencies** to disk, so it can be installed without contacting a `pypi` server.\n\nOptimally used to create truly repeatable builds and workflows (e.g.: containerized images, cloud storage, etc).\n\nThe folder can later be installed offline with `pip install --no-index --find-links <folder> <project-name>`.\n\n\nOptions:\n\n- `--directory` specifies where the wheels should be downloaded.\n- `--python` may be used to target a different python. It\'s important to use the same python version, architecture and OS than the target system.\n\n**Make sure your target `<folder>` is clean**: Keep in mind that `pip` will still use the `pyproject.toml` constraints when installing, not `poetry.lock`. \nThe locked version system works when the locked version is the only thing that `pip` can find in the `<folder>`.\n\n\n## `stew check-outdated` and `stew fix-outdated` \n\nChecks for out-of-date files or automatically update them.\n\nSummary of actions:\n- `poetry lock` if `pyproject.toml` changed but not the `poetry.lock`\n- `stew pull-dev-requirements` if a pydev project\'s dev-requirements are out of sync\n\n\n## `stew pull-dev-requirements`\n\nOnly useful on `pydev` projects (see about [multiple-libraries](README_MULTIPLE_LIBRARIES.md)).\nIt pulls the dev requirements from the local projects in order to aggregate them into the dev requirements of the root project.\n\nNote: This command uses the `dev` group to identify test dependencies.\nThis can be defined as `tool.poetry.dev-dependencies` (poetry 1.1.15) or `tool.poetry.group.dev.dependencies`.\nThe group name cannot be customized, feel free to contribute the feature if that\'s useful to you.\n\n\n## `stew bump`\n\nCalls `poetry lock` on all projects.\n\n\n## `stew refresh`\n\nCalls `poetry install` on all projects.\n\n\n## `stew fresh-eggs`\n\nClears the `.egg-info` folder from your projects. Usually followed by a `poetry install` or a `stew refresh`.\n\nUse this if you change a `[tool.poetry.scripts]` section, else the changes will not be honored.\n\n\n## `stew locate <project>`\n\nReturns the path to a project:\n\n```\n$ stew locate coveo-stew\n/home/jonapich/code/stew/coveo-stew\n```\n\n# Configuration\n\nConfiguration is done through each `pyproject.toml` file; default values are shown:\n\n```\n[tool.stew.ci]\nmypy = true\npytest = false\nblack = false\npoetry-check = true\ncheck-outdated = true\noffline-build = false\n```\n\nYou don\'t have to include the `[tool.stew.ci]` section at all if these defaults suit you!\n\n\n# Runners (stew ci)\n\n*Changed in coveo-stew 3.0*: mypy and black are no longer provided out-of-the-box.\n\nIn order to use a builtin or custom runner, you must have it installed. These locations are supported:\n\n- Recommended: The runner is in the project\'s virtual environment (most likely as a dev dependency in `pyproject.toml`)\n- Alternative: The runner is installed in your system and available through the PATH\n\nWe strongly suggest pinning them to your\n`pyproject.toml` file in the `[tool.poetry.dev-dependencies]` section.\n\nThis way, mypy won\'t surprise you with new failures when they release new versions! 😎\n\nNote: You can override and customize most runners by [rewriting them as custom runners.](#custom-runners)\n\n\n## Builtin Runners\n\n### mypy\n\nA strict mypy configuration is provided. \n\nYou can provide your own mypy configuration, but you\'ll have to specify the `set-config` option: \n\n```\n[tool.stew.ci]\n\n# disable stew\'s strict mypy config (i.e.: let mypy find its config)\nmypy = { set-config = False } \n\n# use a specific config (path relative to `pyproject.toml`\'s folder)\nmypy = { set-config = "mypy.ini" }\n```\n\nSee https://mypy.readthedocs.io/en/stable/config_file.html#using-a-pyproject-toml\n\n### pytest\n\nPytest is configured to run with `--doctest-modules --tb=short --durations=5` as well as JUnit report generation.\n\nSome additional options are available:\n\n```\n[tool.stew.ci]\n\n# configure the markers to test (i.e.: `-m`)\npytest = { marker-expression = \'not docker_tests\' }\n\n# disable the doctests\npytest = { doctest-modules = False }\n```\n\n\n### black\n\nBlack supports the `pyproject.toml` file natively:\n\n```\n[tool.black]\nline-length = 100\n```\n\nRef: [black documentation](https://black.readthedocs.io/en/stable/usage_and_configuration/the_basics.html#configuration-via-a-file)\n\n\n### poetry-check\n\nRuns `poetry check` on each project.\n\n\n### check-outdated\n\nRuns `stew check-outdated`.\n\nNote: This runner cannot be overridden, but it can be disabled.\n\n\n### offline-build\n\nRuns `stew build` to a temporary folder and ensures that pip is able to reinstall everything from there.\n\nNote: This runner cannot be overridden, but it can be disabled.\n\n\n## Custom Runners\n\nYou can add your own runners to `stew ci`. \nYou can also redefine a builtin runner completely.\n\nIn this example, we create runners for flake8, bandit and isort. We also redefine the pytest runner:\n\n\n```\n[tool.stew.ci.custom-runners]\nflake8 = true\nbandit = { check-args = ["--quiet", "--recursive", "."] }\n\n# some may prefer this toml syntax:\n[tool.stew.ci.custom-runners.isort]\ncheck-args = ["--check", ".", "--profile black"]\nautofix-args = [".", "--profile black"]\n\n[tool.stew.ci.custom-runners.pytest] \ncheck-args = ["--tb=long", "--junitxml=.ci/pytest-results.xml"]\n```\n\nWhen a builtin runner such as pytest is redefined as a custom runner, you must provide all the arguments.\nIn this case, not passing `--junitxml` would mean that we lose the report that used to be in the `.ci/` directory. \n\n\n### Options\n\nThe following options are supported for custom runners:\n\n- name: You can specify the module name if it differs from the name of the tool.\n  - Important: Runners are called through `python -m <name>`, not through the shell! \n- check-args: The arguments to invoke the check.\n- autofix-args: The arguments to invoke the autofix. Provide the empty string "" in order to run without arguments.\n- check-failed-exit-codes: A list of ints denoting the exit codes to consider "failed" (anything else will be "error"). 0 is always a success. default is `[1]`.\n- create-generic-report: Whether to create a generic pass/fail JUnit report for this check.\n- working-directory: The default is "project" which corresponds to the project\'s `pyproject.toml` file. You can change it to "repository" in order to run from the root.\n\nThe `args` and `check-args` can be:\n\n- A string\n  - Such as a single argument "--check"\n  - Such as a path "."\n  - Such as an option "--profile black"\n  - But NOT as a combo of the above: "--check . --profile black" will most likely not work.\n\n- A list of string:\n  - Any combination of the "string" rules explained above.\n\n\n# FAQ, Tips and Tricks\n\n## constraints vs locks - where do they apply?\n\nWhen you call `poetry install`, you end up installing packages based on the `poetry.lock` file.\nThe resulting packages will always be the same, no matter what.\nThis is the dev scenario.\n\nWhen you call `pip install`, you are installing packages based on the constraints placed in a `pyproject.toml` or a `setup.py` file.\nUnless the constraints are hard pinned versions, the resulting packages are not guaranteed and will depend on the point in time when the installation is performed, among other factors.\nThis is the shared library scenario.\n\nWhen you use poetry, you cover the two scenarios above.\n\nThe third scenario is the private business use case: you want to freeze your dependencies in time so that everything from the developer to the CI servers to the production system is identical.\nEssentially, you want `poetry install` without the dev requirements.\n\nThis functionality is provided out of the box by `stew build`, which creates a pip-installable package from the lock file that you can then stash in a private storage of your choice or pass around your deployments.\n\n\n## How to provision a business production system / how to freeze your project for "offline" distribution\n\nYou can keep `poetry` and `stew` off your production environment by creating a frozen archive of your application or library from your CI servers (docker used as example):\n\n- Use the `stew build` tool which:\n    - performs a `poetry build` on your project\n    - calls `pip download` based on the content of the lock file\n    - Moves the artifacts to the `.wheels` folder of your repo\n- Recommended: Use the `--python` switch when calling `stew build` to specify which python executable to use! Make sure to use a python interpreter that matches the os/arch/bits of the system you want to provision.\n\nThe content in `.wheels` can then be zipped and moved around. A typical scenario is to push it into a Docker Container:\n\n- Include the `.wheels` folder into your Docker build context\n- In your Dockerfile:\n    - ADD the `.wheels` folder\n    - Manage the `pip` version! Either update it to latest, or pin it to something.\n    - Prepare a python environment\n        - Use `python -m venv <location>` to create a virtual environment natively.\n        - Note the executable location... typically (`location/bin/python` or `location/Scripts/python.exe`)\n    - Install your application into the python environment you just created:\n        - Use `<venv-python-executable> -m pip install <your-package> --no-index --find-links <wheels-folder-location>`\n    - You may delete the `.wheels` folder if you want. Consider keeping a copy of the lock file within the docker image, for reference.\n\nTo make sure you use the python interpreter that matches the os/arch/bits of the system you want to provision, you can run `stew build` directly when building the container image.\nIn order to do so without packaging `stew` in production, you can use [multi-stage builds](https://docs.docker.com/develop/develop-images/multistage-build/).\n\n## How to hook your IDE with the virtual environment\n\nIf your IDE supports poetry, it should detect and use the `pyproject.toml` file.\n\nTo set it up manually:\n\n1. Call `poetry install` from the location of the `pyproject.toml` file\n1. Obtain the location of the virtual environment (i.e.: `poetry env list --full-path`)\n1. Configure your IDE to use the python interpreter from that location\n\nYour IDE should proceed to analyze the environment and will pick up all imports automatically, \nregardless of your PYTHONPATH or your working directory.\nSince the local source is editable, any change to the source code will be reflected on the next interpreter run.\n\nIf you use the multiple-projects approach, you should hook your IDE to the `pydev` environment. See [this documentation](./README_MULTIPLE_LIBRARIES.md) for more information.\n\n\n## Using the virtual environment without activating it\n\nUsing the correct interpreter is all you need to do. \nThere is no activation script or environment variables to set up: the interpreter executable inside the virtual environment folder is a fully bootstrapped and isolated environment.\n\n- A python dockerfile may call `<venv-python-exec>` directly in the dockerfile\'s CMD\n- A service that spawns other processes should receive the path to the `<venv-python-exec>`\n\n[Use the `-m` switch](https://docs.python.org/3/using/cmdline.html#cmdoption-m) in order to launch your app!\n',
    'author': 'Jonathan Piché',
    'author_email': 'tools@coveo.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/coveo/stew',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>3.8.0,<4',
}


setup(**setup_kwargs)
