import * as kms from '@aws-cdk/aws-kms';
import * as s3 from '@aws-cdk/aws-s3';
import * as sns from '@aws-cdk/aws-sns';
import * as cdk from '@aws-cdk/core';
import { LakeType } from '..';
import { Stage } from '../data-lake';
import { DataProduct } from '../data-product';
import { Pipeline, DataSetLocation } from '../pipeline';
/**
 * @experimental
 */
export interface DataSetProperties {
    /**
     * @experimental
     */
    readonly encryptionKey?: kms.Key;
    /**
     * @experimental
     */
    readonly logBucket: s3.Bucket;
    /**
     * @experimental
     */
    readonly stage: Stage;
    /**
     * @experimental
     */
    readonly pipeline: Pipeline;
    /**
     * @experimental
     */
    readonly dataProduct: DataProduct;
    /**
     * @experimental
     */
    readonly s3BucketProps: s3.BucketProps | undefined;
    /**
     * @experimental
     */
    readonly lakeType: LakeType;
}
/**
 * @experimental
 */
export interface DataSetResult {
    /**
     * @experimental
     */
    readonly destinationBucketName?: string;
    /**
     * @experimental
     */
    readonly destinationPrefix: string;
    /**
     * @experimental
     */
    readonly sourceBucketName: string | undefined;
    /**
     * @experimental
     */
    readonly sourceKeys: string[] | undefined;
}
/**
 * @experimental
 */
export declare class DataSet extends cdk.Construct {
    /**
     * @experimental
     */
    readonly name: string;
    /**
     * @experimental
     */
    readonly lakeType: LakeType;
    /**
     * @experimental
     */
    readonly dropLocation?: DataSetLocation;
    /**
     * @experimental
     */
    readonly rawBucketName: string;
    /**
     * @experimental
     */
    readonly trustedBucketName: string;
    /**
     * @experimental
     */
    readonly refinedBucketName: string;
    /**
     * @experimental
     */
    readonly encryptionKey?: kms.Key;
    /**
     * @experimental
     */
    readonly downloadLocations?: DataSetResult;
    /**
     * @experimental
     */
    s3NotificationTopic?: sns.Topic;
    /**
     * @experimental
     */
    readonly pipeline: Pipeline;
    /**
     * @experimental
     */
    readonly dataProduct: DataProduct;
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props: DataSetProperties);
    private createS3NotificationTopic;
}
