"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataSet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const s3sns = require("@aws-cdk/aws-s3-notifications");
const sns = require("@aws-cdk/aws-sns");
const cdk = require("@aws-cdk/core");
const __1 = require("..");
const data_lake_bucket_1 = require("../data-lake-bucket");
const utils_1 = require("../utils");
/**
 * @experimental
 */
class DataSet extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.name = props.pipeline.name;
        this.dropLocation = props.pipeline.dataSetDropLocation;
        this.pipeline = props.pipeline;
        this.dataProduct = props.dataProduct;
        this.lakeType = props.lakeType;
        this.rawBucketName = utils_1.buildS3BucketName({
            name: props.pipeline.name,
            accountId: this.dataProduct.accountId,
            resourceUse: 'raw',
            stage: props.stage,
        });
        this.trustedBucketName = utils_1.buildS3BucketName({
            name: props.pipeline.name,
            accountId: this.dataProduct.accountId,
            resourceUse: 'trusted',
            stage: props.stage,
        });
        this.refinedBucketName = utils_1.buildS3BucketName({
            name: props.pipeline.name,
            accountId: this.dataProduct.accountId,
            resourceUse: 'refined',
            stage: props.stage,
        });
        const dataCatalogAccountId = props.dataProduct.dataCatalogAccountId ?
            props.dataProduct.dataCatalogAccountId : props.dataProduct.accountId;
        const crossAccount = props.dataProduct.dataCatalogAccountId ?
            props.dataProduct.dataCatalogAccountId != props.dataProduct.accountId ? true : false : false;
        // only create the buckets in the data owner account if using in multi account scenario
        if (props.lakeType === __1.LakeType.DATA_PRODUCT || props.lakeType === __1.LakeType.DATA_PRODUCT_AND_CATALOG) {
            const rawBucket = new data_lake_bucket_1.DataLakeBucket(this, `s3-raw-bucket-${props.pipeline.name}`, {
                bucketName: this.rawBucketName,
                dataCatalogAccountId: dataCatalogAccountId,
                logBucket: props.logBucket,
                crossAccount: crossAccount,
                s3Properties: props.s3BucketProps,
            }).bucket;
            const trustedBucket = new data_lake_bucket_1.DataLakeBucket(this, `s3-trusted-bucket-${props.pipeline.name}`, {
                bucketName: this.trustedBucketName,
                dataCatalogAccountId: dataCatalogAccountId,
                logBucket: props.logBucket,
                crossAccount: crossAccount,
                s3Properties: props.s3BucketProps,
            }).bucket;
            const refinedBucket = new data_lake_bucket_1.DataLakeBucket(this, `s3-refined-bucket-${props.pipeline.name}`, {
                bucketName: this.refinedBucketName,
                dataCatalogAccountId: dataCatalogAccountId,
                logBucket: props.logBucket,
                crossAccount: crossAccount,
                s3Properties: props.s3BucketProps,
            }).bucket;
            if (props.pipeline.s3NotificationProps) {
                this.createS3NotificationTopic(props.pipeline.s3NotificationProps, rawBucket);
                this.createS3NotificationTopic(props.pipeline.s3NotificationProps, trustedBucket);
                this.createS3NotificationTopic(props.pipeline.s3NotificationProps, refinedBucket);
            }
            if (this.dropLocation) {
                this.downloadLocations = {
                    destinationPrefix: props.pipeline.destinationPrefix,
                    destinationBucketName: utils_1.getDataSetBucketName(this.dropLocation, this),
                    sourceBucketName: props.pipeline.s3Properties ? props.pipeline.s3Properties.sourceBucketName : undefined,
                    sourceKeys: props.pipeline.s3Properties ? props.pipeline.s3Properties.sourceKeys : undefined,
                };
            }
        }
    }
    createS3NotificationTopic(s3NotificationProps, bucket) {
        this.s3NotificationTopic = new sns.Topic(this, 'sns-datalake-notification-topic');
        bucket.addEventNotification(s3NotificationProps.event, new s3sns.SnsDestination(this.s3NotificationTopic), {
            prefix: s3NotificationProps.prefix,
            suffix: s3NotificationProps.suffix,
        });
    }
}
exports.DataSet = DataSet;
_a = JSII_RTTI_SYMBOL_1;
DataSet[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.DataSet", version: "0.0.39" };
//# sourceMappingURL=data:application/json;base64,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