"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlueJobOps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class GlueJobOps extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.job = props.job;
        this.dashboard = new cloudwatch.Dashboard(this, 'dashboard', {
            dashboardName: `ETL_${this.job.name}`,
        });
        this.jvmHeapSizeExceeding80PercentAlarm = new cloudwatch.Alarm(this, 'jvm-heapSize-exceeding80percent-alarm', {
            alarmName: `${this.job.name} JvmHeapSizeExceeding80`,
            alarmDescription: `Jvm Heap Size exceeding 80% glue job (${this.job.name})`,
            metric: this.job.jvmHeapUsageMetric(),
            threshold: 0.8,
            evaluationPeriods: 1,
            datapointsToAlarm: 1,
            period: cdk.Duration.days(1),
            statistic: cloudwatch.Statistic.MAXIMUM,
            treatMissingData: cloudwatch.TreatMissingData.NOT_BREACHING,
            comparisonOperator: cloudwatch.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
            ...(props.jvmHeapSizeExceeding80percent || {}),
        });
        this.jvmHeapSizeExceeding90PercentAlarm = new cloudwatch.Alarm(this, 'jvm-heapSize-exceeding90Percent-alarm', {
            alarmName: `${this.job.name} JvmHeapSizeExceeding90`,
            alarmDescription: `Jvm Heap Size exceeding 90% glue job (${this.job.name})`,
            metric: this.job.jvmHeapUsageMetric(),
            threshold: 0.9,
            evaluationPeriods: 1,
            datapointsToAlarm: 1,
            period: cdk.Duration.days(1),
            statistic: cloudwatch.Statistic.MAXIMUM,
            treatMissingData: cloudwatch.TreatMissingData.NOT_BREACHING,
            comparisonOperator: cloudwatch.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
            ...(props.jvmHeapSizeExceeding90percent || {}),
        });
        this.metricExecutionFailureAlarm = new cloudwatch.Alarm(this, 'metric-execution-failure-alarm', {
            alarmName: `${this.job.name} ExecutionFailure`,
            alarmDescription: `Error while running the Glue job ${this.job.name} on the current attempt. There might be job retries after this error.`,
            metric: this.job.metricFailure(),
            comparisonOperator: cloudwatch.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
            threshold: 1,
            evaluationPeriods: 1,
            treatMissingData: cloudwatch.TreatMissingData.NOT_BREACHING,
            ...(props.metricExecutionFailure || {}),
        });
        this.metricAllExecutionAttemptsFailedAlarm = new cloudwatch.Alarm(this, 'metric-all-execution-attempts-failed-alarm', {
            alarmName: `${this.job.name} AllExecutionAttemptsFailed`,
            alarmDescription: `Error while running the Glue job ${this.job.name} on the last attempt. There will be no retries of the job after this error.`,
            metric: this.job.metricAllExecutionAttemptsFailed(),
            comparisonOperator: cloudwatch.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
            threshold: 1,
            evaluationPeriods: 1,
            treatMissingData: cloudwatch.TreatMissingData.NOT_BREACHING,
            ...(props.metricAllExecutionAttemptsFailed || {}),
        });
        this.alarmsSev2 = [
            this.jvmHeapSizeExceeding90PercentAlarm,
            this.metricAllExecutionAttemptsFailedAlarm,
        ];
        this.alarmsSev3 = [
            this.jvmHeapSizeExceeding80PercentAlarm,
            this.metricExecutionFailureAlarm,
        ];
        this.setupDashboard();
    }
    addWidgets(widgets) {
        for (let i = 0; i < widgets.length; i += 4) {
            this.dashboard.addWidgets(...widgets.slice(i, i + 4));
        }
    }
    setupDashboard() {
        this.dashboard.addWidgets(new cloudwatch.TextWidget({
            markdown: `# ${this.job.name} Job Result`,
            height: 1,
            width: 24,
        }));
        const jobResultWidgets = [
            new cloudwatch.GraphWidget({
                left: [
                    new cloudwatch.MathExpression({
                        expression: `SEARCH('MetricName="TriggeredRules" RuleName="${this.job.metricSuccessRule.ruleName}"', 'Sum', 900)`,
                        usingMetrics: {},
                        label: 'Success Count',
                    }),
                ],
                title: 'Success Count',
                height: 6,
                width: 6,
            }),
            new cloudwatch.GraphWidget({
                left: [
                    new cloudwatch.MathExpression({
                        expression: `SEARCH('MetricName="TriggeredRules" RuleName="${this.job.metricFailureRule.ruleName}"', 'Sum', 900)`,
                        usingMetrics: {},
                        label: 'Failure Count',
                    }),
                ],
                title: 'Failure Count',
                height: 6,
                width: 6,
            }),
            new cloudwatch.GraphWidget({
                left: [
                    new cloudwatch.MathExpression({
                        expression: `SEARCH('MetricName="TriggeredRules" RuleName="${this.job.metricTimeoutRule.ruleName}"', 'Sum', 900)`,
                        usingMetrics: {},
                        label: 'Timeout Count',
                    }),
                ],
                title: 'Timeout Count',
                height: 6,
                width: 6,
            }),
        ];
        this.dashboard.addWidgets(...jobResultWidgets);
        this.dashboard.addWidgets(new cloudwatch.TextWidget({
            markdown: `# ${this.job.name} JVM Glue Driver Stats Alarms`,
            height: 1,
            width: 24,
        }));
        this.dashboard.addWidgets(...[
            new cloudwatch.GraphWidget({
                left: [this.job.diskSpaceUsedMbMetric()],
                title: `${this.job.diskSpaceUsedMbMetric().metricName} (${this.job.diskSpaceUsedMbMetric().statistic})`,
                height: 6,
                width: 6,
            }),
            new cloudwatch.GraphWidget({
                left: [this.job.elapsedTimeMetric()],
                title: `${this.job.elapsedTimeMetric().metricName} (${this.job.elapsedTimeMetric().statistic})`,
                height: 6,
                width: 6,
            }),
        ]);
        const sev2AlarmWidgets = this.alarmsSev2.map(this.alarmWidget);
        const sev3AlarmWidgets = this.alarmsSev3.map(this.alarmWidget);
        this.addWidgets(sev2AlarmWidgets);
        this.addWidgets(sev3AlarmWidgets);
    }
    alarmWidget(alarm) {
        return new cloudwatch.AlarmWidget({
            alarm: alarm,
            title: `${alarm.alarmName}`,
            height: 6,
            width: 6,
        });
    }
}
exports.GlueJobOps = GlueJobOps;
_a = JSII_RTTI_SYMBOL_1;
GlueJobOps[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.GlueJobOps", version: "0.0.39" };
//# sourceMappingURL=data:application/json;base64,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