import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
import * as events from '@aws-cdk/aws-events';
import * as glue from '@aws-cdk/aws-glue';
import * as iam from '@aws-cdk/aws-iam';
import * as lambda from '@aws-cdk/aws-lambda';
import * as s3 from '@aws-cdk/aws-s3';
import * as cdk from '@aws-cdk/core';
/**
 * @experimental
 */
export declare enum GlueWorkerType {
    /**
     * @experimental
     */
    STANDARD = "Standard",
    /**
     * @experimental
     */
    G1_X = "G.1X",
    /**
     * @experimental
     */
    G2_X = "G.2X"
}
/**
 * @experimental
 */
export declare enum GlueVersion {
    /**
     * @experimental
     */
    V_0 = "0.9",
    /**
     * @experimental
     */
    V_1 = "1.0",
    /**
     * @experimental
     */
    V_2 = "2.0"
}
/**
 * @experimental
 */
export declare enum GlueJobType {
    /**
     * @experimental
     */
    GLUE_ETL = "glueetl",
    /**
     * @experimental
     */
    GLUE_STREAMING = "gluestreaming"
}
/**
 * @experimental
 */
export interface GlueJobProperties {
    /**
     * @experimental
     */
    readonly name: string;
    /**
     * @experimental
     */
    readonly roleName?: string;
    /**
     * @experimental
     */
    readonly description?: string;
    /**
     * @experimental
     */
    readonly deploymentBucket: s3.IBucket;
    /**
     * @experimental
     */
    readonly readAccessBuckets?: s3.IBucket[];
    /**
     * @experimental
     */
    readonly writeAccessBuckets?: s3.IBucket[];
    /**
     * @experimental
     */
    readonly glueVersion?: GlueVersion;
    /**
     * @experimental
     */
    readonly workerType: GlueWorkerType;
    /**
     * @experimental
     */
    readonly numberOfWorkers?: number;
    /**
     * @experimental
     */
    readonly maxCapacity?: number;
    /**
     * @experimental
     */
    readonly maxRetries?: number;
    /**
     * @experimental
     */
    readonly maxConcurrentRuns?: number;
    /**
     * @experimental
     */
    readonly jobScript: string;
    /**
     * @experimental
     */
    readonly jobArgs?: {
        [key: string]: string;
    };
    /**
     * @experimental
     */
    readonly timeout?: number;
    /**
     * @experimental
     */
    readonly jobType: GlueJobType;
}
/**
 * @experimental
 */
export declare class GlueJob extends cdk.Construct {
    private static readonly DAY_IN_MINUTES;
    /**
     * @experimental
     */
    readonly job: glue.CfnJob;
    /**
     * @experimental
     */
    readonly role: iam.IRole;
    /**
     * @experimental
     */
    readonly name: string;
    /**
     * @experimental
     */
    readonly metricSuccessRule: events.Rule;
    /**
     * @experimental
     */
    readonly metricTimeoutRule: events.Rule;
    /**
     * @experimental
     */
    readonly metricFailureRule: events.Rule;
    /**
     * @experimental
     */
    readonly allExecutionAttemptsFailedEventSource = "custom.aws.glue.allExecutionAttemptsFailed";
    /**
     * @experimental
     */
    readonly allExecutionAttemptsFailedEventDetailType = "All Execution Attempts Failed";
    /**
     * @experimental
     */
    readonly executionFailureRule: events.Rule;
    /**
     * @experimental
     */
    readonly lambdaFunction: lambda.SingletonFunction;
    private allExecutionAttemptsFailedRule;
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props: GlueJobProperties);
    private createGlueJobRole;
    private jobRule;
    /**
     * @experimental
     */
    metricSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    metricFailure(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    metricAllExecutionAttemptsFailed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    metricTimeout(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    private ruleMetric;
    /**
     * @experimental
     */
    metric(metricName: string, dimensionType: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    jvmHeapUsageMetric(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    elapsedTimeMetric(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    diskSpaceUsedMbMetric(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    runTimeInMiliseconds(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    private createLambdaFunction;
}
