import { Asset } from '@aws-cdk/aws-s3-assets';
import * as cdk from '@aws-cdk/core';
import { DataSet } from './data-sets/data-set';
import { DataSetLocation } from './pipeline';
export declare function notUndefined<T>(obj: T | undefined): obj is T;
/**
 * @experimental
 */
export interface NameBuilderParameters {
    /**
     * @experimental
     */
    readonly name: string;
    /**
     * @experimental
     */
    readonly resourceUse?: string;
    /**
     * @experimental
     */
    readonly stage?: string;
    /**
     * @experimental
     */
    readonly region?: string;
    /**
     * @experimental
     */
    readonly accountId?: string;
}
export declare function buildUniqueName(props: NameBuilderParameters, maxLength: number): string;
export declare function buildS3BucketName(props: NameBuilderParameters): string;
export declare function buildKinesisApplicationName(props: NameBuilderParameters): string;
export declare function buildKinesisStreamName(props: NameBuilderParameters): string;
export declare function buildQueueName(props: NameBuilderParameters): string;
export declare function buildLambdaFunctionName(props: NameBuilderParameters): string;
export declare function buildGlueJobName(props: NameBuilderParameters): string;
export declare function buildGlueCrawlerName(props: NameBuilderParameters): string;
export declare function buildGlueEndpointName(props: NameBuilderParameters): string;
export declare function buildStateMachineName(props: NameBuilderParameters): string;
export declare function buildEventRuleName(props: NameBuilderParameters): string;
export declare function buildDynamoDBTableName(props: NameBuilderParameters): string;
export declare function buildS3BucketArn(props: NameBuilderParameters): string;
export declare function buildRoleName(props: NameBuilderParameters): string;
export declare function buildRoleArn(props: NameBuilderParameters): string;
export declare function sanitizeStackName(name: string): string;
export declare function buildPolicyStatementId(name: string, service: string, accessType: string): string;
export declare function toS3Path(asset: Asset): string;
export declare function packageAsset(scope: cdk.Construct, id: string, projectRelativePath: string): Asset;
export declare function getDataSetBucketName(dataSetLocation: DataSetLocation, dataSet: DataSet): string;
