# cdk-datalake-constructs  <!-- omit in toc -->

***Very experimental until version 1.0.***
This is my attempt at simplifying deploying various datalake strategies in AWS with the CDK.

[![License](https://img.shields.io/badge/License-MIT-green)](https://opensource.org/licenses/MIT)
[![Build](https://github.com/randyridgley/cdk-datalake-constructs/workflows/build/badge.svg)](https://github.com/randyridgley/cdk-datalake-constructs/workflows/build.yml)
[![Release](https://github.com/randyridgley/cdk-datalake-constructs/workflows/release/badge.svg)](https://github.com/randyridgley/cdk-datalake-constructs/workflows/release.yml)
[![Python](https://img.shields.io/pypi/pyversions/cdk-datalake-constructs)](https://pypi.org) [![pip](https://img.shields.io/badge/pip%20install-cdk--datalake--constructs-blue)](https://pypi.org/project/cdk-datalake-constructs/)
[![npm version](https://img.shields.io/npm/v/cdk-datalake-constructs)](https://www.npmjs.com/package/@randyridgley/cdk-datalake-constructs) [![pypi version](https://img.shields.io/pypi/v/cdk-datalake-constructs)](https://pypi.org/project/cdk-datalake-constructs/) [![Maven](https://img.shields.io/maven-central/v/io.github.randyridgley/cdk-datalake-constructs)](https://search.maven.org/search?q=a:cdk-datalake-constructs) [![nuget](https://img.shields.io/nuget/v/Cdk.Datalake.Constructs)](https://www.nuget.org/packages/Cdk.Datalake.Constructs/)

**Table of Contents**

* [Features](#features)
* [Installation](#installation)
* [Usage](#usage)

  * [Basic](#basic)
  * [Data Mesh](#data-mesh)
* [Documentation](#documentation)

  * [Construct API Reference](#construct-api-reference)
* [Supporting this project](#supporting-this-project)
* [License](#license)

## Features

* Easy to Start - Create a Datalake in a few lines.
* Easy to Expand - Expand into multiple accounts and into a data mesh.
* Easy to Admin - Initial governance created on deploy.

## Installation

TypeScript/JavaScript

```sh
$ npm install @randyridgley/cdk-datalake-constructs
```

Python

```sh
$ pip install cdk-datalake-constructs
```

.Net

```sh
$ nuget install CDK.Datalake.Constructs

# See more: https://www.nuget.org/packages/CDK.Datalake.Constructs/
```

## Usage

### Basic

```python
# Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
from randyridgley.cdk_datalake_constructs import DataLake

taxi_pipes = [
    pipelines.YellowPipeline(),
    pipelines.GreenPipeline()
]

data_products = [{
    "pipelines": taxi_pipes,
    "account_id": lake_account_id,
    "data_catalog_account_id": "123456789012",
    "database_name": "taxi-product"
}]

# deploy to local account
dl.DataLake(self, "LocalDataLake",
    name="data-lake,",
    account_id=central_account_id,
    region="us-east-1",
    policy_tags={
        "classification": "public,confidential,highlyconfidential,restricted,critical",
        "owner": "product,central,consumer"
    },
    stage_name=Stage.PROD,
    data_products=data_products,
    create_default_database=False
)
```

### Data Mesh

You can setup cross account access and pre-created policy tags for TBAC access in Lake Formation

```python
# Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
lake_account_id = app.node.try_get_context("lakeAccountId")
central_account_id = app.node.try_get_context("centralAccountId")
consumer_account_id = app.node.try_get_context("consumerAccountId")

taxi_pipes = [
    pipelines.YellowPipeline(),
    pipelines.GreenPipeline()
]

data_products = [{
    "pipelines": taxi_pipes,
    "account_id": lake_account_id,
    "data_catalog_account_id": central_account_id,
    "database_name": "taxi-product"
}]

# deploy to the central account
dl.DataLake(self, "CentralDataLake",
    name="central-lake,",
    account_id=central_account_id,
    region="us-east-1",
    policy_tags={
        "classification": "public,confidential,highlyconfidential,restricted,critical",
        "owner": "product,central,consumer"
    },
    stage_name=Stage.PROD,
    cross_account={
        "consumer_account_ids": [consumer_account_id, lake_account_id],
        "data_catalog_owner_account_id": central_account_id,
        "region": "us-east-1"
    },
    data_products=data_products,
    create_default_database=True
)

# deploy to the data product account
datalake = dl.DataLake(self, "LocalDataLake",
    name="local-lake",
    account_id=lake_account_id,
    region="us-east-1",
    stage_name=Stage.PROD,
    data_products=data_products,
    create_default_database=True
)

# Optionally add custom resource to download public data set products
datalake.create_downloader_custom_resource(account_id, region, props.stage_name)

# deploy to consumer account
datalake = dl.DataLake(self, "ConsumerDataLake",
    name="consumer-lake",
    account_id=consumer_account_id,
    region="us-east-1",
    stage_name=Stage.PROD,
    policy_tags={
        "access": "analyst,engineer,marketing"
    },
    create_default_database=True
)
```

## Documentation

### Construct API Reference

See [API.md](./API.md).

## Supporting this project

I'm working on this project in my free time, if you like my project, or found it helpful and would like to support me any contributions are much appreciated! ❤️

## License

This project is distributed under the [MIT](./LICENSE).
