"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Accelerator = exports.AcceleratorProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "AcceleratorProperty", { enumerable: true, get: function () { return ga_generated_1.RosAccelerator; } });
/**
 * A ROS resource type:  `ALIYUN::GA::Accelerator`
 */
class Accelerator extends ros.Resource {
    /**
     * Create a new `ALIYUN::GA::Accelerator`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAccelerator = new ga_generated_1.RosAccelerator(this, id, {
            acceleratorName: props.acceleratorName,
            autoUseCoupon: props.autoUseCoupon,
            pricingCycle: props.pricingCycle,
            duration: props.duration,
            autoPay: props.autoPay,
            spec: props.spec,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAccelerator;
        this.attrAcceleratorId = rosAccelerator.attrAcceleratorId;
        this.attrAcceleratorName = rosAccelerator.attrAcceleratorName;
        this.attrAutoPay = rosAccelerator.attrAutoPay;
        this.attrAutoUseCoupon = rosAccelerator.attrAutoUseCoupon;
        this.attrDuration = rosAccelerator.attrDuration;
        this.attrOrderId = rosAccelerator.attrOrderId;
        this.attrPaymentType = rosAccelerator.attrPaymentType;
        this.attrPricingCycle = rosAccelerator.attrPricingCycle;
        this.attrSpec = rosAccelerator.attrSpec;
    }
}
exports.Accelerator = Accelerator;
//# sourceMappingURL=data:application/json;base64,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