"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BandwidthPackage = exports.BandwidthPackageProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "BandwidthPackageProperty", { enumerable: true, get: function () { return ga_generated_1.RosBandwidthPackage; } });
/**
 * A ROS resource type:  `ALIYUN::GA::BandwidthPackage`
 */
class BandwidthPackage extends ros.Resource {
    /**
     * Create a new `ALIYUN::GA::BandwidthPackage`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosBandwidthPackage = new ga_generated_1.RosBandwidthPackage(this, id, {
            bandwidthType: props.bandwidthType,
            cbnGeographicRegionIdB: props.cbnGeographicRegionIdB,
            type: props.type,
            cbnGeographicRegionIdA: props.cbnGeographicRegionIdA,
            autoUseCoupon: props.autoUseCoupon,
            pricingCycle: props.pricingCycle,
            chargeType: props.chargeType,
            bandwidth: props.bandwidth,
            ratio: props.ratio,
            duration: props.duration,
            autoPay: props.autoPay,
            billingType: props.billingType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosBandwidthPackage;
        this.attrAutoPay = rosBandwidthPackage.attrAutoPay;
        this.attrAutoUseCoupon = rosBandwidthPackage.attrAutoUseCoupon;
        this.attrBandwidth = rosBandwidthPackage.attrBandwidth;
        this.attrBandwidthPackageId = rosBandwidthPackage.attrBandwidthPackageId;
        this.attrBandwidthPackageName = rosBandwidthPackage.attrBandwidthPackageName;
        this.attrBandwidthType = rosBandwidthPackage.attrBandwidthType;
        this.attrBillingType = rosBandwidthPackage.attrBillingType;
        this.attrCbnGeographicRegionIdA = rosBandwidthPackage.attrCbnGeographicRegionIdA;
        this.attrCbnGeographicRegionIdB = rosBandwidthPackage.attrCbnGeographicRegionIdB;
        this.attrChargeType = rosBandwidthPackage.attrChargeType;
        this.attrPaymentType = rosBandwidthPackage.attrPaymentType;
        this.attrRatio = rosBandwidthPackage.attrRatio;
        this.attrType = rosBandwidthPackage.attrType;
    }
}
exports.BandwidthPackage = BandwidthPackage;
//# sourceMappingURL=data:application/json;base64,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