"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointGroup = exports.EndpointGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "EndpointGroupProperty", { enumerable: true, get: function () { return ga_generated_1.RosEndpointGroup; } });
/**
 * A ROS resource type:  `ALIYUN::GA::EndpointGroup`
 */
class EndpointGroup extends ros.Resource {
    /**
     * Create a new `ALIYUN::GA::EndpointGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosEndpointGroup = new ga_generated_1.RosEndpointGroup(this, id, {
            healthCheckIntervalSeconds: props.healthCheckIntervalSeconds,
            endpointGroupRegion: props.endpointGroupRegion,
            trafficPercentage: props.trafficPercentage,
            description: props.description,
            healthCheckPath: props.healthCheckPath,
            healthCheckProtocol: props.healthCheckProtocol,
            thresholdCount: props.thresholdCount,
            healthCheckPort: props.healthCheckPort,
            acceleratorId: props.acceleratorId,
            endpointConfigurations: props.endpointConfigurations,
            name: props.name,
            listenerId: props.listenerId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosEndpointGroup;
        this.attrEndpointGroupId = rosEndpointGroup.attrEndpointGroupId;
    }
}
exports.EndpointGroup = EndpointGroup;
//# sourceMappingURL=data:application/json;base64,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