"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Listener = exports.ListenerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "ListenerProperty", { enumerable: true, get: function () { return ga_generated_1.RosListener; } });
/**
 * A ROS resource type:  `ALIYUN::GA::Listener`
 */
class Listener extends ros.Resource {
    /**
     * Create a new `ALIYUN::GA::Listener`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosListener = new ga_generated_1.RosListener(this, id, {
            description: props.description,
            portRanges: props.portRanges,
            protocol: props.protocol,
            acceleratorId: props.acceleratorId,
            name: props.name,
            clientAffinity: props.clientAffinity,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosListener;
        this.attrListenerId = rosListener.attrListenerId;
    }
}
exports.Listener = Listener;
//# sourceMappingURL=data:application/json;base64,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