import * as athena from '@aws-cdk/aws-athena';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as glue from '@aws-cdk/aws-glue';
import * as iam from '@aws-cdk/aws-iam';
import * as s3 from '@aws-cdk/aws-s3';
import * as cdk from '@aws-cdk/core';
import { DataProduct } from './data-product';
import { DataSet } from './data-sets/data-set';
import { KinesisStream } from './data-streams/kinesis-stream';
/**
 * @experimental
 */
export interface CrossAccountProperties {
    /**
     * @experimental
     */
    readonly consumerAccountIds: string[];
    /**
     * @experimental
     */
    readonly dataCatalogOwnerAccountId: string;
}
/**
 * @experimental
 */
export interface DataLakeProperties {
    /**
     * (experimental) The name of the DataLake.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The Stage the DataLake will be deployed.
     *
     * @experimental
     */
    readonly stageName: Stage;
    /**
     * (experimental) The List of DataProducts for this account.
     *
     * @default - No data products
     * @experimental
     */
    readonly dataProducts?: DataProduct[];
    /**
     * (experimental) The Type of DataLake this instance is.
     *
     * This can be a DATA_PRODUCT only, CENTRAL_CATALOG, CONSUMER, or DATA_PRODUCT_AND_CATALOG type.
     *
     * @experimental
     */
    readonly lakeType: LakeType;
    /**
     * (experimental) VPC for Glue jobs.
     *
     * @default - No vpc
     * @experimental
     * @description - The VPC that will be used if the Glue job needs access to resources within the account or internet access
     */
    readonly vpc?: ec2.Vpc;
    /**
     * (experimental) List of Lake Formation TBAC policy tags.
     *
     * @default - No tags
     * @see https://docs.aws.amazon.com/lake-formation/latest/dg/TBAC-section.html
     * @experimental
     * @description - Define the tag taxonomy needed for the DataLake
     */
    readonly policyTags?: {
        [name: string]: string;
    };
    /**
     * (experimental) Cross account AWS account IDs.
     *
     * @default - No cross account ids
     * @see https://aws.amazon.com/premiumsupport/knowledge-center/glue-data-catalog-cross-account-access/
     * @experimental
     * @description - The cross account ids needed for setting up the Glue resource policy
     */
    readonly crossAccountAccess?: CrossAccountProperties;
    /**
     * (experimental) Security group to attach to Glue jobs.
     *
     * @default - No security group
     * @see https://docs.aws.amazon.com/glue/latest/dg/setup-vpc-for-glue-access.html
     * @experimental
     * @description - Security Group that will be used to allow port access in the VPC
     */
    readonly glueSecurityGroup?: ec2.SecurityGroup;
    /**
     * (experimental) Data Lake Admin role.
     *
     * @default - Admin role created based on best practices
     * @see https://docs.aws.amazon.com/lake-formation/latest/dg/permissions-reference.html
     * @experimental
     * @description - IAM Role for DataLake admin access
     */
    readonly datalakeAdminRole?: iam.Role;
    /**
     * (experimental) Data Lake Database Creator role.
     *
     * @default - Database creator role created based on best practices
     * @see https://docs.aws.amazon.com/lake-formation/latest/dg/permissions-reference.html
     * @experimental
     * @description - IAM Role for DataLake database creator access
     */
    readonly datalakeCreatorRole?: iam.Role;
    /**
     * (experimental) Create default Glue Database for DataLake.
     *
     * @default - false
     * @experimental
     */
    readonly createDefaultDatabase: Boolean;
    /**
     * @experimental
     */
    readonly logBucketProps?: s3.BucketProps;
    /**
     * (experimental) Create default Athena workgroup for querying data lake resources.
     *
     * @default - false
     * @experimental
     */
    readonly createAthenaWorkgroup?: Boolean;
}
/**
 * @experimental
 */
export declare enum Stage {
    /**
     * @experimental
     */
    ALPHA = "alpha",
    /**
     * @experimental
     */
    BETA = "beta",
    /**
     * @experimental
     */
    GAMMA = "gamma",
    /**
     * @experimental
     */
    PROD = "prod"
}
/**
 * @experimental
 */
export declare enum Permissions {
    /**
     * @experimental
     */
    ALTER = "ALTER",
    /**
     * @experimental
     */
    CREATE_DATABASE = "CREATE_DATABASE",
    /**
     * @experimental
     */
    CREATE_TABLE = "CREATE_TABLE",
    /**
     * @experimental
     */
    DATA_LOCATION_ACCESS = "DATA_LOCATION_ACCESS",
    /**
     * @experimental
     */
    DELETE = "DELETE",
    /**
     * @experimental
     */
    DESCRIBE = "DESCRIBE",
    /**
     * @experimental
     */
    DROP = "DROP",
    /**
     * @experimental
     */
    INSERT = "INSERT",
    /**
     * @experimental
     */
    SELECT = "SELECT",
    /**
     * @experimental
     */
    ASSOCIATE = "ASSOCIATE"
}
/**
 * @experimental
 */
export declare enum LakeType {
    /**
     * @experimental
     */
    DATA_PRODUCT = "DATA_PRODUCT",
    /**
     * @experimental
     */
    CENTRAL_CATALOG = "CENTRAL_CATALOG",
    /**
     * @experimental
     */
    CONSUMER = "CONSUMER",
    /**
     * @experimental
     */
    DATA_PRODUCT_AND_CATALOG = "DATA_PRODUCT_AND_CATALOG"
}
/**
 * (experimental) A CDK construct to create a DataLake.
 *
 * @experimental
 */
export declare class DataLake extends cdk.Construct {
    /**
     * @experimental
     */
    readonly dataSets: {
        [schemaName: string]: DataSet;
    };
    /**
     * @experimental
     */
    readonly dataStreams: {
        [schemaName: string]: KinesisStream;
    };
    /**
     * @experimental
     */
    readonly databases: {
        [name: string]: glue.Database;
    };
    /**
     * @experimental
     */
    readonly datalakeAdminRole: iam.IRole;
    /**
     * @experimental
     */
    readonly datalakeDbCreatorRole: iam.IRole;
    /**
     * @experimental
     */
    readonly logBucket: s3.Bucket;
    /**
     * @experimental
     */
    readonly stageName: Stage;
    /**
     * @experimental
     */
    readonly vpc?: ec2.Vpc;
    /**
     * @experimental
     */
    readonly athenaWorkgroup?: athena.CfnWorkGroup;
    /**
     * @experimental
     */
    readonly lakeType: LakeType;
    private readonly glueSecurityGroup?;
    private readonly crossAccountAccess?;
    private readonly downloadLocations;
    private readonly logBucketProps;
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props: DataLakeProperties);
    /**
     * @experimental
     */
    createDownloaderCustomResource(stageName: string): void;
    private createDatabase;
    private addDataStream;
    private addPipeline;
    private createPipelineResources;
    private createJDBCConnection;
    private createPolicyTagsCustomResource;
    /**
     * @experimental
     */
    createCrossAccountGlueCatalogResourcePolicy(consumerAccountIds: string[], dataCatalogOwnerAccountId: string): void;
    private registerDataLakeLocation;
    private createDataLocationAccessPermission;
}
