import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
import * as cdk from '@aws-cdk/core';
import { KinesisStream } from './kinesis-stream';
import { S3DeliveryStream } from './s3-delivery-stream';
/**
 * @experimental
 */
export interface IKinesisOpsProperties {
    /**
     * @experimental
     */
    stream: KinesisStream;
    /**
     * @experimental
     */
    deliveryStream: S3DeliveryStream;
    /**
     * @experimental
     */
    inputStreamIteratorAgeCritical?: cloudwatch.CreateAlarmOptions;
    /**
     * @experimental
     */
    inputStreamIteratorAgeWarning?: cloudwatch.CreateAlarmOptions;
    /**
     * @experimental
     */
    inputStreamReadThroughputWarning?: cloudwatch.CreateAlarmOptions;
    /**
     * @experimental
     */
    inputStreamWriteThroughputWarning?: cloudwatch.CreateAlarmOptions;
    /**
     * @experimental
     */
    inputStreamGetRecordsWarning?: cloudwatch.CreateAlarmOptions;
    /**
     * @experimental
     */
    inputStreamPutRecordsWarning?: cloudwatch.CreateAlarmOptions;
    /**
     * @experimental
     */
    firehoseDeliveryToS3Critical?: cloudwatch.CreateAlarmOptions;
    /**
     * @experimental
     */
    firehoseDeliveryToS3Warning?: cloudwatch.CreateAlarmOptions;
}
/**
 * @experimental
 */
export declare class KinesisOps extends cdk.Construct {
    /**
     * @experimental
     */
    dashboard: cloudwatch.Dashboard;
    /**
     * @experimental
     */
    readonly stream: KinesisStream;
    /**
     * @experimental
     */
    readonly deliveryStream: S3DeliveryStream;
    /**
     * @experimental
     */
    readonly streamName: string;
    /**
     * @experimental
     */
    readonly inputStreamIteratorAgeCriticalAlarm: cloudwatch.Alarm;
    /**
     * @experimental
     */
    readonly inputStreamIteratorAgeWarningAlarm: cloudwatch.Alarm;
    /**
     * @experimental
     */
    readonly inputStreamReadThroughputWarningAlarm: cloudwatch.Alarm;
    /**
     * @experimental
     */
    readonly inputStreamWriteThroughputWarningAlarm: cloudwatch.Alarm;
    /**
     * @experimental
     */
    readonly inputStreamGetRecordsWarningAlarm: cloudwatch.Alarm;
    /**
     * @experimental
     */
    readonly inputStreamPutRecordsWarningAlarm: cloudwatch.Alarm;
    /**
     * @experimental
     */
    readonly firehoseDeliveryToS3WarningAlarm: cloudwatch.Alarm;
    /**
     * @experimental
     */
    readonly firehoseDeliveryToS3CriticalAlarm: cloudwatch.Alarm;
    /**
     * @experimental
     */
    readonly alarmsSev2: cloudwatch.Alarm[];
    /**
     * @experimental
     */
    readonly alarmsSev3: cloudwatch.Alarm[];
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props: IKinesisOpsProperties);
    private alarmWidgets;
    private addWidgets;
    private setupDashboard;
}
