"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisStream = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const kinesis = require("@aws-cdk/aws-kinesis");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class KinesisStream extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(parent, name, props) {
        super(parent, name);
        this.stream = new kinesis.Stream(this, 'kinesis-stream', props);
    }
    /**
     * @experimental
     */
    metric(metricName, props) {
        return new cloudwatch.Metric({
            namespace: 'AWS/Kinesis',
            metricName,
            dimensions: {
                StreamName: this.stream.streamName,
            },
            ...props,
        });
    }
    /**
     * @experimental
     */
    metricGetRecordsBytes(props) {
        return this.metric('GetRecords.Bytes', props);
    }
    /**
     * @experimental
     */
    metricGetRecordsIteratorAgeMilliseconds(props) {
        return this.metric('GetRecords.IteratorAgeMilliseconds', props);
    }
    /**
     * @experimental
     */
    metricGetRecordsLatency(props) {
        return this.metric('GetRecords.Latency', props);
    }
    /**
     * @experimental
     */
    metricGetRecordsRecords(props) {
        return this.metric('GetRecords.Records', props);
    }
    /**
     * @experimental
     */
    metricGetRecordsSuccess(props) {
        return this.metric('GetRecords.Success', props);
    }
    /**
     * @experimental
     */
    metricIncomingBytes(props) {
        return this.metric('IncomingBytes', props);
    }
    /**
     * @experimental
     */
    metricIncomingRecords(props) {
        return this.metric('IncomingRecords', props);
    }
    /**
     * @experimental
     */
    metricPutRecordBytes(props) {
        return this.metric('PutRecord.Bytes', props);
    }
    /**
     * @experimental
     */
    metricPutRecordLatency(props) {
        return this.metric('PutRecord.Latency', props);
    }
    /**
     * @experimental
     */
    metricPutRecordSuccess(props) {
        return this.metric('PutRecord.Success', props);
    }
    /**
     * @experimental
     */
    metricPutRecordsBytes(props) {
        return this.metric('PutRecords.Bytes', props);
    }
    /**
     * @experimental
     */
    metricPutRecordsLatency(props) {
        return this.metric('PutRecords.Latency', props);
    }
    /**
     * @experimental
     */
    metricPutRecordsRecords(props) {
        return this.metric('PutRecords.Records', props);
    }
    /**
     * @experimental
     */
    metricPutRecordsSuccess(props) {
        return this.metric('PutRecords.Success', props);
    }
    /**
     * @experimental
     */
    metricReadProvisionedThroughputExceeded(props) {
        return this.metric('ReadProvisionedThroughputExceeded', props);
    }
    /**
     * @experimental
     */
    metricWriteProvisionedThroughputExceeded(props) {
        return this.metric('WriteProvisionedThroughputExceeded', props);
    }
    /**
     * @experimental
     */
    metricSubscribeToShardRateExceeded(props) {
        return this.metric('SubscribeToShard.RateExceeded', props);
    }
    /**
     * @experimental
     */
    metricSubscribeToShardSuccess(props) {
        return this.metric('SubscribeToShard.Success', props);
    }
    /**
     * @experimental
     */
    metricSubscribeToShardEventBytes(props) {
        return this.metric('SubscribeToShardEvent.Bytes', props);
    }
    /**
     * @experimental
     */
    metricSubscribeToShardEventMillisBehindLatest(props) {
        return this.metric('SubscribeToShardEvent.MillisBehindLatest', props);
    }
    /**
     * @experimental
     */
    metricSubscribeToShardEventRecords(props) {
        return this.metric('SubscribeToShardEvent.Records', props);
    }
    /**
     * @experimental
     */
    metricSubscribeToShardEventSuccess(props) {
        return this.metric('SubscribeToShardEvent.Success', props);
    }
}
exports.KinesisStream = KinesisStream;
_a = JSII_RTTI_SYMBOL_1;
KinesisStream[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.KinesisStream", version: "0.0.36" };
//# sourceMappingURL=data:application/json;base64,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