import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
import * as events from '@aws-cdk/aws-events';
import * as glue from '@aws-cdk/aws-glue';
import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
/**
 * @experimental
 */
export interface IGlueCrawlerProperties {
    /**
     * @experimental
     */
    name: string;
    /**
     * @experimental
     */
    databaseName: string;
    /**
     * @experimental
     */
    roleName?: string;
    /**
     * @experimental
     */
    trigger?: glue.CfnTrigger;
    /**
     * @experimental
     */
    bucketName: string;
    /**
     * @experimental
     */
    bucketPrefix?: string;
}
/**
 * @experimental
 */
export declare class GlueCrawler extends cdk.Construct {
    /**
     * @experimental
     */
    readonly crawler: glue.CfnCrawler;
    /**
     * @experimental
     */
    readonly role: iam.IRole;
    /**
     * @experimental
     */
    readonly metricSuccessRule: events.Rule;
    /**
     * @experimental
     */
    readonly metricFailureRule: events.Rule;
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props: IGlueCrawlerProperties);
    /**
     * @experimental
     */
    metricSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * @experimental
     */
    metricFailure(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    private ruleMetric;
    private crawlerRule;
    private createGlueCrawlerRole;
}
