"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlueCrawler = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const events = require("@aws-cdk/aws-events");
const glue = require("@aws-cdk/aws-glue");
const iam = require("@aws-cdk/aws-iam");
const lf = require("@aws-cdk/aws-lakeformation");
const cdk = require("@aws-cdk/core");
const data_lake_1 = require("../data-lake");
/**
 * @experimental
 */
class GlueCrawler extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.role = this.createGlueCrawlerRole(props);
        this.metricSuccessRule = this.crawlerRule('SuccessRule', props.name, 'Succeeded');
        this.metricFailureRule = this.crawlerRule('FailureRule', props.name, 'Failed');
        let s3TargetPaths = new Array();
        s3TargetPaths.push({
            path: `s3://${props.bucketName}/${props.bucketPrefix}`,
        });
        this.crawler = new glue.CfnCrawler(this, `data-lake-crawler-${props.name}-`, {
            name: props.name,
            role: this.role.roleArn,
            databaseName: props.databaseName,
            targets: {
                s3Targets: s3TargetPaths,
            },
        });
        new lf.CfnPermissions(this, 'glue-role-database-permission', {
            dataLakePrincipal: {
                dataLakePrincipalIdentifier: this.role.roleArn,
            },
            resource: {
                databaseResource: {
                    name: props.databaseName,
                },
            },
            permissions: [
                'CREATE_TABLE',
                'DESCRIBE',
            ],
        });
        new lf.CfnPermissions(this, 'datalake-creator-permission', {
            dataLakePrincipal: {
                dataLakePrincipalIdentifier: this.role.roleArn,
            },
            resource: {
                dataLocationResource: {
                    s3Resource: `arn:aws:s3:::${props.bucketName}`,
                },
            },
            permissions: [
                data_lake_1.Permissions.DATA_LOCATION_ACCESS,
            ],
        });
    }
    /**
     * @experimental
     */
    metricSuccess(props) {
        return this.ruleMetric(this.metricSuccessRule, props);
    }
    /**
     * @experimental
     */
    metricFailure(props) {
        return this.ruleMetric(this.metricFailureRule, props);
    }
    ruleMetric({ ruleName }, props) {
        return new cloudwatch.Metric({
            namespace: 'AWS/Events',
            metricName: 'TriggeredRules',
            dimensions: { RuleName: ruleName },
            statistic: cloudwatch.Statistic.SUM,
            ...props,
        }).attachTo(this);
    }
    crawlerRule(id, crawlerName, ...states) {
        return new events.Rule(this, id, {
            ruleName: crawlerName + states.join(''),
            description: `Event triggered when Glue Crawler ${crawlerName} is in ${states.join(' or ')} state(s)`,
            eventPattern: {
                source: ['aws.glue'],
                detailType: ['Glue Crawler State Change'],
                detail: {
                    state: states,
                    crawlerName: [crawlerName],
                },
            },
        });
    }
    createGlueCrawlerRole(props) {
        const role = new iam.Role(this, 'Role', {
            roleName: props.roleName || props.name + 'Role',
            assumedBy: new iam.ServicePrincipal('glue'),
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSGlueServiceRole'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonS3FullAccess'),
            ],
        });
        role.addToPolicy(new iam.PolicyStatement({ actions: ['lakeformation:GetDataAccess'], resources: ['*'] }));
        return role;
    }
}
exports.GlueCrawler = GlueCrawler;
_a = JSII_RTTI_SYMBOL_1;
GlueCrawler[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.GlueCrawler", version: "0.0.36" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2x1ZS1jcmF3bGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2V0bC9nbHVlLWNyYXdsZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxzREFBc0Q7QUFDdEQsOENBQThDO0FBQzlDLDBDQUEwQztBQUMxQyx3Q0FBd0M7QUFDeEMsaURBQWlEO0FBQ2pELHFDQUFxQztBQUNyQyw0Q0FBMkM7Ozs7QUFXM0MsTUFBYSxXQUFZLFNBQVEsR0FBRyxDQUFDLFNBQVM7Ozs7SUFNNUMsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUE2QjtRQUN6RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzlDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLGFBQWEsRUFBRSxLQUFLLENBQUMsSUFBSSxFQUFFLFdBQVcsQ0FBQyxDQUFDO1FBQ2xGLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLGFBQWEsRUFBRSxLQUFLLENBQUMsSUFBSSxFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBQy9FLElBQUksYUFBYSxHQUFHLElBQUksS0FBSyxFQUFvQyxDQUFDO1FBRWxFLGFBQWEsQ0FBQyxJQUFJLENBQUM7WUFDakIsSUFBSSxFQUFFLFFBQVEsS0FBSyxDQUFDLFVBQVUsSUFBSSxLQUFLLENBQUMsWUFBWSxFQUFFO1NBQ3ZELENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksRUFBRSxxQkFBcUIsS0FBSyxDQUFDLElBQUksR0FBRyxFQUFFO1lBQzNFLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSTtZQUNoQixJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPO1lBQ3ZCLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtZQUNoQyxPQUFPLEVBQUU7Z0JBQ1AsU0FBUyxFQUFFLGFBQWE7YUFDekI7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLEVBQUUsQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLCtCQUErQixFQUFFO1lBQzNELGlCQUFpQixFQUFFO2dCQUNqQiwyQkFBMkIsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU87YUFDL0M7WUFDRCxRQUFRLEVBQUU7Z0JBQ1IsZ0JBQWdCLEVBQUU7b0JBQ2hCLElBQUksRUFBRSxLQUFLLENBQUMsWUFBWTtpQkFDekI7YUFDRjtZQUNELFdBQVcsRUFBRTtnQkFDWCxjQUFjO2dCQUNkLFVBQVU7YUFDWDtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksRUFBRSxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsNkJBQTZCLEVBQUU7WUFDekQsaUJBQWlCLEVBQUU7Z0JBQ2pCLDJCQUEyQixFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTzthQUMvQztZQUNELFFBQVEsRUFBRTtnQkFDUixvQkFBb0IsRUFBRTtvQkFDcEIsVUFBVSxFQUFFLGdCQUFnQixLQUFLLENBQUMsVUFBVSxFQUFFO2lCQUMvQzthQUNGO1lBQ0QsV0FBVyxFQUFFO2dCQUNYLHVCQUFXLENBQUMsb0JBQW9CO2FBQ2pDO1NBQ0YsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7OztJQUVELGFBQWEsQ0FBQyxLQUFnQztRQUM1QyxPQUFPLElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxDQUFDO0lBQ3hELENBQUM7Ozs7SUFFRCxhQUFhLENBQUMsS0FBZ0M7UUFDNUMsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxLQUFLLENBQUMsQ0FBQztJQUN4RCxDQUFDO0lBRU8sVUFBVSxDQUFDLEVBQUUsUUFBUSxFQUFlLEVBQUUsS0FBZ0M7UUFDNUUsT0FBTyxJQUFJLFVBQVUsQ0FBQyxNQUFNLENBQUM7WUFDM0IsU0FBUyxFQUFFLFlBQVk7WUFDdkIsVUFBVSxFQUFFLGdCQUFnQjtZQUM1QixVQUFVLEVBQUUsRUFBRSxRQUFRLEVBQUUsUUFBUSxFQUFFO1lBQ2xDLFNBQVMsRUFBRSxVQUFVLENBQUMsU0FBUyxDQUFDLEdBQUc7WUFDbkMsR0FBRyxLQUFLO1NBQ1QsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNwQixDQUFDO0lBRU8sV0FBVyxDQUFDLEVBQVUsRUFBRSxXQUFtQixFQUFFLEdBQUcsTUFBZ0I7UUFDdEUsT0FBTyxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRTtZQUMvQixRQUFRLEVBQUUsV0FBVyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDO1lBQ3ZDLFdBQVcsRUFBRSxxQ0FBcUMsV0FBVyxVQUFVLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFdBQVc7WUFDckcsWUFBWSxFQUFFO2dCQUNaLE1BQU0sRUFBRSxDQUFDLFVBQVUsQ0FBQztnQkFDcEIsVUFBVSxFQUFFLENBQUMsMkJBQTJCLENBQUM7Z0JBQ3pDLE1BQU0sRUFBRTtvQkFDTixLQUFLLEVBQUUsTUFBTTtvQkFDYixXQUFXLEVBQUUsQ0FBQyxXQUFXLENBQUM7aUJBQzNCO2FBQ0Y7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU8scUJBQXFCLENBQUMsS0FBNkI7UUFDekQsTUFBTSxJQUFJLEdBQUcsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxNQUFNLEVBQUU7WUFDdEMsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRLElBQUksS0FBSyxDQUFDLElBQUksR0FBRyxNQUFNO1lBQy9DLFNBQVMsRUFBRSxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUM7WUFDM0MsZUFBZSxFQUFFO2dCQUNmLEdBQUcsQ0FBQyxhQUFhLENBQUMsd0JBQXdCLENBQUMsaUNBQWlDLENBQUM7Z0JBQzdFLEdBQUcsQ0FBQyxhQUFhLENBQUMsd0JBQXdCLENBQUMsb0JBQW9CLENBQUM7YUFDakU7U0FDRixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQyxFQUFFLE9BQU8sRUFBRSxDQUFDLDZCQUE2QixDQUFDLEVBQUUsU0FBUyxFQUFFLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFDMUcsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOztBQXJHSCxrQ0FzR0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjbG91ZHdhdGNoIGZyb20gJ0Bhd3MtY2RrL2F3cy1jbG91ZHdhdGNoJztcbmltcG9ydCAqIGFzIGV2ZW50cyBmcm9tICdAYXdzLWNkay9hd3MtZXZlbnRzJztcbmltcG9ydCAqIGFzIGdsdWUgZnJvbSAnQGF3cy1jZGsvYXdzLWdsdWUnO1xuaW1wb3J0ICogYXMgaWFtIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0ICogYXMgbGYgZnJvbSAnQGF3cy1jZGsvYXdzLWxha2Vmb3JtYXRpb24nO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgUGVybWlzc2lvbnMgfSBmcm9tICcuLi9kYXRhLWxha2UnO1xuXG5leHBvcnQgaW50ZXJmYWNlIElHbHVlQ3Jhd2xlclByb3BlcnRpZXMge1xuICBuYW1lOiBzdHJpbmc7XG4gIGRhdGFiYXNlTmFtZTogc3RyaW5nO1xuICByb2xlTmFtZT86IHN0cmluZztcbiAgdHJpZ2dlcj86IGdsdWUuQ2ZuVHJpZ2dlcjtcbiAgYnVja2V0TmFtZTogc3RyaW5nO1xuICBidWNrZXRQcmVmaXg/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBjbGFzcyBHbHVlQ3Jhd2xlciBleHRlbmRzIGNkay5Db25zdHJ1Y3Qge1xuICBwdWJsaWMgcmVhZG9ubHkgY3Jhd2xlcjogZ2x1ZS5DZm5DcmF3bGVyXG4gIHB1YmxpYyByZWFkb25seSByb2xlOiBpYW0uSVJvbGU7XG4gIHB1YmxpYyByZWFkb25seSBtZXRyaWNTdWNjZXNzUnVsZTogZXZlbnRzLlJ1bGU7XG4gIHB1YmxpYyByZWFkb25seSBtZXRyaWNGYWlsdXJlUnVsZTogZXZlbnRzLlJ1bGU7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBJR2x1ZUNyYXdsZXJQcm9wZXJ0aWVzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMucm9sZSA9IHRoaXMuY3JlYXRlR2x1ZUNyYXdsZXJSb2xlKHByb3BzKTtcbiAgICB0aGlzLm1ldHJpY1N1Y2Nlc3NSdWxlID0gdGhpcy5jcmF3bGVyUnVsZSgnU3VjY2Vzc1J1bGUnLCBwcm9wcy5uYW1lLCAnU3VjY2VlZGVkJyk7XG4gICAgdGhpcy5tZXRyaWNGYWlsdXJlUnVsZSA9IHRoaXMuY3Jhd2xlclJ1bGUoJ0ZhaWx1cmVSdWxlJywgcHJvcHMubmFtZSwgJ0ZhaWxlZCcpO1xuICAgIGxldCBzM1RhcmdldFBhdGhzID0gbmV3IEFycmF5PGdsdWUuQ2ZuQ3Jhd2xlci5TM1RhcmdldFByb3BlcnR5PigpO1xuXG4gICAgczNUYXJnZXRQYXRocy5wdXNoKHtcbiAgICAgIHBhdGg6IGBzMzovLyR7cHJvcHMuYnVja2V0TmFtZX0vJHtwcm9wcy5idWNrZXRQcmVmaXh9YCxcbiAgICB9KTtcblxuICAgIHRoaXMuY3Jhd2xlciA9IG5ldyBnbHVlLkNmbkNyYXdsZXIodGhpcywgYGRhdGEtbGFrZS1jcmF3bGVyLSR7cHJvcHMubmFtZX0tYCwge1xuICAgICAgbmFtZTogcHJvcHMubmFtZSxcbiAgICAgIHJvbGU6IHRoaXMucm9sZS5yb2xlQXJuLFxuICAgICAgZGF0YWJhc2VOYW1lOiBwcm9wcy5kYXRhYmFzZU5hbWUsXG4gICAgICB0YXJnZXRzOiB7XG4gICAgICAgIHMzVGFyZ2V0czogczNUYXJnZXRQYXRocyxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICBuZXcgbGYuQ2ZuUGVybWlzc2lvbnModGhpcywgJ2dsdWUtcm9sZS1kYXRhYmFzZS1wZXJtaXNzaW9uJywge1xuICAgICAgZGF0YUxha2VQcmluY2lwYWw6IHtcbiAgICAgICAgZGF0YUxha2VQcmluY2lwYWxJZGVudGlmaWVyOiB0aGlzLnJvbGUucm9sZUFybixcbiAgICAgIH0sXG4gICAgICByZXNvdXJjZToge1xuICAgICAgICBkYXRhYmFzZVJlc291cmNlOiB7XG4gICAgICAgICAgbmFtZTogcHJvcHMuZGF0YWJhc2VOYW1lLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICAgIHBlcm1pc3Npb25zOiBbXG4gICAgICAgICdDUkVBVEVfVEFCTEUnLFxuICAgICAgICAnREVTQ1JJQkUnLFxuICAgICAgXSxcbiAgICB9KTtcblxuICAgIG5ldyBsZi5DZm5QZXJtaXNzaW9ucyh0aGlzLCAnZGF0YWxha2UtY3JlYXRvci1wZXJtaXNzaW9uJywge1xuICAgICAgZGF0YUxha2VQcmluY2lwYWw6IHtcbiAgICAgICAgZGF0YUxha2VQcmluY2lwYWxJZGVudGlmaWVyOiB0aGlzLnJvbGUucm9sZUFybixcbiAgICAgIH0sXG4gICAgICByZXNvdXJjZToge1xuICAgICAgICBkYXRhTG9jYXRpb25SZXNvdXJjZToge1xuICAgICAgICAgIHMzUmVzb3VyY2U6IGBhcm46YXdzOnMzOjo6JHtwcm9wcy5idWNrZXROYW1lfWAsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICAgcGVybWlzc2lvbnM6IFtcbiAgICAgICAgUGVybWlzc2lvbnMuREFUQV9MT0NBVElPTl9BQ0NFU1MsXG4gICAgICBdLFxuICAgIH0pO1xuICB9XG5cbiAgbWV0cmljU3VjY2Vzcyhwcm9wcz86IGNsb3Vkd2F0Y2guTWV0cmljT3B0aW9ucyk6IGNsb3Vkd2F0Y2guTWV0cmljIHtcbiAgICByZXR1cm4gdGhpcy5ydWxlTWV0cmljKHRoaXMubWV0cmljU3VjY2Vzc1J1bGUsIHByb3BzKTtcbiAgfVxuXG4gIG1ldHJpY0ZhaWx1cmUocHJvcHM/OiBjbG91ZHdhdGNoLk1ldHJpY09wdGlvbnMpOiBjbG91ZHdhdGNoLk1ldHJpYyB7XG4gICAgcmV0dXJuIHRoaXMucnVsZU1ldHJpYyh0aGlzLm1ldHJpY0ZhaWx1cmVSdWxlLCBwcm9wcyk7XG4gIH1cblxuICBwcml2YXRlIHJ1bGVNZXRyaWMoeyBydWxlTmFtZSB9OiBldmVudHMuUnVsZSwgcHJvcHM/OiBjbG91ZHdhdGNoLk1ldHJpY09wdGlvbnMpOiBjbG91ZHdhdGNoLk1ldHJpYyB7XG4gICAgcmV0dXJuIG5ldyBjbG91ZHdhdGNoLk1ldHJpYyh7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvRXZlbnRzJyxcbiAgICAgIG1ldHJpY05hbWU6ICdUcmlnZ2VyZWRSdWxlcycsXG4gICAgICBkaW1lbnNpb25zOiB7IFJ1bGVOYW1lOiBydWxlTmFtZSB9LFxuICAgICAgc3RhdGlzdGljOiBjbG91ZHdhdGNoLlN0YXRpc3RpYy5TVU0sXG4gICAgICAuLi5wcm9wcyxcbiAgICB9KS5hdHRhY2hUbyh0aGlzKTtcbiAgfVxuXG4gIHByaXZhdGUgY3Jhd2xlclJ1bGUoaWQ6IHN0cmluZywgY3Jhd2xlck5hbWU6IHN0cmluZywgLi4uc3RhdGVzOiBzdHJpbmdbXSk6IGV2ZW50cy5SdWxlIHtcbiAgICByZXR1cm4gbmV3IGV2ZW50cy5SdWxlKHRoaXMsIGlkLCB7XG4gICAgICBydWxlTmFtZTogY3Jhd2xlck5hbWUgKyBzdGF0ZXMuam9pbignJyksXG4gICAgICBkZXNjcmlwdGlvbjogYEV2ZW50IHRyaWdnZXJlZCB3aGVuIEdsdWUgQ3Jhd2xlciAke2NyYXdsZXJOYW1lfSBpcyBpbiAke3N0YXRlcy5qb2luKCcgb3IgJyl9IHN0YXRlKHMpYCxcbiAgICAgIGV2ZW50UGF0dGVybjoge1xuICAgICAgICBzb3VyY2U6IFsnYXdzLmdsdWUnXSxcbiAgICAgICAgZGV0YWlsVHlwZTogWydHbHVlIENyYXdsZXIgU3RhdGUgQ2hhbmdlJ10sXG4gICAgICAgIGRldGFpbDoge1xuICAgICAgICAgIHN0YXRlOiBzdGF0ZXMsXG4gICAgICAgICAgY3Jhd2xlck5hbWU6IFtjcmF3bGVyTmFtZV0sXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG5cbiAgcHJpdmF0ZSBjcmVhdGVHbHVlQ3Jhd2xlclJvbGUocHJvcHM6IElHbHVlQ3Jhd2xlclByb3BlcnRpZXMpOiBpYW0uUm9sZSB7XG4gICAgY29uc3Qgcm9sZSA9IG5ldyBpYW0uUm9sZSh0aGlzLCAnUm9sZScsIHtcbiAgICAgIHJvbGVOYW1lOiBwcm9wcy5yb2xlTmFtZSB8fCBwcm9wcy5uYW1lICsgJ1JvbGUnLFxuICAgICAgYXNzdW1lZEJ5OiBuZXcgaWFtLlNlcnZpY2VQcmluY2lwYWwoJ2dsdWUnKSxcbiAgICAgIG1hbmFnZWRQb2xpY2llczogW1xuICAgICAgICBpYW0uTWFuYWdlZFBvbGljeS5mcm9tQXdzTWFuYWdlZFBvbGljeU5hbWUoJ3NlcnZpY2Utcm9sZS9BV1NHbHVlU2VydmljZVJvbGUnKSxcbiAgICAgICAgaWFtLk1hbmFnZWRQb2xpY3kuZnJvbUF3c01hbmFnZWRQb2xpY3lOYW1lKCdBbWF6b25TM0Z1bGxBY2Nlc3MnKSwgLy8gc2xpbSB0aGlzIGRvd24gaWYgcG9zc2libGVcbiAgICAgIF0sXG4gICAgfSk7XG4gICAgcm9sZS5hZGRUb1BvbGljeShuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7IGFjdGlvbnM6IFsnbGFrZWZvcm1hdGlvbjpHZXREYXRhQWNjZXNzJ10sIHJlc291cmNlczogWycqJ10gfSkpO1xuICAgIHJldHVybiByb2xlO1xuICB9XG59Il19