"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataLakeAdministrator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const lf = require("@aws-cdk/aws-lakeformation");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class DataLakeAdministrator extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        const accountId = cdk.Stack.of(this).account;
        this.role = new iam.Role(this, 'datalake-administrator-role', {
            roleName: props.name,
            assumedBy: new iam.CompositePrincipal(new iam.ServicePrincipal('lakeformation.amazonaws.com'), new iam.ServicePrincipal('lambda.amazonaws.com'), new iam.ServicePrincipal('sagemaker.amazonaws.com')),
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('AWSLakeFormationDataAdmin'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('AWSGlueConsoleFullAccess'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('CloudWatchLogsReadOnlyAccess'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('AWSLakeFormationCrossAccountManager'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonAthenaFullAccess'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSageMakerFullAccess'),
            ],
        });
        this.role.attachInlinePolicy(new iam.Policy(this, 'datalake-administrator-basic', {
            statements: [
                new iam.PolicyStatement({
                    effect: iam.Effect.ALLOW,
                    actions: [
                        'iam:CreateServiceLinkedRole',
                    ],
                    resources: ['*'],
                    conditions: {
                        StringEquals: {
                            'iam:AWSServiceName': 'lakeformation.amazonaws.com',
                        },
                    },
                }),
                new iam.PolicyStatement({
                    effect: iam.Effect.ALLOW,
                    actions: [
                        'iam:PutRolePolicy',
                    ],
                    resources: [`arn:aws:iam::${accountId}:role/aws-service-role/lakeformation.amazonaws.com/AWSServiceRoleForLakeFormationDataAccess`],
                }),
            ],
        }));
        this.role.attachInlinePolicy(new iam.Policy(this, 'datalake-administrator-lambda-writeCW-logs', {
            statements: [
                new iam.PolicyStatement({
                    resources: ['*'],
                    actions: [
                        'logs:CreateLogGroup',
                        'logs:CreateLogStream',
                        'logs:PutLogEvents',
                    ],
                    effect: iam.Effect.ALLOW,
                    sid: 'AllowLogging',
                }),
            ],
        }));
        this.role.attachInlinePolicy(new iam.Policy(this, 'datalake-administrator-TBAC', {
            statements: [
                new iam.PolicyStatement({
                    effect: iam.Effect.ALLOW,
                    actions: [
                        'lakeformation:AddLFTagsToResource',
                        'lakeformation:RemoveLFTagsFromResource',
                        'lakeformation:GetResourceLFTags',
                        'lakeformation:ListLFTags',
                        'lakeformation:CreateLFTag',
                        'lakeformation:GetLFTag',
                        'lakeformation:UpdateLFTag',
                        'lakeformation:DeleteLFTag',
                        'lakeformation:SearchTablesByLFTags',
                        'lakeformation:SearchDatabasesByLFTags',
                    ],
                    resources: ['*'],
                }),
            ],
        }));
        this.role.attachInlinePolicy(new iam.Policy(this, 'datalake-administrator-cross-account', {
            statements: [
                new iam.PolicyStatement({
                    effect: iam.Effect.ALLOW,
                    actions: [
                        'ram:AcceptResourceShareInvitation',
                        'ram:RejectResourceShareInvitation',
                        'ec2:DescribeAvailabilityZones',
                        'ram:EnableSharingWithAwsOrganization',
                    ],
                    resources: ['*'],
                }),
            ],
        }));
        const lfAdminRole = new lf.CfnDataLakeSettings(this, 'lf-datalake-role-admin-settings', {
            admins: [{
                    dataLakePrincipalIdentifier: this.role.roleArn,
                }],
        });
        lfAdminRole.node.addDependency(this.role);
        new cdk.CfnOutput(this, 'DataLakeAdminRole', { value: this.role.roleName });
    }
}
exports.DataLakeAdministrator = DataLakeAdministrator;
_a = JSII_RTTI_SYMBOL_1;
DataLakeAdministrator[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.DataLakeAdministrator", version: "0.0.36" };
//# sourceMappingURL=data:application/json;base64,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