"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataLakeAnalyst = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class DataLakeAnalyst extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.user = new iam.User(this, 'DataAnalystUser', {
            userName: props.name,
            password: cdk.SecretValue.plainText(this.node.tryGetContext('initialPassword')),
            passwordResetRequired: true,
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonAthenaFullAccess'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('IAMUserChangePassword'),
            ],
        });
        // need to add access to Athena worgroup output S3 bucket
        this.user.attachInlinePolicy(new iam.Policy(this, 'DataAnalystPermissions', {
            policyName: 'DataAnalystPermissions',
            statements: [
                new iam.PolicyStatement({
                    effect: iam.Effect.ALLOW,
                    actions: [
                        'lakeformation:GetDataAccess',
                        'glue:GetTable',
                        'glue:GetTables',
                        'glue:SearchTables',
                        'glue:GetDatabase',
                        'glue:GetDatabases',
                        'glue:GetPartitions',
                    ],
                    resources: ['*'],
                }),
                new iam.PolicyStatement({
                    effect: iam.Effect.ALLOW,
                    actions: [
                        'lambda:InvokeFunction',
                    ],
                    resources: ['*'],
                }),
            ],
        }));
        if (props.readAccessBuckets) {
            props.readAccessBuckets.forEach(bucket => {
                bucket.grantRead(this.user);
            });
        }
        if (props.writeAccessBuckets) {
            props.writeAccessBuckets.forEach(bucket => {
                bucket.grantWrite(this.user);
            });
        }
    }
}
exports.DataLakeAnalyst = DataLakeAnalyst;
_a = JSII_RTTI_SYMBOL_1;
DataLakeAnalyst[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.DataLakeAnalyst", version: "0.0.36" };
//# sourceMappingURL=data:application/json;base64,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