import * as events from '@aws-cdk/aws-events';
import * as glue from '@aws-cdk/aws-glue';
import * as lambda from '@aws-cdk/aws-lambda';
import * as s3 from '@aws-cdk/aws-s3';
import * as cdk from '@aws-cdk/core';
import { GlueJobType, GlueVersion, GlueWorkerType } from './etl/glue-job';
/**
 * @experimental
 */
export interface JDBCProperties {
    /**
     * @experimental
     */
    readonly jdbc: string;
    /**
     * @experimental
     */
    readonly username: string;
    /**
     * @experimental
     */
    readonly password: string;
}
/**
 * @experimental
 */
export interface StreamProperties {
    /**
     * @experimental
     */
    readonly streamName: string;
    /**
     * @experimental
     */
    readonly lambdaDataGenerator?: LambdaDataGeneratorProperties;
}
/**
 * @experimental
 */
export interface S3Properties {
    /**
     * @experimental
     */
    readonly sourceBucketName: string;
    /**
     * @experimental
     */
    readonly sourceKeys: string[];
}
/**
 * @experimental
 */
export declare enum DataSetLocation {
    /**
     * @experimental
     */
    RAW = "raw",
    /**
     * @experimental
     */
    TRUSTED = "trusted",
    /**
     * @experimental
     */
    REFINED = "refined"
}
/**
 * @experimental
 */
export interface TableProps {
    /**
     * @experimental
     */
    readonly tableName: string;
    /**
     * @experimental
     */
    readonly description: string;
    /**
     * @experimental
     */
    readonly partitionKeys: Array<glue.CfnTable.ColumnProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * @experimental
     */
    readonly columns: Array<glue.CfnTable.ColumnProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * @experimental
     */
    readonly parameters: {
        [param: string]: any;
    };
    /**
     * @experimental
     */
    readonly serializationLibrary: string;
    /**
     * @experimental
     */
    readonly serdeParameters: {
        [param: string]: any;
    };
    /**
     * @experimental
     */
    readonly inputFormat: string;
    /**
     * @experimental
     */
    readonly outputFormat: string;
    /**
     * @experimental
     */
    readonly catalogId: string;
}
/**
 * @experimental
 */
export interface JobProperties {
    /**
     * @experimental
     */
    readonly name: string;
    /**
     * @experimental
     */
    readonly roleName?: string;
    /**
     * @experimental
     */
    readonly description?: string;
    /**
     * @experimental
     */
    readonly readAccessBuckets?: s3.IBucket[];
    /**
     * @experimental
     */
    readonly writeAccessBuckets?: s3.IBucket[];
    /**
     * @experimental
     */
    readonly glueVersion?: GlueVersion;
    /**
     * @experimental
     */
    readonly workerType: GlueWorkerType;
    /**
     * @experimental
     */
    readonly numberOfWorkers?: number;
    /**
     * @experimental
     */
    readonly maxCapacity?: number;
    /**
     * @experimental
     */
    readonly maxRetries?: number;
    /**
     * @experimental
     */
    readonly maxConcurrentRuns?: number;
    /**
     * @experimental
     */
    readonly jobScript: string;
    /**
     * @experimental
     */
    readonly jobArgs?: {
        [key: string]: string;
    };
    /**
     * @experimental
     */
    readonly timeout?: number;
    /**
     * @experimental
     */
    readonly jobType: GlueJobType;
    /**
     * @experimental
     */
    readonly destinationLocation?: DataSetLocation;
}
/**
 * @experimental
 */
export interface DataStreamProperties {
    /**
     * @experimental
     */
    readonly name: string;
    /**
     * @experimental
     */
    readonly destinationBucketName: string;
    /**
     * @experimental
     */
    readonly destinationPrefix: string;
    /**
     * @experimental
     */
    readonly dataCatalogOwner: DataCatalogOwner;
    /**
     * @experimental
     */
    readonly streamName: string;
    /**
     * @experimental
     */
    readonly lambdaDataGenerator: LambdaDataGeneratorProperties;
}
/**
 * @experimental
 */
export interface LambdaDataGeneratorProperties {
    /**
     * @experimental
     */
    readonly code: lambda.Code;
    /**
     * @experimental
     */
    readonly handler: string;
    /**
     * @experimental
     */
    readonly timeout: cdk.Duration;
    /**
     * @experimental
     */
    readonly runtime: lambda.Runtime;
    /**
     * @experimental
     */
    readonly functionName: string;
    /**
     * @experimental
     */
    readonly schedule: events.Schedule;
    /**
     * @experimental
     */
    readonly ruleName: string;
}
/**
 * @experimental
 */
export interface PipelineProperties {
    /**
     * @experimental
     */
    readonly type: DataPipelineType;
    /**
     * @experimental
     */
    readonly name: string;
    /**
     * @experimental
     */
    readonly destinationPrefix: string;
    /**
     * @experimental
     */
    readonly dataSetDropLocation: DataSetLocation;
    /**
     * @experimental
     */
    readonly s3Properties?: S3Properties;
    /**
     * @experimental
     */
    readonly streamProperties?: StreamProperties;
    /**
     * @experimental
     */
    readonly jdbcProperties?: JDBCProperties;
    /**
     * @experimental
     */
    readonly s3NotificationProps?: S3NotificationProperties;
    /**
     * @experimental
     */
    readonly table?: TableProps;
    /**
     * @experimental
     */
    readonly job?: JobProperties;
}
/**
 * @experimental
 */
export interface DataCatalogOwner {
    /**
     * @experimental
     */
    readonly accountId: string;
}
/**
 * @experimental
 */
export interface S3NotificationProperties {
    /**
     * @experimental
     */
    readonly event: s3.EventType;
    /**
     * @experimental
     */
    readonly prefix: string;
    /**
     * @experimental
     */
    readonly suffix: string;
}
/**
 * @experimental
 */
export declare enum DataPipelineType {
    /**
     * @experimental
     */
    STREAM = "stream",
    /**
     * @experimental
     */
    JDBC = "jdbc",
    /**
     * @experimental
     */
    S3 = "s3"
}
/**
 * @experimental
 */
export declare class Pipeline {
    /**
     * @experimental
     */
    readonly type: DataPipelineType;
    /**
     * @experimental
     */
    readonly name: string;
    /**
     * @experimental
     */
    readonly destinationPrefix: string;
    /**
     * @experimental
     */
    readonly dataSetDropLocation: DataSetLocation;
    /**
     * @experimental
     */
    readonly s3Properties?: S3Properties;
    /**
     * @experimental
     */
    readonly streamProperties?: StreamProperties;
    /**
     * @experimental
     */
    readonly jdbcProperties?: JDBCProperties;
    /**
     * @experimental
     */
    readonly s3NotificationProps?: S3NotificationProperties;
    /**
     * @experimental
     */
    readonly table?: TableProps;
    /**
     * @experimental
     */
    readonly job?: JobProperties;
    /**
     * @experimental
     */
    constructor(props: PipelineProperties);
}
