import * as events from '@aws-cdk/aws-events';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import * as cdk from '@aws-cdk/core';
import { Stage } from '../data-lake';
export interface ScheduledJobWorkflowProps {
    readonly schedule: events.Schedule;
    readonly name: string;
    readonly stageName: Stage;
    readonly jobName: string;
    readonly jobArguments: {
        [key: string]: any;
    };
    readonly jobTimeout: cdk.Duration;
}
export declare class ScheduledJobWorkflow extends cdk.Construct {
    readonly rule: events.Rule;
    readonly stateMachine: sfn.StateMachine;
    constructor(scope: cdk.Construct, id: string, props: ScheduledJobWorkflowProps);
    private getStateMachineFailureHandlerState;
}
