import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [mgn](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationmigrationservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Mgn extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [mgn](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationmigrationservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create volume snapshot group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toBatchCreateVolumeSnapshotGroupForMgn(): this;
    /**
     * Grants permission to batch delete snapshot request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toBatchDeleteSnapshotRequestForMgn(): this;
    /**
     * Grants permission to change source server life cycle state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ChangeServerLifeCycleState.html
     */
    toChangeServerLifeCycleState(): this;
    /**
     * Grants permission to create launch configuration template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateLaunchConfigurationTemplate.html
     */
    toCreateLaunchConfigurationTemplate(): this;
    /**
     * Grants permission to create replication configuration template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateReplicationConfigurationTemplate.html
     */
    toCreateReplicationConfigurationTemplate(): this;
    /**
     * Grants permission to create vcenter client
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toCreateVcenterClientForMgn(): this;
    /**
     * Grants permission to delete job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteJob.html
     */
    toDeleteJob(): this;
    /**
     * Grants permission to delete launch configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteLaunchConfigurationTemplate.html
     */
    toDeleteLaunchConfigurationTemplate(): this;
    /**
     * Grants permission to delete replication configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteReplicationConfigurationTemplate.html
     */
    toDeleteReplicationConfigurationTemplate(): this;
    /**
     * Grants permission to delete source server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteSourceServer.html
     */
    toDeleteSourceServer(): this;
    /**
     * Grants permission to delete vcenter client
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteVcenterClient.html
     */
    toDeleteVcenterClient(): this;
    /**
     * Grants permission to describe job log items
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeJobLogItems.html
     */
    toDescribeJobLogItems(): this;
    /**
     * Grants permission to describe jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeJobs.html
     */
    toDescribeJobs(): this;
    /**
     * Grants permission to describe launch configuration template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeLaunchConfigurationTemplates.html
     */
    toDescribeLaunchConfigurationTemplates(): this;
    /**
     * Grants permission to describe replication configuration template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeReplicationConfigurationTemplates.html
     */
    toDescribeReplicationConfigurationTemplates(): this;
    /**
     * Grants permission to describe replication server associations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toDescribeReplicationServerAssociationsForMgn(): this;
    /**
     * Grants permission to describe snapshots requests
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toDescribeSnapshotRequestsForMgn(): this;
    /**
     * Grants permission to describe source servers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeSourceServers.html
     */
    toDescribeSourceServers(): this;
    /**
     * Grants permission to describe vcenter clients
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeVcenterClients.html
     */
    toDescribeVcenterClients(): this;
    /**
     * Grants permission to disconnect source server from service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DisconnectFromService.html
     */
    toDisconnectFromService(): this;
    /**
     * Grants permission to finalize cutover
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_FinalizeCutover.html
     */
    toFinalizeCutover(): this;
    /**
     * Grants permission to get agent command
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentCommandForMgn(): this;
    /**
     * Grants permission to get agent confirmed resume info
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentConfirmedResumeInfoForMgn(): this;
    /**
     * Grants permission to get agent installation assets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentInstallationAssetsForMgn(): this;
    /**
     * Grants permission to get agent replication info
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentReplicationInfoForMgn(): this;
    /**
     * Grants permission to get agent runtime configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentRuntimeConfigurationForMgn(): this;
    /**
     * Grants permission to get agent snapshots credits
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentSnapshotCreditsForMgn(): this;
    /**
     * Grants permission to get channel commands
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetChannelCommandsForMgn(): this;
    /**
     * Grants permission to get launch configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_GetLaunchConfiguration.html
     */
    toGetLaunchConfiguration(): this;
    /**
     * Grants permission to get replication configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_GetReplicationConfiguration.html
     */
    toGetReplicationConfiguration(): this;
    /**
     * Grants permission to get vcenter client commands
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetVcenterClientCommandsForMgn(): this;
    /**
     * Grants permission to initialize service
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AddRoleToInstanceProfile
     * - iam:CreateInstanceProfile
     * - iam:CreateServiceLinkedRole
     * - iam:GetInstanceProfile
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_InitializeService.html
     */
    toInitializeService(): this;
    /**
     * Grants permission to issue a client certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toIssueClientCertificateForMgn(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to mark source server as archived
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_MarkAsArchived.html
     */
    toMarkAsArchived(): this;
    /**
     * Grants permission to notify agent authentication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyAgentAuthenticationForMgn(): this;
    /**
     * Grants permission to notify agent is connected
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyAgentConnectedForMgn(): this;
    /**
     * Grants permission to notify agent is disconnected
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyAgentDisconnectedForMgn(): this;
    /**
     * Grants permission to notify agent replication progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyAgentReplicationProgressForMgn(): this;
    /**
     * Grants permission to notify vcenter client started
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyVcenterClientStartedForMgn(): this;
    /**
     * Grants permission to register agent
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toRegisterAgentForMgn(): this;
    /**
     * Grants permission to retry replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_RetryDataReplication.html
     */
    toRetryDataReplication(): this;
    /**
     * Grants permission to send agent logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendAgentLogsForMgn(): this;
    /**
     * Grants permission to send agent metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendAgentMetricsForMgn(): this;
    /**
     * Grants permission to send channel command result
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendChannelCommandResultForMgn(): this;
    /**
     * Grants permission to send client logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendClientLogsForMgn(): this;
    /**
     * Grants permission to send client metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendClientMetricsForMgn(): this;
    /**
     * Grants permission to send vcenter client command result
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendVcenterClientCommandResultForMgn(): this;
    /**
     * Grants permission to send vcenter client logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendVcenterClientLogsForMgn(): this;
    /**
     * Grants permission to send vcenter client metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendVcenterClientMetricsForMgn(): this;
    /**
     * Grants permission to start cutover
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateLaunchTemplate
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:CreateSecurityGroup
     * - ec2:CreateSnapshot
     * - ec2:CreateTags
     * - ec2:CreateVolume
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteSnapshot
     * - ec2:DeleteVolume
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeVolumes
     * - ec2:DetachVolume
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:ReportInstanceStatus
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RunInstances
     * - ec2:StartInstances
     * - ec2:StopInstances
     * - ec2:TerminateInstances
     * - iam:PassRole
     * - mgn:ListTagsForResource
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartCutover.html
     */
    toStartCutover(): this;
    /**
     * Grants permission to start replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartReplication.html
     */
    toStartReplication(): this;
    /**
     * Grants permission to start test
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateLaunchTemplate
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:CreateSecurityGroup
     * - ec2:CreateSnapshot
     * - ec2:CreateTags
     * - ec2:CreateVolume
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteSnapshot
     * - ec2:DeleteVolume
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeVolumes
     * - ec2:DetachVolume
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:ReportInstanceStatus
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RunInstances
     * - ec2:StartInstances
     * - ec2:StopInstances
     * - ec2:TerminateInstances
     * - iam:PassRole
     * - mgn:ListTagsForResource
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartTest.html
     */
    toStartTest(): this;
    /**
     * Grants permission to assign a resource tag
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifCreateAction()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to terminate target instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:DeleteVolume
     * - ec2:DescribeInstances
     * - ec2:DescribeVolumes
     * - ec2:TerminateInstances
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_TerminateTargetInstances.html
     */
    toTerminateTargetInstances(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update agent backlog
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentBacklogForMgn(): this;
    /**
     * Grants permission to update agent conversion info
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentConversionInfoForMgn(): this;
    /**
     * Grants permission to update agent replication info
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentReplicationInfoForMgn(): this;
    /**
     * Grants permission to update agent replication process state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentReplicationProcessStateForMgn(): this;
    /**
     * Grants permission to update agent source properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentSourcePropertiesForMgn(): this;
    /**
     * Grants permission to update launch configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateLaunchConfiguration.html
     */
    toUpdateLaunchConfiguration(): this;
    /**
     * Grants permission to update launch configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateLaunchConfigurationTemplate.html
     */
    toUpdateLaunchConfigurationTemplate(): this;
    /**
     * Grants permission to update replication configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateReplicationConfiguration.html
     */
    toUpdateReplicationConfiguration(): this;
    /**
     * Grants permission to update replication configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateReplicationConfigurationTemplate.html
     */
    toUpdateReplicationConfigurationTemplate(): this;
    /**
     * Grants permission to update source server replication type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateSourceServerReplicationType.html
     */
    toUpdateSourceServerReplicationType(): this;
    /**
     * Grants permission to verify client role
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toVerifyClientRoleForMgn(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type JobResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/launching-target-servers.html
     *
     * @param jobID - Identifier for the jobID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJobResource(jobID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ReplicationConfigurationTemplateResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/replication-settings-template.html
     *
     * @param replicationConfigurationTemplateID - Identifier for the replicationConfigurationTemplateID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReplicationConfigurationTemplateResource(replicationConfigurationTemplateID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type LaunchConfigurationTemplateResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/launch-settings-template.html
     *
     * @param launchConfigurationTemplateID - Identifier for the launchConfigurationTemplateID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLaunchConfigurationTemplateResource(launchConfigurationTemplateID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type VcenterClientResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/vcenter-client.html
     *
     * @param vcenterClientID - Identifier for the vcenterClientID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVcenterClientResource(vcenterClientID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type SourceServerResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/source-servers.html
     *
     * @param sourceServerID - Identifier for the sourceServerID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSourceServerResource(sourceServerID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the name of a resource-creating API action
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/supported-iam-actions-tagging.html
     *
     * Applies to actions:
     * - .toTagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCreateAction(value: string | string[], operator?: Operator | string): this;
}
//# sourceMappingURL=applicationmigrationservice.d.ts.map