"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Auditmanager = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [auditmanager](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsauditmanager.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Auditmanager extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [auditmanager](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsauditmanager.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'auditmanager';
        this.accessLevelList = {
            Write: [
                'AssociateAssessmentReportEvidenceFolder',
                'BatchAssociateAssessmentReportEvidence',
                'BatchCreateDelegationByAssessment',
                'BatchDeleteDelegationByAssessment',
                'BatchDisassociateAssessmentReportEvidence',
                'BatchImportEvidenceToAssessmentControl',
                'CreateAssessment',
                'CreateAssessmentFramework',
                'CreateAssessmentReport',
                'CreateControl',
                'DeleteAssessment',
                'DeleteAssessmentFramework',
                'DeleteAssessmentFrameworkShare',
                'DeleteAssessmentReport',
                'DeleteControl',
                'DeregisterAccount',
                'DeregisterOrganizationAdminAccount',
                'DisassociateAssessmentReportEvidenceFolder',
                'RegisterAccount',
                'RegisterOrganizationAdminAccount',
                'StartAssessmentFrameworkShare',
                'UpdateAssessment',
                'UpdateAssessmentControl',
                'UpdateAssessmentControlSetStatus',
                'UpdateAssessmentFramework',
                'UpdateAssessmentFrameworkShare',
                'UpdateAssessmentStatus',
                'UpdateControl',
                'UpdateSettings'
            ],
            Read: [
                'GetAccountStatus',
                'GetAssessment',
                'GetAssessmentFramework',
                'GetAssessmentReportUrl',
                'GetChangeLogs',
                'GetControl',
                'GetEvidence',
                'GetEvidenceByEvidenceFolder',
                'GetEvidenceFolder',
                'GetEvidenceFoldersByAssessment',
                'GetEvidenceFoldersByAssessmentControl',
                'GetInsights',
                'GetInsightsByAssessment',
                'GetOrganizationAdminAccount',
                'GetServicesInScope',
                'GetSettings',
                'ListTagsForResource',
                'ValidateAssessmentReportIntegrity'
            ],
            List: [
                'GetDelegations',
                'ListAssessmentControlInsightsByControlDomain',
                'ListAssessmentFrameworkShareRequests',
                'ListAssessmentFrameworks',
                'ListAssessmentReports',
                'ListAssessments',
                'ListControlDomainInsights',
                'ListControlDomainInsightsByAssessment',
                'ListControlInsightsByControlDomain',
                'ListControls',
                'ListKeywordsForDataSource',
                'ListNotifications'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to associate an evidence folder with an assessment report in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_AssociateAssessmentReportEvidenceFolder.html
     */
    toAssociateAssessmentReportEvidenceFolder() {
        return this.to('AssociateAssessmentReportEvidenceFolder');
    }
    /**
     * Grants permission to associate a list of evidence to an assessment report in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchAssociateAssessmentReportEvidence.html
     */
    toBatchAssociateAssessmentReportEvidence() {
        return this.to('BatchAssociateAssessmentReportEvidence');
    }
    /**
     * Grants permission to create delegations for an assessment in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchCreateDelegationByAssessment.html
     */
    toBatchCreateDelegationByAssessment() {
        return this.to('BatchCreateDelegationByAssessment');
    }
    /**
     * Grants permission to delete delegations for an assessment in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchDeleteDelegationByAssessment.html
     */
    toBatchDeleteDelegationByAssessment() {
        return this.to('BatchDeleteDelegationByAssessment');
    }
    /**
     * Grants permission to disassociate a list of evidence from an assessment report in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchDisassociateAssessmentReportEvidence.html
     */
    toBatchDisassociateAssessmentReportEvidence() {
        return this.to('BatchDisassociateAssessmentReportEvidence');
    }
    /**
     * Grants permission to import a list of evidence to an assessment control in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchImportEvidenceToAssessmentControl.html
     */
    toBatchImportEvidenceToAssessmentControl() {
        return this.to('BatchImportEvidenceToAssessmentControl');
    }
    /**
     * Grants permission to create an assessment to be used with AWS Audit Manager
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessment.html
     */
    toCreateAssessment() {
        return this.to('CreateAssessment');
    }
    /**
     * Grants permission to create a framework for use in AWS Audit Manager
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessmentFramework.html
     */
    toCreateAssessmentFramework() {
        return this.to('CreateAssessmentFramework');
    }
    /**
     * Grants permission to create an assessment report in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessmentReport.html
     */
    toCreateAssessmentReport() {
        return this.to('CreateAssessmentReport');
    }
    /**
     * Grants permission to create a control to be used in AWS Audit Manager
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateControl.html
     */
    toCreateControl() {
        return this.to('CreateControl');
    }
    /**
     * Grants permission to delete an assessment in AWS Audit Manager
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessment.html
     */
    toDeleteAssessment() {
        return this.to('DeleteAssessment');
    }
    /**
     * Grants permission to delete an assessment framework in AWS Audit Manager
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFramework.html
     */
    toDeleteAssessmentFramework() {
        return this.to('DeleteAssessmentFramework');
    }
    /**
     * Grants permission to delete a share request for a custom framework in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFrameworkShare.html
     */
    toDeleteAssessmentFrameworkShare() {
        return this.to('DeleteAssessmentFrameworkShare');
    }
    /**
     * Grants permission to delete an assessment report in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentReport.html
     */
    toDeleteAssessmentReport() {
        return this.to('DeleteAssessmentReport');
    }
    /**
     * Grants permission to delete a control in AWS Audit Manager
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteControl.html
     */
    toDeleteControl() {
        return this.to('DeleteControl');
    }
    /**
     * Grants permission to deregister an account in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ DeregisterAccount.html
     */
    toDeregisterAccount() {
        return this.to('DeregisterAccount');
    }
    /**
     * Grants permission to deregister the delegated administrator account for AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeregisterOrganizationAdminAccount.html
     */
    toDeregisterOrganizationAdminAccount() {
        return this.to('DeregisterOrganizationAdminAccount');
    }
    /**
     * Grants permission to disassociate an evidence folder from an assessment report in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DisassociateAssessmentReportEvidenceFolder.html
     */
    toDisassociateAssessmentReportEvidenceFolder() {
        return this.to('DisassociateAssessmentReportEvidenceFolder');
    }
    /**
     * Grants permission to get the status of an account in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetAccountStatus.html
     */
    toGetAccountStatus() {
        return this.to('GetAccountStatus');
    }
    /**
     * Grants permission to get an assessment created in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetAssessment.html
     */
    toGetAssessment() {
        return this.to('GetAssessment');
    }
    /**
     * Grants permission to get an assessment framework in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetAssessmentFramework.html
     */
    toGetAssessmentFramework() {
        return this.to('GetAssessmentFramework');
    }
    /**
     * Grants permission to get the URL for an assessment report in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetAssessmentReportUrl.html
     */
    toGetAssessmentReportUrl() {
        return this.to('GetAssessmentReportUrl');
    }
    /**
     * Grants permission to get changelogs for an assessment in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetChangeLogs.html
     */
    toGetChangeLogs() {
        return this.to('GetChangeLogs');
    }
    /**
     * Grants permission to get a control in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetControl.html
     */
    toGetControl() {
        return this.to('GetControl');
    }
    /**
     * Grants permission to get all delegations in AWS Audit Manager
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetDelegations.html
     */
    toGetDelegations() {
        return this.to('GetDelegations');
    }
    /**
     * Grants permission to get evidence from AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidence.html
     */
    toGetEvidence() {
        return this.to('GetEvidence');
    }
    /**
     * Grants permission to get all the evidence from an evidence folder in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceByEvidenceFolder.html
     */
    toGetEvidenceByEvidenceFolder() {
        return this.to('GetEvidenceByEvidenceFolder');
    }
    /**
     * Grants permission to get the evidence folder from AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceFolder.html
     */
    toGetEvidenceFolder() {
        return this.to('GetEvidenceFolder');
    }
    /**
     * Grants permission to get the evidence folders from an assessment in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceFoldersByAssessment.html
     */
    toGetEvidenceFoldersByAssessment() {
        return this.to('GetEvidenceFoldersByAssessment');
    }
    /**
     * Grants permission to get the evidence folders from an assessment control in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceFoldersByAssessmentControl.html
     */
    toGetEvidenceFoldersByAssessmentControl() {
        return this.to('GetEvidenceFoldersByAssessmentControl');
    }
    /**
     * Grants permission to get analytics data for all active assessments
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetInsights.html
     */
    toGetInsights() {
        return this.to('GetInsights');
    }
    /**
     * Grants permission to get analytics data for a specific active assessment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetInsightsByAssessment.html
     */
    toGetInsightsByAssessment() {
        return this.to('GetInsightsByAssessment');
    }
    /**
     * Grants permission to get the delegated administrator account in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetOrganizationAdminAccount.html
     */
    toGetOrganizationAdminAccount() {
        return this.to('GetOrganizationAdminAccount');
    }
    /**
     * Grants permission to get the services in scope for an assessment in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetServicesInScope.html
     */
    toGetServicesInScope() {
        return this.to('GetServicesInScope');
    }
    /**
     * Grants permission to get all settings configured in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetSettings.html
     */
    toGetSettings() {
        return this.to('GetSettings');
    }
    /**
     * Grants permission to list analytics data for controls in a specific control domain and active assessment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessmentControlInsightsByControlDomain.html
     */
    toListAssessmentControlInsightsByControlDomain() {
        return this.to('ListAssessmentControlInsightsByControlDomain');
    }
    /**
     * Grants permission to list all sent or received share requests for custom frameworks in AWS Audit Manager
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessmentFrameworkShareRequests.html
     */
    toListAssessmentFrameworkShareRequests() {
        return this.to('ListAssessmentFrameworkShareRequests');
    }
    /**
     * Grants permission to list all assessment frameworks in AWS Audit Manager
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessmentFrameworks.html
     */
    toListAssessmentFrameworks() {
        return this.to('ListAssessmentFrameworks');
    }
    /**
     * Grants permission to list all assessment reports in AWS Audit Manager
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessmentReports.html
     */
    toListAssessmentReports() {
        return this.to('ListAssessmentReports');
    }
    /**
     * Grants permission to list all assessments in AWS Audit Manager
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessments.html
     */
    toListAssessments() {
        return this.to('ListAssessments');
    }
    /**
     * Grants permission to list analytics data for control domains across all active assessments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListControlDomainInsights.html
     */
    toListControlDomainInsights() {
        return this.to('ListControlDomainInsights');
    }
    /**
     * Grants permission to list analytics data for control domains in a specific active assessment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListControlDomainInsightsByAssessment.html
     */
    toListControlDomainInsightsByAssessment() {
        return this.to('ListControlDomainInsightsByAssessment');
    }
    /**
     * Grants permission to list analytics data for controls in a specific control domain across all active assessments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListControlInsightsByControlDomain.html
     */
    toListControlInsightsByControlDomain() {
        return this.to('ListControlInsightsByControlDomain');
    }
    /**
     * Grants permission to list all controls in AWS Audit Manager
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListControls.html
     */
    toListControls() {
        return this.to('ListControls');
    }
    /**
     * Grants permission to list all the data source keywords in AWS Audit Manager
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListKeywordsForDataSource.html
     */
    toListKeywordsForDataSource() {
        return this.to('ListKeywordsForDataSource');
    }
    /**
     * Grants permission to list all notifications in AWS Audit Manager
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListNotifications.html
     */
    toListNotifications() {
        return this.to('ListNotifications');
    }
    /**
     * Grants permission to list tags for an AWS Audit Manager resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to register an account in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_RegisterAccount.html
     */
    toRegisterAccount() {
        return this.to('RegisterAccount');
    }
    /**
     * Grants permission to register an account within the organization as the delegated administrator for AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_RegisterOrganizationAdminAccount.html
     */
    toRegisterOrganizationAdminAccount() {
        return this.to('RegisterOrganizationAdminAccount');
    }
    /**
     * Grants permission to create a share request for a custom framework in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_StartAssessmentFrameworkShare.html
     */
    toStartAssessmentFrameworkShare() {
        return this.to('StartAssessmentFrameworkShare');
    }
    /**
     * Grants permission to tag an AWS Audit Manager resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag an AWS Audit Manager resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update an assessment in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessment.html
     */
    toUpdateAssessment() {
        return this.to('UpdateAssessment');
    }
    /**
     * Grants permission to update an assessment control in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentControl.html
     */
    toUpdateAssessmentControl() {
        return this.to('UpdateAssessmentControl');
    }
    /**
     * Grants permission to update the status of an assessment control set in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentControlSetStatus.html
     */
    toUpdateAssessmentControlSetStatus() {
        return this.to('UpdateAssessmentControlSetStatus');
    }
    /**
     * Grants permission to update an assessment framework in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentFramework.html
     */
    toUpdateAssessmentFramework() {
        return this.to('UpdateAssessmentFramework');
    }
    /**
     * Grants permission to update a share request for a custom framework in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentFrameworkShare.html
     */
    toUpdateAssessmentFrameworkShare() {
        return this.to('UpdateAssessmentFrameworkShare');
    }
    /**
     * Grants permission to update the status of an assessment in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentStatus.html
     */
    toUpdateAssessmentStatus() {
        return this.to('UpdateAssessmentStatus');
    }
    /**
     * Grants permission to update a control in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateControl.html
     */
    toUpdateControl() {
        return this.to('UpdateControl');
    }
    /**
     * Grants permission to update settings in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateSettings.html
     */
    toUpdateSettings() {
        return this.to('UpdateSettings');
    }
    /**
     * Grants permission to validate the integrity of an assessment report in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ValidateAssessmentReportIntegrity.html
     */
    toValidateAssessmentReportIntegrity() {
        return this.to('ValidateAssessmentReportIntegrity');
    }
    /**
     * Adds a resource of type assessment to the statement
     *
     * https://docs.aws.amazon.com/audit-manager/latest/userguide/API_Assessment.html
     *
     * @param assessmentId - Identifier for the assessmentId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAssessment(assessmentId, account, region, partition) {
        return this.on(`arn:${partition || Auditmanager.defaultPartition}:auditmanager:${region || '*'}:${account || '*'}:assessment/${assessmentId}`);
    }
    /**
     * Adds a resource of type assessmentFramework to the statement
     *
     * https://docs.aws.amazon.com/audit-manager/latest/userguide/API_AssessmentFramework.html
     *
     * @param assessmentFrameworkId - Identifier for the assessmentFrameworkId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAssessmentFramework(assessmentFrameworkId, account, region, partition) {
        return this.on(`arn:${partition || Auditmanager.defaultPartition}:auditmanager:${region || '*'}:${account || '*'}:assessmentFramework/${assessmentFrameworkId}`);
    }
    /**
     * Adds a resource of type assessmentControlSet to the statement
     *
     * https://docs.aws.amazon.com/audit-manager/latest/userguide/API_AssessmentControlSet.html
     *
     * @param assessmentId - Identifier for the assessmentId.
     * @param controlSetId - Identifier for the controlSetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAssessmentControlSet(assessmentId, controlSetId, account, region, partition) {
        return this.on(`arn:${partition || Auditmanager.defaultPartition}:auditmanager:${region || '*'}:${account || '*'}:assessment/${assessmentId}/ControlSet/${controlSetId}`);
    }
    /**
     * Adds a resource of type control to the statement
     *
     * https://docs.aws.amazon.com/audit-manager/latest/userguide/API_Control.html
     *
     * @param controlId - Identifier for the controlId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onControl(controlId, account, region, partition) {
        return this.on(`arn:${partition || Auditmanager.defaultPartition}:auditmanager:${region || '*'}:${account || '*'}:control/${controlId}`);
    }
}
exports.Auditmanager = Auditmanager;
_a = JSII_RTTI_SYMBOL_1;
Auditmanager[_a] = { fqn: "iam-floyd.Auditmanager", version: "0.381.0" };
//# sourceMappingURL=data:application/json;base64,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