import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [clouddirectory](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonclouddirectory.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Clouddirectory extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [clouddirectory](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonclouddirectory.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to add a new Facet to an object
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_AddFacetToObject.html
     */
    toAddFacetToObject(): this;
    /**
     * Grants permission to copy input published schema into Directory with same name and version as that of published schema
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ApplySchema.html
     */
    toApplySchema(): this;
    /**
     * Grants permission to attach an existing object to another existing object
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_AttachObject.html
     */
    toAttachObject(): this;
    /**
     * Grants permission to attach a policy object to any other object
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_AttachPolicy.html
     */
    toAttachPolicy(): this;
    /**
     * Grants permission to attach the specified object to the specified index
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_AttachToIndex.html
     */
    toAttachToIndex(): this;
    /**
     * Grants permission to attach a typed link b/w a source & target object reference
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_AttachTypedLink.html
     */
    toAttachTypedLink(): this;
    /**
     * Grants permission to perform all the read operations in a batch. Each individual operation inside BatchRead needs to be granted permissions explicitly
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_BatchRead.html
     */
    toBatchRead(): this;
    /**
     * Grants permission to perform all the write operations in a batch. Each individual operation inside BatchWrite needs to be granted permissions explicitly
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_BatchWrite.html
     */
    toBatchWrite(): this;
    /**
     * Grants permission to create a Directory by copying the published schema into the directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateDirectory.html
     */
    toCreateDirectory(): this;
    /**
     * Grants permission to create a new Facet in a schema
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateFacet.html
     */
    toCreateFacet(): this;
    /**
     * Grants permission to create an index object
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateIndex.html
     */
    toCreateIndex(): this;
    /**
     * Grants permission to create an object in a Directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateObject.html
     */
    toCreateObject(): this;
    /**
     * Grants permission to create a new schema in a development state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateSchema.html
     */
    toCreateSchema(): this;
    /**
     * Grants permission to create a new Typed Link facet in a schema
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateTypedLinkFacet.html
     */
    toCreateTypedLinkFacet(): this;
    /**
     * Grants permission to delete a directory. Only disabled directories can be deleted
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DeleteDirectory.html
     */
    toDeleteDirectory(): this;
    /**
     * Grants permission to delete a given Facet. All attributes and Rules associated with the facet will be deleted
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DeleteFacet.html
     */
    toDeleteFacet(): this;
    /**
     * Grants permission to delete an object and its associated attributes
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DeleteObject.html
     */
    toDeleteObject(): this;
    /**
     * Grants permission to delete a given schema
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DeleteSchema.html
     */
    toDeleteSchema(): this;
    /**
     * Grants permission to delete a given TypedLink Facet. All attributes and Rules associated with the facet will be deleted
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DeleteTypedLinkFacet.html
     */
    toDeleteTypedLinkFacet(): this;
    /**
     * Grants permission to detach the specified object from the specified index
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DetachFromIndex.html
     */
    toDetachFromIndex(): this;
    /**
     * Grants permission to detach a given object from the parent object
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DetachObject.html
     */
    toDetachObject(): this;
    /**
     * Grants permission to detach a policy from an object
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DetachPolicy.html
     */
    toDetachPolicy(): this;
    /**
     * Grants permission to detach a given typed link b/w given source and target object reference
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DetachTypedLink.html
     */
    toDetachTypedLink(): this;
    /**
     * Grants permission to disable the specified directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DisableDirectory.html
     */
    toDisableDirectory(): this;
    /**
     * Grants permission to enable the specified directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_EnableDirectory.html
     */
    toEnableDirectory(): this;
    /**
     * Grants permission to return current applied schema version ARN, including the minor version in use
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetAppliedSchemaVersion.html
     */
    toGetAppliedSchemaVersion(): this;
    /**
     * Grants permission to retrieve metadata about a directory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetDirectory.html
     */
    toGetDirectory(): this;
    /**
     * Grants permission to get details of the Facet, such as Facet Name, Attributes, Rules, or ObjectType
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetFacet.html
     */
    toGetFacet(): this;
    /**
     * Grants permission to retrieve attributes that are associated with a typed link
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetLinkAttributes.html
     */
    toGetLinkAttributes(): this;
    /**
     * Grants permission to retrieve attributes within a facet that are associated with an object
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetObjectAttributes.html
     */
    toGetObjectAttributes(): this;
    /**
     * Grants permission to retrieve metadata about an object
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetObjectInformation.html
     */
    toGetObjectInformation(): this;
    /**
     * Grants permission to retrieve a JSON representation of the schema
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetSchemaAsJson.html
     */
    toGetSchemaAsJson(): this;
    /**
     * Grants permission to return identity attributes order information associated with a given typed link facet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetTypedLinkFacetInformation.html
     */
    toGetTypedLinkFacetInformation(): this;
    /**
     * Grants permission to list schemas applied to a directory
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListAppliedSchemaArns.html
     */
    toListAppliedSchemaArns(): this;
    /**
     * Grants permission to list indices attached to an object
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListAttachedIndices.html
     */
    toListAttachedIndices(): this;
    /**
     * Grants permission to retrieve the ARNs of schemas in the development state
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListDevelopmentSchemaArns.html
     */
    toListDevelopmentSchemaArns(): this;
    /**
     * Grants permission to list directories created within an account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListDirectories.html
     */
    toListDirectories(): this;
    /**
     * Grants permission to retrieve attributes attached to the facet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListFacetAttributes.html
     */
    toListFacetAttributes(): this;
    /**
     * Grants permission to retrieve the names of facets that exist in a schema
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListFacetNames.html
     */
    toListFacetNames(): this;
    /**
     * Grants permission to return a paginated list of all incoming TypedLinks for a given object
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListIncomingTypedLinks.html
     */
    toListIncomingTypedLinks(): this;
    /**
     * Grants permission to list objects attached to the specified index
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListIndex.html
     */
    toListIndex(): this;
    /**
     * Grants permission to list the major version families of each managed schema. If a major version ARN is provided as SchemaArn, the minor version revisions in that family are listed instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListManagedSchemaArns.html
     */
    toListManagedSchemaArns(): this;
    /**
     * Grants permission to list all attributes associated with an object
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListObjectAttributes.html
     */
    toListObjectAttributes(): this;
    /**
     * Grants permission to return a paginated list of child objects associated with a given object
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListObjectChildren.html
     */
    toListObjectChildren(): this;
    /**
     * Grants permission to retrieve all available parent paths for any object type such as node, leaf node, policy node, and index node objects
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListObjectParentPaths.html
     */
    toListObjectParentPaths(): this;
    /**
     * Grants permission to list parent objects associated with a given object in pagination fashion
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListObjectParents.html
     */
    toListObjectParents(): this;
    /**
     * Grants permission to return policies attached to an object in pagination fashion
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListObjectPolicies.html
     */
    toListObjectPolicies(): this;
    /**
     * Grants permission to return a paginated list of all outgoing TypedLinks for a given object
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListOutgoingTypedLinks.html
     */
    toListOutgoingTypedLinks(): this;
    /**
     * Grants permission to return all of the ObjectIdentifiers to which a given policy is attached
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListPolicyAttachments.html
     */
    toListPolicyAttachments(): this;
    /**
     * Grants permission to retrieve published schema ARNs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListPublishedSchemaArns.html
     */
    toListPublishedSchemaArns(): this;
    /**
     * Grants permission to return tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to return a paginated list of attributes associated with typed link facet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListTypedLinkFacetAttributes.html
     */
    toListTypedLinkFacetAttributes(): this;
    /**
     * Grants permission to return a paginated list of typed link facet names that exist in a schema
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListTypedLinkFacetNames.html
     */
    toListTypedLinkFacetNames(): this;
    /**
     * Grants permission to list all policies from the root of the Directory to the object specified
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_LookupPolicy.html
     */
    toLookupPolicy(): this;
    /**
     * Grants permission to publish a development schema with a version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_PublishSchema.html
     */
    toPublishSchema(): this;
    /**
     * Grants permission to update a schema using JSON upload. Only available for development schemas
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_PutSchemaFromJson.html
     */
    toPutSchemaFromJson(): this;
    /**
     * Grants permission to remove the specified facet from the specified object
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_RemoveFacetFromObject.html
     */
    toRemoveFacetFromObject(): this;
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to add/update/delete existing Attributes, Rules, or ObjectType of a Facet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpdateFacet.html
     */
    toUpdateFacet(): this;
    /**
     * Grants permission to update a given typed link’s attributes. Attributes to be updated must not contribute to the typed link’s identity, as defined by its IdentityAttributeOrder
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpdateLinkAttributes.html
     */
    toUpdateLinkAttributes(): this;
    /**
     * Grants permission to update a given object's attributes
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpdateObjectAttributes.html
     */
    toUpdateObjectAttributes(): this;
    /**
     * Grants permission to update the schema name with a new name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpdateSchema.html
     */
    toUpdateSchema(): this;
    /**
     * Grants permission to add/update/delete existing Attributes, Rules, identity attribute order of a TypedLink Facet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpdateTypedLinkFacet.html
     */
    toUpdateTypedLinkFacet(): this;
    /**
     * Grants permission to upgrade a single directory in-place using the PublishedSchemaArn with schema updates found in MinorVersion. Backwards-compatible minor version upgrades are instantaneously available for readers on all objects in the directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpgradeAppliedSchema.html
     */
    toUpgradeAppliedSchema(): this;
    /**
     * Grants permission to upgrade a published schema under a new minor version revision using the current contents of DevelopmentSchemaArn
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpgradePublishedSchema.html
     */
    toUpgradePublishedSchema(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type appliedSchema to the statement
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#whatisdirectory
     *
     * @param directoryId - Identifier for the directoryId.
     * @param schemaName - Identifier for the schemaName.
     * @param version - Identifier for the version.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAppliedSchema(directoryId: string, schemaName: string, version: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type developmentSchema to the statement
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#whatisdirectory
     *
     * @param schemaName - Identifier for the schemaName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDevelopmentSchema(schemaName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type directory to the statement
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#whatisdirectory
     *
     * @param directoryId - Identifier for the directoryId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDirectory(directoryId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type publishedSchema to the statement
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#whatisdirectory
     *
     * @param schemaName - Identifier for the schemaName.
     * @param version - Identifier for the version.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPublishedSchema(schemaName: string, version: string, account?: string, region?: string, partition?: string): this;
}
//# sourceMappingURL=clouddirectory.d.ts.map