import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [devops-guru](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondevopsguru.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class DevopsGuru extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [devops-guru](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondevopsguru.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to add a notification channel to DevOps Guru
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sns:GetTopicAttributes
     * - sns:SetTopicAttributes
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_AddNotificationChannel.html
     */
    toAddNotificationChannel(): this;
    /**
     * Grants permission to delete specified insight in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DeleteInsight.html
     */
    toDeleteInsight(): this;
    /**
     * Grants permission to view the health of operations in your AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeAccountHealth.html
     */
    toDescribeAccountHealth(): this;
    /**
     * Grants permission to view the health of operations within a time range in your AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeAccountOverview.html
     */
    toDescribeAccountOverview(): this;
    /**
     * Grants permission to list the details of a specified anomaly
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeAnomaly.html
     */
    toDescribeAnomaly(): this;
    /**
     * Grants permission to retrieve details about event sources for DevOps Guru
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeEventSourcesConfig.html
     */
    toDescribeEventSourcesConfig(): this;
    /**
     * Grants permission to view the feedback details of a specified insight
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeFeedback.html
     */
    toDescribeFeedback(): this;
    /**
     * Grants permission to list the details of a specified insight
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeInsight.html
     */
    toDescribeInsight(): this;
    /**
     * Grants permission to view the health of operations in your organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeOrganizationAccountHealth.html
     */
    toDescribeOrganizationHealth(): this;
    /**
     * Grants permission to view the health of operations within a time range in your organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeOrganizationOverview.html
     */
    toDescribeOrganizationOverview(): this;
    /**
     * Grants permission to view the health of operations for each AWS CloudFormation stack or AWS Services or accounts specified in DevOps Guru in your organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeOrganizationResourceCollectionHealth.html
     */
    toDescribeOrganizationResourceCollectionHealth(): this;
    /**
     * Grants permission to view the health of operations for each AWS CloudFormation stack specified in DevOps Guru
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeResourceCollectionHealth.html
     */
    toDescribeResourceCollectionHealth(): this;
    /**
     * Grants permission to view the integration status of services that can be integrated with DevOps Guru
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeServiceIntegration.html
     */
    toDescribeServiceIntegration(): this;
    /**
     * Grants permission to list service resource cost estimates
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_GetCostEstimation.html
     */
    toGetCostEstimation(): this;
    /**
     * Grants permission to list AWS CloudFormation stacks that DevOps Guru is configured to use
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_GetResourceCollection.html
     */
    toGetResourceCollection(): this;
    /**
     * Grants permission to list anomalies of a given insight in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListAnomaliesForInsight.html
     */
    toListAnomaliesForInsight(): this;
    /**
     * Grants permission to list resource events that are evaluated by DevOps Guru
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListEvents.html
     */
    toListEvents(): this;
    /**
     * Grants permission to list insights in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListInsights.html
     */
    toListInsights(): this;
    /**
     * Grants permission to list notification channels configured for DevOps Guru in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListNotificationChannels.html
     */
    toListNotificationChannels(): this;
    /**
     * Grants permission to list insights in your organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListOrganizationInsights.html
     */
    toListOrganizationInsights(): this;
    /**
     * Grants permission to list a specified insight's recommendations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListRecommendations.html
     */
    toListRecommendations(): this;
    /**
     * Grants permission to submit a feedback to DevOps Guru
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PutFeedback.html
     */
    toPutFeedback(): this;
    /**
     * Grants permission to remove a notification channel from DevOps Guru
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sns:GetTopicAttributes
     * - sns:SetTopicAttributes
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_RemoveNotificationChannel.html
     */
    toRemoveNotificationChannel(): this;
    /**
     * Grants permission to search insights in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_SearchInsights.html
     */
    toSearchInsights(): this;
    /**
     * Grants permission to search insights in your organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_SearchOrganizationInsights.html
     */
    toSearchOrganizationInsights(): this;
    /**
     * Grants permission to start the creation of an estimate of the monthly cost
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_StartCostEstimation.html
     */
    toStartCostEstimation(): this;
    /**
     * Grants permission to update an event source for DevOps Guru
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_UpdateEventSourcesConfig.html
     */
    toUpdateEventSourcesConfig(): this;
    /**
     * Grants permission to update the list of AWS CloudFormation stacks that are used to specify which AWS resources in your account are analyzed by DevOps Guru
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_UpdateResourceCollection.html
     */
    toUpdateResourceCollection(): this;
    /**
     * Grants permission to enable or disable a service that integrates with DevOps Guru
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_UpdateServiceIntegration.html
     */
    toUpdateServiceIntegration(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type topic to the statement
     *
     * https://docs.aws.amazon.com/devops-guru/latest/userguide/CreateTopic.html
     *
     * @param topicName - Identifier for the topicName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTopic(topicName: string, account?: string, region?: string, partition?: string): this;
}
//# sourceMappingURL=devopsguru.d.ts.map