import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [finspace](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfinspace.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Finspace extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [finspace](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonfinspace.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a FinSpace environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_CreateEnvironment.html
     */
    toCreateEnvironment(): this;
    /**
     * Grants permission to create a FinSpace user
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-what-is.html
     */
    toCreateUser(): this;
    /**
     * Grants permission to delete a FinSpace environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_DeleteEnvironment.html
     */
    toDeleteEnvironment(): this;
    /**
     * Grants permission to describe a FinSpace environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_GetEnvironment.html
     */
    toGetEnvironment(): this;
    /**
     * Grants permission to request status of the loading of sample data bundle
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-what-is.html
     */
    toGetLoadSampleDataSetGroupIntoEnvironmentStatus(): this;
    /**
     * Grants permission to describe a FinSpace user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-what-is.html
     */
    toGetUser(): this;
    /**
     * Grants permission to list FinSpace environments in the AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_ListEnvironments.html
     */
    toListEnvironments(): this;
    /**
     * Grants permission to return a list of tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list FinSpace users in an environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-what-is.html
     */
    toListUsers(): this;
    /**
     * Grants permission to load sample data bundle into your FinSpace environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-what-is.html
     */
    toLoadSampleDataSetGroupIntoEnvironment(): this;
    /**
     * Grants permission to reset the password for a FinSpace user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-what-is.html
     */
    toResetUserPassword(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a FinSpace environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/management-api/API_UpdateEnvironment.html
     */
    toUpdateEnvironment(): this;
    /**
     * Grants permission to update a FinSpace user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-what-is.html
     */
    toUpdateUser(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type environment to the statement
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-example-policies.html
     *
     * @param environmentId - Identifier for the environmentId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironment(environmentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type user to the statement
     *
     * https://docs.aws.amazon.com/finspace/latest/userguide/finspace-example-policies.html
     *
     * @param userId - Identifier for the userId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUser(userId: string, account?: string, region?: string, partition?: string): this;
}
//# sourceMappingURL=finspace.d.ts.map