import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [iotjobsdata](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotjobsdataplane.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Iotjobsdata extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [iotjobsdata](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotjobsdataplane.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to describe a job execution
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifIotJobId()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iot-jobs-data_DescribeJobExecution.html
     */
    toDescribeJobExecution(): this;
    /**
     * Grants permission to get the list of all jobs for a thing that are not in a terminal state
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iot-jobs-data_GetPendingJobExecutions.html
     */
    toGetPendingJobExecutions(): this;
    /**
     * Grants permission to get and start the next pending job execution for a thing
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iot-jobs-data_StartNextPendingJobExecution.html
     */
    toStartNextPendingJobExecution(): this;
    /**
     * Grants permission to update a job execution
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifIotJobId()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iot-jobs-data_UpdateJobExecution.html
     */
    toUpdateJobExecution(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type thing to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/thing-registry.html
     *
     * @param thingName - Identifier for the thingName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onThing(thingName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by jobId for iotjobsdata:DescribeJobExecution and iotjobsdata:UpdateJobExecution APIs
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html
     *
     * Applies to actions:
     * - .toDescribeJobExecution()
     * - .toUpdateJobExecution()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifIotJobId(value: string | string[], operator?: Operator | string): this;
}
//# sourceMappingURL=iotjobsdataplane.d.ts.map