import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Lakeformation extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to attach Lake Formation tags to catalog resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-AddLFTagsToResource
     */
    toAddLFTagsToResource(): this;
    /**
     * Grants permission to data lake permissions to one or more principals in a batch
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-BatchGrantPermissions
     */
    toBatchGrantPermissions(): this;
    /**
     * Grants permission to revoke data lake permissions from one or more principals in a batch
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-BatchRevokePermissions
     */
    toBatchRevokePermissions(): this;
    /**
     * Grants permission to cancel the given transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-CancelTransaction
     */
    toCancelTransaction(): this;
    /**
     * Grants permission to commit the given transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-CommitTransaction
     */
    toCommitTransaction(): this;
    /**
     * Grants permission to create a Lake Formation data cell filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-data-filter.html#aws-lake-formation-api-data-filter-CreateDataCellsFilter
     */
    toCreateDataCellsFilter(): this;
    /**
     * Grants permission to create a Lake Formation tag
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-CreateLFTag
     */
    toCreateLFTag(): this;
    /**
     * Grants permission to delete a Lake Formation data cell filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-data-filter.html#aws-lake-formation-api-data-filter-DeleteDataCellsFilter
     */
    toDeleteDataCellsFilter(): this;
    /**
     * Grants permission to delete a Lake Formation tag
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-DeleteLFTag
     */
    toDeleteLFTag(): this;
    /**
     * Grants permission to delete the specified objects if the transaction is canceled
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-DeleteObjectsOnCancel
     */
    toDeleteObjectsOnCancel(): this;
    /**
     * Grants permission to deregister a registered location
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-DeregisterResource
     */
    toDeregisterResource(): this;
    /**
     * Grants permission to describe a registered location
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-DescribeResource
     */
    toDescribeResource(): this;
    /**
     * Grants permission to get status of the given transaction
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-DescribeTransaction
     */
    toDescribeTransaction(): this;
    /**
     * Grants permission to extend the timeout of the given transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-ExtendTransaction
     */
    toExtendTransaction(): this;
    /**
     * Grants permission to virtual data lake access
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetDataAccess
     */
    toGetDataAccess(): this;
    /**
     * Grants permission to retrieve data lake settings such as the list of data lake administrators and database and table default permissions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetDataLakeSettings
     */
    toGetDataLakeSettings(): this;
    /**
     * Grants permission to retrieve permissions attached to resources in the given path
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetEffectivePermissionsForPath
     */
    toGetEffectivePermissionsForPath(): this;
    /**
     * Grants permission to retrieve a Lake Formation tag
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetLFTag
     */
    toGetLFTag(): this;
    /**
     * Grants permission to retrieve the state of the given query
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-GetQueryState
     */
    toGetQueryState(): this;
    /**
     * Grants permission to retrieve the statistics for the given query
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-GetQueryStatistics
     */
    toGetQueryStatistics(): this;
    /**
     * Grants permission to retrieve lakeformation tags on a catalog resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetResourceLFTags
     */
    toGetResourceLFTags(): this;
    /**
     * Grants permission to retrieve objects from a table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-objects.html#aws-lake-formation-api-objects-GetTableObjects
     */
    toGetTableObjects(): this;
    /**
     * Grants permission to retrieve the results for the given work units
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:GetWorkUnits
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-GetWorkUnitResults
     */
    toGetWorkUnitResults(): this;
    /**
     * Grants permission to retrieve the work units for the given query
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeaformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-GetWorkUnits
     */
    toGetWorkUnits(): this;
    /**
     * Grants permission to data lake permissions to a principal
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GrantPermissions
     */
    toGrantPermissions(): this;
    /**
     * Grants permission to list cell filters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-data-filter.html#aws-lake-formation-api-data-filter-ListDataCellsFilter
     */
    toListDataCellsFilter(): this;
    /**
     * Grants permission to list Lake Formation tags
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-ListLFTags
     */
    toListLFTags(): this;
    /**
     * Grants permission to list permissions filtered by principal or resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-ListPermissions
     */
    toListPermissions(): this;
    /**
     * Grants permission to List registered locations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-ListResources
     */
    toListResources(): this;
    /**
     * Grants permission to list all the storage optimizers for the Governed table
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-optimizers.html#aws-lake-formation-api-optimizers-ListTableStorageOptimizers
     */
    toListTableStorageOptimizers(): this;
    /**
     * Grants permission to list all transactions in the system
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-ListTransactions
     */
    toListTransactions(): this;
    /**
     * Grants permission to overwrite data lake settings such as the list of data lake administrators and database and table default permissions
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-PutDataLakeSettings
     */
    toPutDataLakeSettings(): this;
    /**
     * Grants permission to register a new location to be managed by Lake Formation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-RegisterResource
     */
    toRegisterResource(): this;
    /**
     * Grants permission to remove lakeformation tags from catalog resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-RemoveLFTagsFromResource
     */
    toRemoveLFTagsFromResource(): this;
    /**
     * Grants permission to revoke data lake permissions from a principal
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-RevokePermissions
     */
    toRevokePermissions(): this;
    /**
     * Grants permission to list catalog databases with Lake Formation tags
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-SearchDatabasesByLFTags
     */
    toSearchDatabasesByLFTags(): this;
    /**
     * Grants permission to list catalog tables with Lake Formation tags
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-SearchTablesByLFTags
     */
    toSearchTablesByLFTags(): this;
    /**
     * Grants permission to initiate the planning of the given query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-StartQueryPlanning
     */
    toStartQueryPlanning(): this;
    /**
     * Grants permission to start a new transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-StartTransaction
     */
    toStartTransaction(): this;
    /**
     * Grants permission to update a Lake Formation tag
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-UpdateLFTag
     */
    toUpdateLFTag(): this;
    /**
     * Grants permission to update a registered location
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-UpdateResource
     */
    toUpdateResource(): this;
    /**
     * Grants permission to add or delete the specified objects to or from a table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-objects.html#aws-lake-formation-api-objects-UpdateTableObjects
     */
    toUpdateTableObjects(): this;
    /**
     * Grants permission to update the configuration of the storage optimizer for the Governed table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-optimizers.html#aws-lake-formation-api-optimizers-UpdateTableStorageOptimizer
     */
    toUpdateTableStorageOptimizer(): this;
    protected accessLevelList: AccessLevelList;
}
//# sourceMappingURL=lakeformation.d.ts.map