import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [outposts](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsoutposts.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Outposts extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [outposts](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsoutposts.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to cancel an order
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_CancelOrder.html
     */
    toCancelOrder(): this;
    /**
     * Grants permission to create an order
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_CreateOrder.html
     */
    toCreateOrder(): this;
    /**
     * Grants permission to create an Outpost
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_CreateOutpost.html
     */
    toCreateOutpost(): this;
    /**
     * Grants permission to create a private connectivity configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/how-outposts-works.html#private-connectivity
     */
    toCreatePrivateConnectivityConfig(): this;
    /**
     * Grants permission to create a site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_CreateSite.html
     */
    toCreateSite(): this;
    /**
     * Grants permission to delete an Outpost
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_DeleteOutpost.html
     */
    toDeleteOutpost(): this;
    /**
     * Grants permission to delete a site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_DeleteSite.html
     */
    toDeleteSite(): this;
    /**
     * Grants permission to get a catalog item
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_GetCatalogItem.html
     */
    toGetCatalogItem(): this;
    /**
     * Grants permission to get information about an order
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_GetOrder.html
     */
    toGetOrder(): this;
    /**
     * Grants permission to get information about the specified Outpost
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_GetOutpost.html
     */
    toGetOutpost(): this;
    /**
     * Grants permission to get the instance types for the specified Outpost
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_GetOutpostInstanceTypes.html
     */
    toGetOutpostInstanceTypes(): this;
    /**
     * Grants permission to get a private connectivity configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/how-outposts-works.html#private-connectivity
     */
    toGetPrivateConnectivityConfig(): this;
    /**
     * Grants permission to get a site
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_GetSite.html
     */
    toGetSite(): this;
    /**
     * Grants permission to get a site address
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_GetSiteAddress.html
     */
    toGetSiteAddress(): this;
    /**
     * Grants permission to list the assets for your Outpost
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_ListAssets.html
     */
    toListAssets(): this;
    /**
     * Grants permission to list all catalog items
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_ListCatalogItems.html
     */
    toListCatalogItems(): this;
    /**
     * Grants permission to list the orders for your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_ListOrders.html
     */
    toListOrders(): this;
    /**
     * Grants permission to list the Outposts for your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_ListOutposts.html
     */
    toListOutposts(): this;
    /**
     * Grants permission to list the sites for your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_ListSites.html
     */
    toListSites(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an Outpost
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_UpdateOutpost.html
     */
    toUpdateOutpost(): this;
    /**
     * Grants permission to update a site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_UpdateSite.html
     */
    toUpdateSite(): this;
    /**
     * Grants permission to update the site address
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_UpdateSiteAddress.html
     */
    toUpdateSiteAddress(): this;
    /**
     * Grants permission to update the physical properties of a rack at a site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/outposts/latest/APIReference/API_UpdateSiteRackPhysicalProperties.html
     */
    toUpdateSiteRackPhysicalProperties(): this;
    protected accessLevelList: AccessLevelList;
}
//# sourceMappingURL=outposts.d.ts.map