import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [resource-groups](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourcegroups.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class ResourceGroups extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [resource-groups](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourcegroups.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a resource group with a specified name, description, and resource query
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/API_CreateGroup.html
     */
    toCreateGroup(): this;
    /**
     * Grants permission to delete a specified resource group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/API_DeleteGroup.html
     */
    toDeleteGroup(): this;
    /**
     * Grants permission to get information of a specified resource group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/API_GetGroup.html
     */
    toGetGroup(): this;
    /**
     * Grants permission to get the service configuration associated with the specified resource group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/API_GetGroupConfiguration.html
     */
    toGetGroupConfiguration(): this;
    /**
     * Grants permission to get the query associated with a specified resource group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/API_GetGroupQuery.html
     */
    toGetGroupQuery(): this;
    /**
     * Grants permission to get the tags associated with a specified resource group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/API_GetTags.html
     */
    toGetTags(): this;
    /**
     * Grants permission to add the specified resources to the specified group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/API_GroupResources.html
     */
    toGroupResources(): this;
    /**
     * Grants permission to list the resources that are members of a specified resource group
     *
     * Access Level: List
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - tag:GetResources
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/API_ListGroupResources.html
     */
    toListGroupResources(): this;
    /**
     * Grants permission to list all resource groups in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/API_ListGroups.html
     */
    toListGroups(): this;
    /**
     * Grants permission to put the service configuration associated with the specified resource group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/API_PutGroupConfiguration.html
     */
    toPutGroupConfiguration(): this;
    /**
     * Grants permission to add a resource-based policy for the specified group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/LM_REDIRECT
     */
    toPutGroupPolicy(): this;
    /**
     * Grants permission to search for AWS resources matching the given query
     *
     * Access Level: List
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - tag:GetResources
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/API_SearchResources.html
     */
    toSearchResources(): this;
    /**
     * Grants permission to tag a specified resource group
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/API_Tag.html
     */
    toTag(): this;
    /**
     * Grants permission to remove the specified resources from the specified group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/API_UngroupResources.html
     */
    toUngroupResources(): this;
    /**
     * Grants permission to remove tags associated with a specified resource group
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/API_Untag.html
     */
    toUntag(): this;
    /**
     * Grants permission to update a specified resource group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/API_UpdateGroup.html
     */
    toUpdateGroup(): this;
    /**
     * Grants permission to update the query associated with a specified resource group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ARG/latest/APIReference/API_UpdateGroupQuery.html
     */
    toUpdateGroupQuery(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type group to the statement
     *
     * https://docs.aws.amazon.com/ARG/latest/userguide/welcome.html
     *
     * @param groupName - Identifier for the groupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onGroup(groupName: string, account?: string, region?: string, partition?: string): this;
}
//# sourceMappingURL=resourcegroups.d.ts.map