import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [serverlessrepo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserverlessapplicationrepository.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Serverlessrepo extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [serverlessrepo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserverlessapplicationrepository.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Creates an application, optionally including an AWS SAM file to create the first application version in the same call.
     *
     * Access Level: Write
     */
    toCreateApplication(): this;
    /**
     * Creates an application version.
     *
     * Access Level: Write
     */
    toCreateApplicationVersion(): this;
    /**
     * Creates an AWS CloudFormation ChangeSet for the given application.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifApplicationType()
     */
    toCreateCloudFormationChangeSet(): this;
    /**
     * Creates an AWS CloudFormation template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifApplicationType()
     */
    toCreateCloudFormationTemplate(): this;
    /**
     * Deletes the specified application
     *
     * Access Level: Write
     */
    toDeleteApplication(): this;
    /**
     * Gets the specified application.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifApplicationType()
     */
    toGetApplication(): this;
    /**
     * Gets the policy for the specified application.
     *
     * Access Level: Read
     */
    toGetApplicationPolicy(): this;
    /**
     * Gets the specified AWS CloudFormation template
     *
     * Access Level: Read
     */
    toGetCloudFormationTemplate(): this;
    /**
     * Retrieves the list of applications nested in the containing application
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifApplicationType()
     */
    toListApplicationDependencies(): this;
    /**
     * Lists versions for the specified application owned by the requester.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifApplicationType()
     */
    toListApplicationVersions(): this;
    /**
     * Lists applications owned by the requester.
     *
     * Access Level: List
     */
    toListApplications(): this;
    /**
     * Puts the policy for the specified application.
     *
     * Access Level: Write
     */
    toPutApplicationPolicy(): this;
    /**
     * Gets all applications authorized for this user
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifApplicationType()
     */
    toSearchApplications(): this;
    /**
     * Unshares the specified application
     *
     * Access Level: Write
     */
    toUnshareApplication(): this;
    /**
     * Updates meta-data of the application
     *
     * Access Level: Write
     */
    toUpdateApplication(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type applications to the statement
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onApplications(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Application type
     *
     * Applies to actions:
     * - .toCreateCloudFormationChangeSet()
     * - .toCreateCloudFormationTemplate()
     * - .toGetApplication()
     * - .toListApplicationDependencies()
     * - .toListApplicationVersions()
     * - .toSearchApplications()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifApplicationType(value: string | string[], operator?: Operator | string): this;
}
//# sourceMappingURL=serverlessapplicationrepository.d.ts.map