import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [ssmmessages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsessionmanagermessagegatewayservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Ssmmessages extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [ssmmessages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsessionmanagermessagegatewayservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to register a control channel for an instance to send control messages to Systems Manager service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/getting-started-create-iam-instance-profile.html
     */
    toCreateControlChannel(): this;
    /**
     * Grants permission to register a data channel for an instance to send data messages to Systems Manager service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/getting-started-create-iam-instance-profile.html
     */
    toCreateDataChannel(): this;
    /**
     * Grants permission to open a websocket connection for a registered control channel stream from an instance to Systems Manager service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/getting-started-create-iam-instance-profile.html
     */
    toOpenControlChannel(): this;
    /**
     * Grants permission to open a websocket connection for a registered data channel stream from an instance to Systems Manager service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/getting-started-create-iam-instance-profile.html
     */
    toOpenDataChannel(): this;
    protected accessLevelList: AccessLevelList;
}
//# sourceMappingURL=sessionmanagermessagegatewayservice.d.ts.map