import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [ssm-incidents](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerincidentmanager.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class SsmIncidents extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [ssm-incidents](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerincidentmanager.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a replication set
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateReplicationSet.html
     */
    toCreateReplicationSet(): this;
    /**
     * Grants permission to create a response plan
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateResponsePlan.html
     */
    toCreateResponsePlan(): this;
    /**
     * Grants permission to create a timeline event for an incident record
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateTimelineEvent.html
     */
    toCreateTimelineEvent(): this;
    /**
     * Grants permission to delete an incident record
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteIncidentRecord.html
     */
    toDeleteIncidentRecord(): this;
    /**
     * Grants permission to delete a replication set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteReplicationSet.html
     */
    toDeleteReplicationSet(): this;
    /**
     * Grants permission to delete resource policy from a response plan
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteResourcePolicy.html
     */
    toDeleteResourcePolicy(): this;
    /**
     * Grants permission to delete a response plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteResponsePlan.html
     */
    toDeleteResponsePlan(): this;
    /**
     * Grants permission to delete a timeline event
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteTimelineEvent.html
     */
    toDeleteTimelineEvent(): this;
    /**
     * Grants permission to view the contents of an incident record
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetIncidentRecord.html
     */
    toGetIncidentRecord(): this;
    /**
     * Grants permission to view the replication set
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetReplicationSet.html
     */
    toGetReplicationSet(): this;
    /**
     * Grants permission to view resource policies of a response plan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetResourcePolicies.html
     */
    toGetResourcePolicies(): this;
    /**
     * Grants permission to view the contents of a specified response plan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetResponsePlan.html
     */
    toGetResponsePlan(): this;
    /**
     * Grants permission to view a timeline event
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetTimelineEvent.html
     */
    toGetTimelineEvent(): this;
    /**
     * Grants permission to list the contents of all incident records
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListIncidentRecords.html
     */
    toListIncidentRecords(): this;
    /**
     * Grants permission to list related items of an incident records
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListRelatedItems.html
     */
    toListRelatedItems(): this;
    /**
     * Grants permission to list all replication sets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListReplicationSets.html
     */
    toListReplicationSets(): this;
    /**
     * Grants permission to list all response plans
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListResponsePlans.html
     */
    toListResponsePlans(): this;
    /**
     * Grants permission to view a list of resource tags for a specified resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list all timeline events for an incident record
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListTimelineEvents.html
     */
    toListTimelineEvents(): this;
    /**
     * Grants permission to put resource policy on a response plan
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_PutResourcePolicy.html
     */
    toPutResourcePolicy(): this;
    /**
     * Grants permission to start a new incident using a response plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_StartIncident.html
     */
    toStartIncident(): this;
    /**
     * Grants permission to add tags to a response plan
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a response plan
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update replication set deletion protection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateDeletionProtection.html
     */
    toUpdateDeletionProtection(): this;
    /**
     * Grants permission to update the contents of an incident record
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateIncidentRecord.html
     */
    toUpdateIncidentRecord(): this;
    /**
     * Grants permission to update related items of an incident record
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateRelatedItems.html
     */
    toUpdateRelatedItems(): this;
    /**
     * Grants permission to update a replication set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateReplicationSet.html
     */
    toUpdateReplicationSet(): this;
    /**
     * Grants permission to update the contents of a response plan
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateResponsePlan.html
     */
    toUpdateResponsePlan(): this;
    /**
     * Grants permission to update a timeline event
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateTimelineEvent.html
     */
    toUpdateTimelineEvent(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type response-plan to the statement
     *
     * https://docs.aws.amazon.com/incident-manager/latest/userguide/response-plans.html
     *
     * @param responsePlan - Identifier for the responsePlan.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onResponsePlan(responsePlan: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type incident-record to the statement
     *
     * https://docs.aws.amazon.com/incident-manager/latest/userguide/incident-record.html
     *
     * @param responsePlan - Identifier for the responsePlan.
     * @param incidentRecord - Identifier for the incidentRecord.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onIncidentRecord(responsePlan: string, incidentRecord: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type replication-set to the statement
     *
     * https://docs.aws.amazon.com/incident-manager/latest/userguide/replication-set.html
     *
     * @param replicationSet - Identifier for the replicationSet.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onReplicationSet(replicationSet: string, account?: string, partition?: string): this;
}
//# sourceMappingURL=systemsmanagerincidentmanager.d.ts.map