import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [workmail](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkmail.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Workmail extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [workmail](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkmail.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to add a list of members (users or groups) to a group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     */
    toAddMembersToGroup(): this;
    /**
     * Grants permission to add a member (user or group) to the resource's set of delegates
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_AssociateDelegateToResource.html
     */
    toAssociateDelegateToResource(): this;
    /**
     * Grants permission to add a member (user or group) to the group's set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_AssociateMemberToGroup.html
     */
    toAssociateMemberToGroup(): this;
    /**
     * Grants permission to cancel a currently running mailbox export job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CancelMailboxExportJob.html
     */
    toCancelMailboxExportJob(): this;
    /**
     * Grants permission to add an alias to the set of a given member (user or group) of WorkMail
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateAlias.html
     */
    toCreateAlias(): this;
    /**
     * Grants permission to create a group that can be used in WorkMail by calling the RegisterToWorkMail operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateGroup.html
     */
    toCreateGroup(): this;
    /**
     * Grants permission to create an inbound email flow rule which will apply to all email sent to an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/create-email-rules.html
     */
    toCreateInboundMailFlowRule(): this;
    /**
     * Grants permission to create a mail domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html
     */
    toCreateMailDomain(): this;
    /**
     * Grants permission to create a user in the directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-users.html
     */
    toCreateMailUser(): this;
    /**
     * Grants permission to create a new mobile device access rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateMobileDeviceAccessRule.html
     */
    toCreateMobileDeviceAccessRule(): this;
    /**
     * Grants permission to create a new Amazon WorkMail organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateOrganization.html
     */
    toCreateOrganization(): this;
    /**
     * Grants permission to create an outbound email flow rule which will apply to all email sent from an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/create-email-rules.html
     */
    toCreateOutboundMailFlowRule(): this;
    /**
     * Grants permission to create a new WorkMail resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateResource.html
     */
    toCreateResource(): this;
    /**
     * Grants permission to register an SMTP gateway to a WorkMail organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     */
    toCreateSmtpGateway(): this;
    /**
     * Grants permission to create a user, which can be enabled afterwards by calling the RegisterToWorkMail operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateUser.html
     */
    toCreateUser(): this;
    /**
     * Grants permission to delete an access control rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteAccessControlRule.html
     */
    toDeleteAccessControlRule(): this;
    /**
     * Grants permission to remove one or more specified aliases from a set of aliases for a given user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteAlias.html
     */
    toDeleteAlias(): this;
    /**
     * Grants permission to delete the email monitoring configuration for an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteEmailMonitoringConfiguration.html
     */
    toDeleteEmailMonitoringConfiguration(): this;
    /**
     * Grants permission to delete a group from WorkMail
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteGroup.html
     */
    toDeleteGroup(): this;
    /**
     * Grants permission to remove an inbound email flow rule to no longer apply to emails sent to an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/remove-email-flow-rule.html
     */
    toDeleteInboundMailFlowRule(): this;
    /**
     * Grants permission to remove an unused mail domain from an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/remove_domain.html
     */
    toDeleteMailDomain(): this;
    /**
     * Grants permission to delete permissions granted to a member (user or group)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteMailboxPermissions.html
     */
    toDeleteMailboxPermissions(): this;
    /**
     * Grants permission to remove a mobile device from a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-devices.html#remove_mobile_device
     */
    toDeleteMobileDevice(): this;
    /**
     * Grants permission to delete a mobile device access override
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteMobileDeviceAccessOverride.html
     */
    toDeleteMobileDeviceAccessOverride(): this;
    /**
     * Grants permission to delete a mobile device access rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteMobileDeviceAccessRule.html
     */
    toDeleteMobileDeviceAccessRule(): this;
    /**
     * Grants permission to delete an Amazon WorkMail organization and all underlying AWS resources managed by Amazon WorkMail as part of the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteOrganization.html
     */
    toDeleteOrganization(): this;
    /**
     * Grants permission to remove an outbound email flow rule so that it no longer applies to emails sent from an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/remove-email-flow-rule.html
     */
    toDeleteOutboundMailFlowRule(): this;
    /**
     * Grants permission to delete the specified resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteResource.html
     */
    toDeleteResource(): this;
    /**
     * Grants permission to delete the retention policy based on the supplied organization and policy identifiers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteRetentionPolicy.html
     */
    toDeleteRetentionPolicy(): this;
    /**
     * Grants permission to remove an SMTP gateway from an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     */
    toDeleteSmtpGateway(): this;
    /**
     * Grants permission to delete a user from WorkMail and all subsequent systems
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteUser.html
     */
    toDeleteUser(): this;
    /**
     * Grants permission to mark a user, group, or resource as no longer used in WorkMail
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeregisterFromWorkMail.html
     */
    toDeregisterFromWorkMail(): this;
    /**
     * Grants permission to deregister a mail domain from an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeregisterMailDomain.html
     */
    toDeregisterMailDomain(): this;
    /**
     * Grants permission to show a list of directories available for use in creating an organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html
     */
    toDescribeDirectories(): this;
    /**
     * Grants permission to retrieve the email monitoring configuration for an organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeEmailMonitoringConfiguration.html
     */
    toDescribeEmailMonitoringConfiguration(): this;
    /**
     * Grants permission to read the details for a group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeGroup.html
     */
    toDescribeGroup(): this;
    /**
     * Grants permission to read the settings in a DMARC policy for a specified organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeInboundDmarcSettings.html
     */
    toDescribeInboundDmarcSettings(): this;
    /**
     * Grants permission to read the details of an inbound mail flow rule configured for an organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/email-flows.html#email-flows-rule-actions
     */
    toDescribeInboundMailFlowRule(): this;
    /**
     * Grants permission to show a list of KMS Keys available for use in creating an organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html
     */
    toDescribeKmsKeys(): this;
    /**
     * Grants permission to show the details of all mail domains associated with the organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/domains_overview.html
     */
    toDescribeMailDomains(): this;
    /**
     * Grants permission to show the details of all groups associated with the organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     */
    toDescribeMailGroups(): this;
    /**
     * Grants permission to show the details of all users associated with the organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/users_overview.html
     */
    toDescribeMailUsers(): this;
    /**
     * Grants permission to retrieve details of a mailbox export job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeMailboxExportJob.html
     */
    toDescribeMailboxExportJob(): this;
    /**
     * Grants permission to read details of an organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeOrganization.html
     */
    toDescribeOrganization(): this;
    /**
     * Grants permission to show a summary of all organizations associated with the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html
     */
    toDescribeOrganizations(): this;
    /**
     * Grants permission to read the details of an outbound mail flow rule configured for an organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/email-flows.html#email-flows-rule-outbound
     */
    toDescribeOutboundMailFlowRule(): this;
    /**
     * Grants permission to read the details for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeResource.html
     */
    toDescribeResource(): this;
    /**
     * Grants permission to read the details of an SMTP gateway registered to an organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     */
    toDescribeSmtpGateway(): this;
    /**
     * Grants permission to read details for a user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeUser.html
     */
    toDescribeUser(): this;
    /**
     * Grants permission to disable a mail group when it is not being used, in order to allow it to be deleted
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/remove_group.html
     */
    toDisableMailGroups(): this;
    /**
     * Grants permission to disable a user mailbox when it is no longer being used, in order to allow it to be deleted
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-mailboxes.html#delete_user_mailbox
     */
    toDisableMailUsers(): this;
    /**
     * Grants permission to remove a member from the resource's set of delegates
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DisassociateDelegateFromResource.html
     */
    toDisassociateDelegateFromResource(): this;
    /**
     * Grants permission to remove a member from a group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DisassociateMemberFromGroup.html
     */
    toDisassociateMemberFromGroup(): this;
    /**
     * Grants permission to enable a mail domain in the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html
     */
    toEnableMailDomain(): this;
    /**
     * Grants permission to enable a mail group after it has been created to allow it to receive mail
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/enable_existing_group.html
     */
    toEnableMailGroups(): this;
    /**
     * Grants permission to enable a user's mailbox after it has been created to allow it to receive mail
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-users.html#enable_existing_user
     */
    toEnableMailUsers(): this;
    /**
     * Grants permission to get the effects of access control rules as they apply to a specified IPv4 address, access protocol action, or user ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetAccessControlEffect.html
     */
    toGetAccessControlEffect(): this;
    /**
     * Grants permission to retrieve the retention policy associated at an organizational level
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetDefaultRetentionPolicy.html
     */
    toGetDefaultRetentionPolicy(): this;
    /**
     * Grants permission to read the configured journaling and fallback email addresses for email journaling
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/journaling_overview.html
     */
    toGetJournalingRules(): this;
    /**
     * Grants permission to retrieve details of a given mail domain in an organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetMailDomain.html
     */
    toGetMailDomain(): this;
    /**
     * Grants permission to get the details of the mail domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/domains_overview.html
     */
    toGetMailDomainDetails(): this;
    /**
     * Grants permission to get the details of the mail group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     */
    toGetMailGroupDetails(): this;
    /**
     * Grants permission to get the details of the user's mailbox and account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/users_overview.html
     */
    toGetMailUserDetails(): this;
    /**
     * Grants permission to read the details of the user's mailbox
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetMailboxDetails.html
     */
    toGetMailboxDetails(): this;
    /**
     * Grants permission to simulate the effect of the mobile device access rules for the given attributes of a sample access event
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetMobileDeviceAccessEffect.html
     */
    toGetMobileDeviceAccessEffect(): this;
    /**
     * Grants permission to retrieve a mobile device access override
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetMobileDeviceAccessOverride.html
     */
    toGetMobileDeviceAccessOverride(): this;
    /**
     * Grants permission to get the details of the mobile device
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-devices.html
     */
    toGetMobileDeviceDetails(): this;
    /**
     * Grants permission to get a list of the mobile devices associated with the user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-devices.html
     */
    toGetMobileDevicesForUser(): this;
    /**
     * Grants permission to get the details of the mobile device policy associated with the organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/edit_organization_mobile_policy.html
     */
    toGetMobilePolicyDetails(): this;
    /**
     * Grants permission to list the access control rules
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListAccessControlRules.html
     */
    toListAccessControlRules(): this;
    /**
     * Grants permission to list the aliases associated with a given entity
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListAliases.html
     */
    toListAliases(): this;
    /**
     * Grants permission to read an overview of the members of a group. Users and groups can be members of a group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListGroupMembers.html
     */
    toListGroupMembers(): this;
    /**
     * Grants permission to list summaries of the organization's groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListGroups.html
     */
    toListGroups(): this;
    /**
     * Grants permission to list inbound mail flow rules configured for an organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/email-flows.html#email-flows-rule-actions
     */
    toListInboundMailFlowRules(): this;
    /**
     * Grants permission to list the mail domains for a given organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMailDomains.html
     */
    toListMailDomains(): this;
    /**
     * Grants permission to list mailbox export jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMailboxExportJobs.html
     */
    toListMailboxExportJobs(): this;
    /**
     * Grants permission to list the mailbox permissions associated with a user, group, or resource mailbox
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMailboxPermissions.html
     */
    toListMailboxPermissions(): this;
    /**
     * Grants permission to get a list of all the members in a mail group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     */
    toListMembersInMailGroup(): this;
    /**
     * Grants permission to list the mobile device access overrides
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMobileDeviceAccessOverrides.html
     */
    toListMobileDeviceAccessOverrides(): this;
    /**
     * Grants permission to list the mobile device access rules
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMobileDeviceAccessRules.html
     */
    toListMobileDeviceAccessRules(): this;
    /**
     * Grants permission to list the non-deleted organizations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListOrganizations.html
     */
    toListOrganizations(): this;
    /**
     * Grants permission to list outbound mail flow rules configured for an organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/email-flows.html#email-flows-rule-outbound
     */
    toListOutboundMailFlowRules(): this;
    /**
     * Grants permission to list the delegates associated with a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListResourceDelegates.html
     */
    toListResourceDelegates(): this;
    /**
     * Grants permission to list the organization's resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListResources.html
     */
    toListResources(): this;
    /**
     * Grants permission to list SMTP gateways registered to the organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     */
    toListSmtpGateways(): this;
    /**
     * Grants permission to list the tags applied to an Amazon WorkMail organization resource
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list the organization's users
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListUsers.html
     */
    toListUsers(): this;
    /**
     * Grants permission to add a new access control rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutAccessControlRule.html
     */
    toPutAccessControlRule(): this;
    /**
     * Grants permission to add or update the email monitoring configuration for an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutEmailMonitoringConfiguration.html
     */
    toPutEmailMonitoringConfiguration(): this;
    /**
     * Grants permission to enable or disable a DMARC policy for a given organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutInboundDmarcSettings.html
     */
    toPutInboundDmarcSettings(): this;
    /**
     * Grants permission to set permissions for a user, group, or resource, replacing any existing permissions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutMailboxPermissions.html
     */
    toPutMailboxPermissions(): this;
    /**
     * Grants permission to add or update a mobile device access override
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutMobileDeviceAccessOverride.html
     */
    toPutMobileDeviceAccessOverride(): this;
    /**
     * Grants permission to add or update the retention policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutRetentionPolicy.html
     */
    toPutRetentionPolicy(): this;
    /**
     * Grants permission to register a new mail domain in an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_RegisterMailDomain.html
     */
    toRegisterMailDomain(): this;
    /**
     * Grants permission to register an existing and disabled user, group, or resource for use by associating a mailbox and calendaring capabilities
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_RegisterToWorkMail.html
     */
    toRegisterToWorkMail(): this;
    /**
     * Grants permission to remove members from a mail group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     */
    toRemoveMembersFromGroup(): this;
    /**
     * Grants permission to allow the administrator to reset the password for a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ResetPassword.html
     */
    toResetPassword(): this;
    /**
     * Grants permission to reset the password for a user's account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-users.html#reset_user_password
     */
    toResetUserPassword(): this;
    /**
     * Grants permission to perform a prefix search to find a specific user in a mail group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     */
    toSearchMembers(): this;
    /**
     * Grants permission to mark a user as being an administrator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/users_overview.html
     */
    toSetAdmin(): this;
    /**
     * Grants permission to set the default mail domain for the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html
     */
    toSetDefaultMailDomain(): this;
    /**
     * Grants permission to set journaling and fallback email addresses for email journaling
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/journaling_overview.html
     */
    toSetJournalingRules(): this;
    /**
     * Grants permission to set the details of the mail group which has just been created
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_group.html
     */
    toSetMailGroupDetails(): this;
    /**
     * Grants permission to set the details for the user account which has just been created
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-users.html
     */
    toSetMailUserDetails(): this;
    /**
     * Grants permission to set the details of a mobile policy associated with the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/edit_organization_mobile_policy.html
     */
    toSetMobilePolicyDetails(): this;
    /**
     * Grants permission to start a new mailbox export job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_StartMailboxExportJob.html
     */
    toStartMailboxExportJob(): this;
    /**
     * Grants permission to tag the specified Amazon WorkMail organization resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to test what inbound rules will apply to an email with a given sender and recipient
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/test-email-flow-rule.html
     */
    toTestInboundMailFlowRules(): this;
    /**
     * Grants permission to test what outbound rules will apply to an email with a given sender and recipient
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/test-email-flow-rule.html
     */
    toTestOutboundMailFlowRules(): this;
    /**
     * Grants permission to untag the specified Amazon WorkMail organization resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update which domain is the default domain for an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdateDefaultMailDomain.html
     */
    toUpdateDefaultMailDomain(): this;
    /**
     * Grants permission to update the details of an inbound email flow rule which will apply to all email sent to an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/modify-email-flow-rule.html
     */
    toUpdateInboundMailFlowRule(): this;
    /**
     * Grants permission to update the maximum size (in MB) of the user's mailbox
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdateMailboxQuota.html
     */
    toUpdateMailboxQuota(): this;
    /**
     * Grants permission to update a mobile device access rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdateMobileDeviceAccessRule.html
     */
    toUpdateMobileDeviceAccessRule(): this;
    /**
     * Grants permission to update the details of an outbound email flow rule which will apply to all email sent from an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/modify-email-flow-rule.html
     */
    toUpdateOutboundMailFlowRule(): this;
    /**
     * Grants permission to update the primary email for a user, group, or resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdatePrimaryEmailAddress.html
     */
    toUpdatePrimaryEmailAddress(): this;
    /**
     * Grants permission to update details for the resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdateResource.html
     */
    toUpdateResource(): this;
    /**
     * Grants permission to update the details of an existing SMTP gateway registered to an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     */
    toUpdateSmtpGateway(): this;
    /**
     * Grants permission to remotely wipe the mobile device associated with a user's account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-devices.html#remote_wipe_device
     */
    toWipeMobileDevice(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type organization to the statement
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOrganization(resourceId: string, account?: string, region?: string, partition?: string): this;
}
//# sourceMappingURL=workmail.d.ts.map