import { PolicyStatementWithResources } from './4-resources';
/**
 * Policy effects
 */
export declare enum Effect {
    ALLOW = "Allow",
    DENY = "Deny"
}
/**
 * Adds "effect" functionality to the Policy Statement
 */
export declare class PolicyStatementWithEffect extends PolicyStatementWithResources {
    effect: Effect;
    /**
     * Injects effect into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     */
    toJSON(): any;
    /**
     * Allow the actions in this statement
     */
    allow(): this;
    /**
     * Deny the actions in this statement
     */
    deny(): this;
}
//# sourceMappingURL=5-effect.d.ts.map