"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnPolicy = exports.CfnNotificationChannel = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-07-29T13:55:40.724Z","fingerprint":"pQtqXJO/HpTkvtI9xeotzO0aINsbCdlgw0i2tkR8+dk="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnNotificationChannelProps`
 *
 * @param properties - the TypeScript properties of a `CfnNotificationChannelProps`
 *
 * @returns the result of the validation.
 */
function CfnNotificationChannelPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('snsRoleName', cdk.requiredValidator)(properties.snsRoleName));
    errors.collect(cdk.propertyValidator('snsRoleName', cdk.validateString)(properties.snsRoleName));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.requiredValidator)(properties.snsTopicArn));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.validateString)(properties.snsTopicArn));
    return errors.wrap('supplied properties not correct for "CfnNotificationChannelProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::NotificationChannel` resource
 *
 * @param properties - the TypeScript properties of a `CfnNotificationChannelProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::NotificationChannel` resource.
 */
// @ts-ignore TS6133
function cfnNotificationChannelPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnNotificationChannelPropsValidator(properties).assertSuccess();
    return {
        SnsRoleName: cdk.stringToCloudFormation(properties.snsRoleName),
        SnsTopicArn: cdk.stringToCloudFormation(properties.snsTopicArn),
    };
}
// @ts-ignore TS6133
function CfnNotificationChannelPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('snsRoleName', 'SnsRoleName', cfn_parse.FromCloudFormation.getString(properties.SnsRoleName));
    ret.addPropertyResult('snsTopicArn', 'SnsTopicArn', cfn_parse.FromCloudFormation.getString(properties.SnsTopicArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FMS::NotificationChannel`
 *
 * Designates the IAM role and Amazon Simple Notification Service (SNS) topic to use to record SNS logs.
 *
 * To perform this action outside of the console, you must configure the SNS topic to allow the role `AWSServiceRoleForFMS` to publish SNS logs. For more information, see [Firewall Manager required permissions for API actions](https://docs.aws.amazon.com/waf/latest/developerguide/fms-api-permissions-ref.html) in the *AWS Firewall Manager Developer Guide* .
 *
 * @cloudformationResource AWS::FMS::NotificationChannel
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-notificationchannel.html
 */
class CfnNotificationChannel extends cdk.CfnResource {
    /**
     * Create a new `AWS::FMS::NotificationChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_fms_CfnNotificationChannelProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnNotificationChannel);
            }
            throw error;
        }
        cdk.requireProperty(props, 'snsRoleName', this);
        cdk.requireProperty(props, 'snsTopicArn', this);
        this.snsRoleName = props.snsRoleName;
        this.snsTopicArn = props.snsTopicArn;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnNotificationChannelPropsFromCloudFormation(resourceProperties);
        const ret = new CfnNotificationChannel(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            snsRoleName: this.snsRoleName,
            snsTopicArn: this.snsTopicArn,
        };
    }
    renderProperties(props) {
        return cfnNotificationChannelPropsToCloudFormation(props);
    }
}
exports.CfnNotificationChannel = CfnNotificationChannel;
_a = JSII_RTTI_SYMBOL_1;
CfnNotificationChannel[_a] = { fqn: "@aws-cdk/aws-fms.CfnNotificationChannel", version: "1.166.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME = "AWS::FMS::NotificationChannel";
/**
 * Determine whether the given properties match those of a `CfnPolicyProps`
 *
 * @param properties - the TypeScript properties of a `CfnPolicyProps`
 *
 * @returns the result of the validation.
 */
function CfnPolicyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('deleteAllPolicyResources', cdk.validateBoolean)(properties.deleteAllPolicyResources));
    errors.collect(cdk.propertyValidator('excludeMap', CfnPolicy_IEMapPropertyValidator)(properties.excludeMap));
    errors.collect(cdk.propertyValidator('excludeResourceTags', cdk.requiredValidator)(properties.excludeResourceTags));
    errors.collect(cdk.propertyValidator('excludeResourceTags', cdk.validateBoolean)(properties.excludeResourceTags));
    errors.collect(cdk.propertyValidator('includeMap', CfnPolicy_IEMapPropertyValidator)(properties.includeMap));
    errors.collect(cdk.propertyValidator('policyName', cdk.requiredValidator)(properties.policyName));
    errors.collect(cdk.propertyValidator('policyName', cdk.validateString)(properties.policyName));
    errors.collect(cdk.propertyValidator('remediationEnabled', cdk.requiredValidator)(properties.remediationEnabled));
    errors.collect(cdk.propertyValidator('remediationEnabled', cdk.validateBoolean)(properties.remediationEnabled));
    errors.collect(cdk.propertyValidator('resourceTags', cdk.listValidator(CfnPolicy_ResourceTagPropertyValidator))(properties.resourceTags));
    errors.collect(cdk.propertyValidator('resourceType', cdk.requiredValidator)(properties.resourceType));
    errors.collect(cdk.propertyValidator('resourceType', cdk.validateString)(properties.resourceType));
    errors.collect(cdk.propertyValidator('resourceTypeList', cdk.listValidator(cdk.validateString))(properties.resourceTypeList));
    errors.collect(cdk.propertyValidator('resourcesCleanUp', cdk.validateBoolean)(properties.resourcesCleanUp));
    errors.collect(cdk.propertyValidator('securityServicePolicyData', cdk.requiredValidator)(properties.securityServicePolicyData));
    errors.collect(cdk.propertyValidator('securityServicePolicyData', cdk.validateObject)(properties.securityServicePolicyData));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnPolicy_PolicyTagPropertyValidator))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnPolicyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy` resource
 *
 * @param properties - the TypeScript properties of a `CfnPolicyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicyPropsValidator(properties).assertSuccess();
    return {
        ExcludeResourceTags: cdk.booleanToCloudFormation(properties.excludeResourceTags),
        PolicyName: cdk.stringToCloudFormation(properties.policyName),
        RemediationEnabled: cdk.booleanToCloudFormation(properties.remediationEnabled),
        ResourceType: cdk.stringToCloudFormation(properties.resourceType),
        SecurityServicePolicyData: cdk.objectToCloudFormation(properties.securityServicePolicyData),
        DeleteAllPolicyResources: cdk.booleanToCloudFormation(properties.deleteAllPolicyResources),
        ExcludeMap: cfnPolicyIEMapPropertyToCloudFormation(properties.excludeMap),
        IncludeMap: cfnPolicyIEMapPropertyToCloudFormation(properties.includeMap),
        ResourcesCleanUp: cdk.booleanToCloudFormation(properties.resourcesCleanUp),
        ResourceTags: cdk.listMapper(cfnPolicyResourceTagPropertyToCloudFormation)(properties.resourceTags),
        ResourceTypeList: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourceTypeList),
        Tags: cdk.listMapper(cfnPolicyPolicyTagPropertyToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnPolicyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('excludeResourceTags', 'ExcludeResourceTags', cfn_parse.FromCloudFormation.getBoolean(properties.ExcludeResourceTags));
    ret.addPropertyResult('policyName', 'PolicyName', cfn_parse.FromCloudFormation.getString(properties.PolicyName));
    ret.addPropertyResult('remediationEnabled', 'RemediationEnabled', cfn_parse.FromCloudFormation.getBoolean(properties.RemediationEnabled));
    ret.addPropertyResult('resourceType', 'ResourceType', cfn_parse.FromCloudFormation.getString(properties.ResourceType));
    ret.addPropertyResult('securityServicePolicyData', 'SecurityServicePolicyData', cfn_parse.FromCloudFormation.getAny(properties.SecurityServicePolicyData));
    ret.addPropertyResult('deleteAllPolicyResources', 'DeleteAllPolicyResources', properties.DeleteAllPolicyResources != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeleteAllPolicyResources) : undefined);
    ret.addPropertyResult('excludeMap', 'ExcludeMap', properties.ExcludeMap != null ? CfnPolicyIEMapPropertyFromCloudFormation(properties.ExcludeMap) : undefined);
    ret.addPropertyResult('includeMap', 'IncludeMap', properties.IncludeMap != null ? CfnPolicyIEMapPropertyFromCloudFormation(properties.IncludeMap) : undefined);
    ret.addPropertyResult('resourcesCleanUp', 'ResourcesCleanUp', properties.ResourcesCleanUp != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ResourcesCleanUp) : undefined);
    ret.addPropertyResult('resourceTags', 'ResourceTags', properties.ResourceTags != null ? cfn_parse.FromCloudFormation.getArray(CfnPolicyResourceTagPropertyFromCloudFormation)(properties.ResourceTags) : undefined);
    ret.addPropertyResult('resourceTypeList', 'ResourceTypeList', properties.ResourceTypeList != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ResourceTypeList) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnPolicyPolicyTagPropertyFromCloudFormation)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FMS::Policy`
 *
 * An AWS Firewall Manager policy.
 *
 * Firewall Manager provides the following types of policies:
 *
 * - An AWS Shield Advanced policy, which applies Shield Advanced protection to specified accounts and resources.
 * - An AWS WAF policy (type WAFV2), which defines rule groups to run first in the corresponding AWS WAF web ACL and rule groups to run last in the web ACL.
 * - An AWS WAF Classic policy, which defines a rule group. AWS WAF Classic doesn't support rule groups in Amazon CloudFront , so, to create AWS WAF Classic policies through CloudFront , you first need to create your rule groups outside of CloudFront .
 * - A security group policy, which manages VPC security groups across your AWS organization.
 * - An AWS Network Firewall policy, which provides firewall rules to filter network traffic in specified Amazon VPCs.
 * - A DNS Firewall policy, which provides Amazon Route 53 Resolver DNS Firewall rules to filter DNS queries for specified Amazon VPCs.
 *
 * Each policy is specific to one of the types. If you want to enforce more than one policy type across accounts, create multiple policies. You can create multiple policies for each type.
 *
 * These policies require some setup to use. For more information, see the sections on prerequisites and getting started under [AWS Firewall Manager](https://docs.aws.amazon.com/waf/latest/developerguide/fms-prereq.html) .
 *
 * @cloudformationResource AWS::FMS::Policy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html
 */
class CfnPolicy extends cdk.CfnResource {
    /**
     * Create a new `AWS::FMS::Policy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnPolicy.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_fms_CfnPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnPolicy);
            }
            throw error;
        }
        cdk.requireProperty(props, 'excludeResourceTags', this);
        cdk.requireProperty(props, 'policyName', this);
        cdk.requireProperty(props, 'remediationEnabled', this);
        cdk.requireProperty(props, 'resourceType', this);
        cdk.requireProperty(props, 'securityServicePolicyData', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.excludeResourceTags = props.excludeResourceTags;
        this.policyName = props.policyName;
        this.remediationEnabled = props.remediationEnabled;
        this.resourceType = props.resourceType;
        this.securityServicePolicyData = props.securityServicePolicyData;
        this.deleteAllPolicyResources = props.deleteAllPolicyResources;
        this.excludeMap = props.excludeMap;
        this.includeMap = props.includeMap;
        this.resourcesCleanUp = props.resourcesCleanUp;
        this.resourceTags = props.resourceTags;
        this.resourceTypeList = props.resourceTypeList;
        this.tags = props.tags;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnPolicyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnPolicy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPolicy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            excludeResourceTags: this.excludeResourceTags,
            policyName: this.policyName,
            remediationEnabled: this.remediationEnabled,
            resourceType: this.resourceType,
            securityServicePolicyData: this.securityServicePolicyData,
            deleteAllPolicyResources: this.deleteAllPolicyResources,
            excludeMap: this.excludeMap,
            includeMap: this.includeMap,
            resourcesCleanUp: this.resourcesCleanUp,
            resourceTags: this.resourceTags,
            resourceTypeList: this.resourceTypeList,
            tags: this.tags,
        };
    }
    renderProperties(props) {
        return cfnPolicyPropsToCloudFormation(props);
    }
}
exports.CfnPolicy = CfnPolicy;
_b = JSII_RTTI_SYMBOL_1;
CfnPolicy[_b] = { fqn: "@aws-cdk/aws-fms.CfnPolicy", version: "1.166.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnPolicy.CFN_RESOURCE_TYPE_NAME = "AWS::FMS::Policy";
/**
 * Determine whether the given properties match those of a `IEMapProperty`
 *
 * @param properties - the TypeScript properties of a `IEMapProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_IEMapPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('account', cdk.listValidator(cdk.validateString))(properties.account));
    errors.collect(cdk.propertyValidator('orgunit', cdk.listValidator(cdk.validateString))(properties.orgunit));
    return errors.wrap('supplied properties not correct for "IEMapProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.IEMap` resource
 *
 * @param properties - the TypeScript properties of a `IEMapProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.IEMap` resource.
 */
// @ts-ignore TS6133
function cfnPolicyIEMapPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_IEMapPropertyValidator(properties).assertSuccess();
    return {
        ACCOUNT: cdk.listMapper(cdk.stringToCloudFormation)(properties.account),
        ORGUNIT: cdk.listMapper(cdk.stringToCloudFormation)(properties.orgunit),
    };
}
// @ts-ignore TS6133
function CfnPolicyIEMapPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('account', 'ACCOUNT', properties.ACCOUNT != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ACCOUNT) : undefined);
    ret.addPropertyResult('orgunit', 'ORGUNIT', properties.ORGUNIT != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ORGUNIT) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PolicyTagProperty`
 *
 * @param properties - the TypeScript properties of a `PolicyTagProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_PolicyTagPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "PolicyTagProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyTag` resource
 *
 * @param properties - the TypeScript properties of a `PolicyTagProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyTag` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPolicyTagPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_PolicyTagPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnPolicyPolicyTagPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ResourceTagProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceTagProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_ResourceTagPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "ResourceTagProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.ResourceTag` resource
 *
 * @param properties - the TypeScript properties of a `ResourceTagProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.ResourceTag` resource.
 */
// @ts-ignore TS6133
function cfnPolicyResourceTagPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_ResourceTagPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnPolicyResourceTagPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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