# randword
### A Python package for generation random English words

## Installation
You can install `randword` package using `pip` or `easy_install`:
```
pip install randword
```
```
easy_install randword
```

You can also just clone the repository and run:
```
python setup.py install
```

## Usage
See the [documentation](https://randword.readthedocs.io/en/latest/index.html).

## Credits and references
- A database of words for each part of the speech was taken from [WordNet](https://wordnet.princeton.edu/).
- Splitting words into different parts of speech is made possible by [Chilli's answer](https://stackoverflow.com/a/27415226/13692774) on [Stack Overflow](https://stackoverflow.com/).
- Surnames database was taken from this [GitHub repo](https://github.com/arineng/arincli/blob/master/lib/last-names.txt).
- Male and females names were taken from the [website of Carnegie Mellon University](https://www.cs.cmu.edu/afs/cs/project/ai-repository/ai/areas/nlp/corpora/names/).
- Countries database was taken from [this GitHub gist](https://gist.github.com/kalinchernev/486393efcca01623b18d).
- Cities database was taken from [this GitHub gist](https://gist.github.com/norcal82/4accc0d968444859b408).
- Magic 8-Ball answers were taken from [Wikipedia page](https://en.wikipedia.org/wiki/Magic_8-Ball).

## License
[randword](https://github.com/8nhuman8/randword) specific code is distributed under [MIT License](https://github.com/8nhuman8/randword/blob/master/LICENSE.txt).

Copyright (c) 2020 Artyom Bezmenov

# Contributing to [randword](https://github.com/8nhuman8/randword)
We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## We develop with [GitHub](https://github.com)
We use [GitHub](https://github.com) to host code, to track issues and feature requests, as well as accept pull requests.

## We use [Github Flow](https://guides.github.com/introduction/flow/), So All Code Changes Happen Through Pull Requests
Pull requests are the best way to propose changes to the codebase (we use [Github Flow](https://guides.github.com/introduction/flow/)). We actively welcome your pull requests:

1. Fork the repo and create your branch from `master`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. Issue that pull request!

## Any contributions you make will be under the MIT Software License
In short, when you submit code changes, your submissions are understood to be under the same [MIT License](http://choosealicense.com/licenses/mit/) that covers the project. Feel free to contact the maintainers if that's a concern.

## Report bugs using Github's [issues](https://github.com/8nhuman8/randword/issues)
We use [GitHub issues](https://help.github.com/en/github/managing-your-work-on-github/about-issues) to track public bugs. Report a bug by [opening a new issue](https://github.com/8nhuman8/randword/issues/new/choose); it's that easy!

## Write bug reports with detail, background, and sample code

**Great Bug Reports** tend to have:

- A quick summary and/or background
- Steps to reproduce
- What you expected would happen
- What actually happens
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

People *love* thorough bug reports. I'm not even kidding.

## Styleguides

### Use a consistent coding style

### Git commit messages

* Use the present tense ("Add feature" not "Added feature")
* Use the imperative mood ("Move cursor to..." not "Moves cursor to...")
* Limit the first line to 72 characters or less
* Reference issues and pull requests liberally after the first line

### Python styleguide

If possible, stick to [PEP-8](https://www.python.org/dev/peps/pep-0008/), but don't bother too much :)

## License
By contributing, you agree that your contributions will be licensed under its [MIT License](https://github.com/8nhuman8/randword/blob/master/LICENSE.txt).
