"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackendServerAttachment = exports.BackendServerAttachmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const slb_generated_1 = require("./slb.generated");
Object.defineProperty(exports, "BackendServerAttachmentProperty", { enumerable: true, get: function () { return slb_generated_1.RosBackendServerAttachment; } });
/**
 * A ROS resource type:  `ALIYUN::SLB::BackendServerAttachment`
 */
class BackendServerAttachment extends ros.Resource {
    /**
     * Create a new `ALIYUN::SLB::BackendServerAttachment`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosBackendServerAttachment = new slb_generated_1.RosBackendServerAttachment(this, id, {
            backendServerList: props.backendServerList,
            loadBalancerId: props.loadBalancerId,
            backendServerWeightList: props.backendServerWeightList,
            backendServers: props.backendServers,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosBackendServerAttachment;
        this.attrBackendServers = rosBackendServerAttachment.attrBackendServers;
        this.attrLoadBalancerId = rosBackendServerAttachment.attrLoadBalancerId;
    }
}
exports.BackendServerAttachment = BackendServerAttachment;
//# sourceMappingURL=data:application/json;base64,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