'''
URLs for fiction_outlines.
'''

from django.urls import path
from . import views

app_name = 'fiction_outlines'

urlpatterns = [
    path('series/', views.SeriesListView.as_view(), name='series_list'),
    path('series/create/', views.SeriesCreateView.as_view(), name='series_create'),
    path('series/<uuid:series>/', views.SeriesDetailView.as_view(), name='series_detail'),
    path('series/<uuid:series>/edit/', views.SeriesUpdateView.as_view(), name='series_update'),
    path('series/<uuid:series>/delete/', views.SeriesDeleteView.as_view(), name='series_delete'),
    path('characters/', views.CharacterListView.as_view(), name='character_list'),
    path('character/<uuid:character>/', views.CharacterDetailView.as_view(), name='character_detail'),
    path('character/<uuid:character>/edit/', views.CharacterUpdateView.as_view(), name='character_update'),
    path('character/<uuid:character>/delete/', views.CharacterDeleteView.as_view(), name='character_delete'),
    path('character/create/', views.CharacterCreateView.as_view(), name='character_create'),
    path('locations/', views.LocationListView.as_view(), name='location_list'),
    path('location/<uuid:location>/', views.LocationDetailView.as_view(), name='location_detail'),
    path('location/<uuid:location>/edit/', views.LocationUpdateView.as_view(), name='location_update'),
    path('location/<uuid:location>/delete/', views.LocationDeleteView.as_view(), name='location_delete'),
    path('location/create/', views.LocationCreateView.as_view(), name='location_create'),
    path('outlines/', views.OutlineListView.as_view(), name='outline_list'),
    path('outline/<uuid:outline>/', views.OutlineDetailView.as_view(), name='outline_detail'),
    path('outline/<uuid:outline>/export/<format>/', views.OutlineExport.as_view(), name='outline_export'),
    path('outline/<uuid:outline>/edit/', views.OutlineUpdateView.as_view(), name='outline_update'),
    path('outline/create/', views.OutlineCreateView.as_view(), name='outline_create'),
    path('outline/<uuid:outline>/delete/', views.OutlineDeleteView.as_view(), name='outline_delete'),
    path('character/<uuid:character>/instances/', views.CharacterInstanceListView.as_view(),
         name='character_instance_list'),
    path('character/<uuid:character>/instance/<uuid:instance>/', views.CharacterInstanceDetailView.as_view(),
         name='character_instance_detail'),
    path('character/<uuid:character>/instance/create/',
         views.CharacterInstanceCreateView.as_view(), name='character_instance_create'),
    path('character/<uuid:character>/instance/<uuid:instance>/edit/', views.CharacterInstanceUpdateView.as_view(),
         name='character_instance_update'),
    path('character/<uuid:character>/instance/<uuid:instance>/delete/', views.CharacterInstanceDeleteView.as_view(),
         name='character_instance_delete'),
    path('location/<uuid:location>/instances/', views.LocationInstanceListView.as_view(),
         name='location_instance_list'),
    path('location/<uuid:location>/instance/<uuid:instance>/', views.LocationInstanceDetailView.as_view(),
         name='location_instance_detail'),
    path('location/<uuid:location>/instance/<uuid:instance>/edit/', views.LocationInstanceUpdateView.as_view(),
         name='location_instance_update'),
    path('location/<uuid:location>/instance/<uuid:instance>/delete/', views.LocationInstanceDeleteView.as_view(),
         name='location_instance_delete'),
    path('location/<uuid:location>/instance/create/',
         views.LocationInstanceCreateView.as_view(), name='location_instance_create'),
    path('outline/<uuid:outline>/arcs/', views.ArcListView.as_view(), name='arc_list'),
    path('outline/<uuid:outline>/arc/<uuid:arc>/', views.ArcDetailView.as_view(), name='arc_detail'),
    path('outline/<uuid:outline>/arc/<uuid:arc>/edit/', views.ArcUpdateView.as_view(), name='arc_update'),
    path('outline/<uuid:outline>/arc/<uuid:arc>/delete/', views.ArcDeleteView.as_view(), name='arc_delete'),
    path('outline/<uuid:outline>/arc/create/', views.ArcCreateView.as_view(), name='arc_create'),
    path('outline/<uuid:outline>/item/<uuid:storynode>/',
         views.StoryNodeDetailView.as_view(), name='storynode_detail'),
    path('outline/<uuid:outline>/item/<uuid:storynode>/create/<pos>/',
         views.StoryNodeCreateView.as_view(), name='storynode_create'),
    path('outline/<uuid:outline>/item/<uuid:storynode>/edit/',
         views.StoryNodeUpdateView.as_view(), name='storynode_update'),
    path('outline/<uuid:outline>/item/<uuid:storynode>/move/',
         views.StoryNodeMoveView.as_view(), name='storynode_move'),
    path('outline/<uuid:outline>/item/<uuid:storynode>/delete/',
         views.StoryNodeDeleteView.as_view(), name='storynode_delete'),
    path('outline/<uuid:outline>/arc/<uuid:arc>/item/<uuid:arcnode>/create/<pos>/',
         views.ArcNodeCreateView.as_view(), name='arcnode_create'),
    path('outline/<uuid:outline>/arc/<uuid:arc>/item/<uuid:arcnode>/move/',
         views.ArcNodeMoveView.as_view(), name='arcnode_move'),
    path('outline/<uuid:outline>/arc/<uuid:arc>/item/<uuid:arcnode>/',
         views.ArcNodeDetailView.as_view(), name='arcnode_detail'),
    path('outline/<uuid:outline>/arc/<uuid:arc>/item/<uuid:arcnode>/edit/',
         views.ArcNodeUpdateView.as_view(), name='arcnode_update'),
    path('outline/<uuid:outline>/arc/<uuid:arc>/item/<uuid:arcnode>/delete/',
         views.ArcNodeDeleteView.as_view(), name='arcnode_delete'),

]
