"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirstCommitHandler = exports.ProductionLambda = exports.PreProductionLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const logs = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
const functionScript = 'import os\r\nimport json\r\nimport zipfile\r\nimport boto3\r\nimport gzip\r\nfrom io import BytesIO\r\n\r\ndef get_clients():\r\n    s3_client = boto3.resource(\'s3\')\r\n    sts_connection = boto3.client(\'sts\')\r\n    cross_account = sts_connection.assume_role(RoleArn=os.environ[\'role\'],RoleSessionName=\"session\")\r\n    access_key = cross_account[\'Credentials\'][\'AccessKeyId\']\r\n    secrect_key = cross_account[\'Credentials\'][\'SecretAccessKey\']\r\n    session_token = cross_account[\'Credentials\'][\'SessionToken\']\r\n    databrew_client = boto3.client(\r\n        \'databrew\',\r\n        aws_access_key_id=access_key,\r\n        aws_secret_access_key=secrect_key,\r\n        aws_session_token=session_token,\r\n    )\r\n    return s3_client, databrew_client\r\n\r\ndef get_name_contents(event, s3_client):\r\n    s3_location = event[\'CodePipeline.job\'][\'data\'][\'inputArtifacts\'][0][\'location\'][\'s3Location\']\r\n    s3_bucket = s3_location[\'bucketName\']\r\n    s3_file = s3_location[\'objectKey\']\r\n    zip_obj = s3_client.Object(bucket_name=s3_bucket, key=s3_file)\r\n    # extracting compressed files\r\n    buffer = BytesIO(zip_obj.get()[\"Body\"].read())\r\n    file_name = \'\'\r\n    z = zipfile.ZipFile(buffer)\r\n    json_content = \'\'\r\n    for filename in z.namelist():\r\n        if filename.endswith(\'.json\'):\r\n            file_name = filename\r\n            with z.open(file_name) as content:\r\n                json_content = json.load(content)\r\n    return file_name.replace(\'.json\', \'\'), json_content\r\n\r\ndef lambda_handler(event, context):\r\n    codepipeline_client = boto3.client(\'codepipeline\')\r\n    job_id = event[\'CodePipeline.job\'][\'id\']\r\n    try:\r\n        # client creation\r\n        clients = get_clients()\r\n        s3_client = clients[0]\r\n        databrew_client = clients[1]\r\n        # getting file name and contents\r\n        name_contents = get_name_contents(event, s3_client)\r\n        recipe_lists = databrew_client.list_recipes(MaxResults=99)\r\n        if name_contents[0] not in (x[\'Name\'] for x in recipe_lists[\'Recipes\']):\r\n            databrew_client.create_recipe(Name=name_contents[0], Steps=name_contents[1])\r\n        # updating recipe\r\n        databrew_client.update_recipe(Description=\'updating recipe\',Name=name_contents[0],Steps= name_contents[1])\r\n        # publishing a recipe\r\n        databrew_client.publish_recipe(Description=\'publishing recipe\', Name=name_contents[0])\r\n        # Notify AWS CodePipeline of a successful job\r\n        codepipeline_client.put_job_success_result(jobId=job_id)\r\n    except Exception as e:\r\n        # Notifying pipeline of a failure\r\n        codepipeline_client.put_job_failure_result(jobId=job_id,failureDetails={\'type\': \'JobFailed\',\'message\': str(e)})';
class PreProductionLambda extends constructs_1.Construct {
    constructor(scope, name, props) {
        super(scope, name);
        this.roleName = props.roleName ?? 'PreProd-DataBrew-Recipe-Deployer-role';
        this.functionName = props.functionName ?? 'PreProd-DataBrew-Recipe-Deployer';
        const lambdaRole = new iam.Role(this, 'PreproductionFunctionRole', {
            assumedBy: new iam.ServicePrincipal('lambda.amazonaws.com'),
            description: 'An execution role for the pre-production Lambda funciton.',
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('AWSXRayDaemonWriteAccess'),
                new iam.ManagedPolicy(this, 'PreProductionManagedPolicy', {
                    managedPolicyName: 'PreProd-DataBrew-Recipe-Deployer-Policy',
                    statements: [
                        new iam.PolicyStatement({
                            sid: 'CodePipelinePermissions',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                'codepipeline:PutJobFailureResult',
                                'codepipeline:PutJobSuccessResult',
                            ],
                            resources: ['*'],
                        }),
                        new iam.PolicyStatement({
                            sid: 'S3BucketPermissions',
                            effect: iam.Effect.ALLOW,
                            actions: ['s3:GetObject'],
                            resources: [`${props.bucketArn}/*`],
                        }),
                        new iam.PolicyStatement({
                            sid: 'AssumeRolePermission',
                            effect: iam.Effect.ALLOW,
                            actions: ['sts:AssumeRole'],
                            resources: [props.preproductionIamRoleArn],
                        }),
                    ],
                }),
            ],
            roleName: this.roleName,
        });
        const preproductionFunction = new lambda.Function(this, 'PreProductionFunction', {
            functionName: this.functionName,
            description: 'Read from latest commit and publish AWS Glue DataBrew recipe to pre-prod account',
            logRetention: logs.RetentionDays.THREE_MONTHS,
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromInline(functionScript),
            handler: 'index.lambda_handler',
            environment: { role: props.preproductionIamRoleArn },
            memorySize: 128,
            role: lambdaRole,
            timeout: cdk.Duration.seconds(20),
            tracing: lambda.Tracing.ACTIVE,
        });
        this.function = preproductionFunction;
    }
}
exports.PreProductionLambda = PreProductionLambda;
_a = JSII_RTTI_SYMBOL_1;
PreProductionLambda[_a] = { fqn: "cdk-databrew-cicd.PreProductionLambda", version: "2.0.108" };
class ProductionLambda extends constructs_1.Construct {
    constructor(scope, name, props) {
        super(scope, name);
        this.roleName = props.roleName ?? 'Prod-DataBrew-Recipe-Deployer-role';
        this.functionName = props.functionName ?? 'Prod-DataBrew-Recipe-Deployer';
        const lambdaRole = new iam.Role(this, 'ProductionFunctionRole', {
            assumedBy: new iam.ServicePrincipal('lambda.amazonaws.com'),
            description: 'An execution role for the production Lambda funciton.',
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('AWSXRayDaemonWriteAccess'),
                new iam.ManagedPolicy(this, 'ProductionLambdaMangedPolicuy', {
                    managedPolicyName: 'Prod-DataBrew-Recipe-Deployer-Policy',
                    statements: [
                        new iam.PolicyStatement({
                            sid: 'CodePipelinePermissions',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                'codepipeline:PutJobFailureResult',
                                'codepipeline:PutJobSuccessResult',
                            ],
                            resources: ['*'],
                        }),
                        new iam.PolicyStatement({
                            sid: 'S3BucketPermissions',
                            effect: iam.Effect.ALLOW,
                            actions: ['s3:GetObject'],
                            resources: [`${props.bucketArn}/*`],
                        }),
                        new iam.PolicyStatement({
                            sid: 'AssumeRolePermission',
                            effect: iam.Effect.ALLOW,
                            actions: ['sts:AssumeRole'],
                            resources: [props.productionIamRoleArn],
                        }),
                    ],
                }),
            ],
            roleName: this.roleName,
        });
        const productionFunction = new lambda.Function(this, 'ProductionFunction', {
            functionName: this.functionName,
            description: 'Read from latest commit and publish AWS Glue DataBrew recipe to production account',
            logRetention: logs.RetentionDays.THREE_MONTHS,
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromInline(functionScript),
            handler: 'index.lambda_handler',
            environment: { role: props.productionIamRoleArn },
            memorySize: 128,
            role: lambdaRole,
            timeout: cdk.Duration.seconds(20),
            tracing: lambda.Tracing.ACTIVE,
        });
        this.function = productionFunction;
    }
}
exports.ProductionLambda = ProductionLambda;
_b = JSII_RTTI_SYMBOL_1;
ProductionLambda[_b] = { fqn: "cdk-databrew-cicd.ProductionLambda", version: "2.0.108" };
class FirstCommitHandler extends constructs_1.Construct {
    constructor(scope, name, props) {
        super(scope, name);
        this.roleName = props.roleName ?? 'LambdaForInitialCommitRole';
        this.functionName = props.functionName ?? 'FirstCommitHandler';
        const lambdaRole = new iam.Role(this, 'FirstCommitFunctionRole', {
            assumedBy: new iam.ServicePrincipal('lambda.amazonaws.com'),
            description: 'An execution role for the Lambda function which deals with first commit via AWS CodeCommit.',
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('AWSXRayDaemonWriteAccess'),
            ],
            roleName: this.roleName,
            inlinePolicies: {
                LambdaForBranchPolicy: new iam.PolicyDocument({
                    assignSids: true,
                    statements: [new iam.PolicyStatement({
                            effect: iam.Effect.ALLOW,
                            actions: ['codecommit:CreateCommit'],
                            resources: [props.codeCommitRepoArn],
                        })],
                }),
            },
        });
        const commitHandlerFunction = new lambda.Function(this, 'CommitHandlerFunction', {
            functionName: this.functionName,
            description: 'Read from latest commit and publish AWS Glue DataBrew recipe to production account',
            logRetention: logs.RetentionDays.THREE_MONTHS,
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromInline('import os\r\nimport json\r\nimport boto3\r\nimport cfnresponse\r\n\r\ndef lambda_handler(event, context):\r\n    if(event[\'RequestType\'] == \'Create\'):\r\n        code_commit_client = boto3.client(\'codecommit\')\r\n        code_commit_client.create_commit(repositoryName=os.environ[\'repo_name\'],branchName=os.environ[\'branch_name\'],commitMessage=\'Initial Commit\',putFiles=[{\'filePath\': \'README.md\',\'fileMode\': \'NORMAL\',\'fileContent\': os.environ[\'readme_contents\']}])\r\n    responseValue = 120\r\n    responseData = {}\r\n    responseData[\'Data\'] = responseValue\r\n    cfnresponse.send(event, context, cfnresponse.SUCCESS, responseData)'),
            handler: 'index.lambda_handler',
            memorySize: 128,
            role: lambdaRole,
            environment: {
                repo_name: props.repoName,
                branch_name: props.branchName,
                readme_contents: 'CONTENTS OF THIS FILE\r\n------------\r\n * Introduction\r\n * How to set up local access\r\nINTRODUCTION\r\n------------\r\nThis repository is used for storing recipes for AWSGlue DataBrew. DataBrew is a visual data preparation tool that makes it easy to profile and prepare data for analytics and machine learning (ML). \r\nHOW TO SET UP LOCAL ACCESS\r\n------------\r\nTo set up local developer access:\r\n1. Open a terminal window, and configure the AWS CLI.\r\n   ```\r\n   aws configure\r\n   ```\r\n2. When prompted, provide the following information.\r\n   ```\r\n   > AWS Access Key ID [None]: User-Access-Key\r\n   > AWS Secret Access Key ID [None]: User-Secret-Access-Key\r\n   > Default region name ID [None]: us-east-1\r\n   > Default output format [None]: json\r\n   ```\r\n3. In a plain-text editor, open the config file, also known as the AWS CLI configuration file. Depending on your operating system, this file might be located at `~/.aws/config` on Linux, macOS, or Unix, or at `drive:\\Users\\USERNAME\\.aws\\config` on Windows.\r\n4. Update the file to include two entries, default for your account, and a second for cross account access. The resulting file should look as follows: \r\n   ```\r\n   [default]\r\n   account = <user-account-id>\r\n   region = us-east-1\r\n   output = json\r\n    \r\n   [profile CrossAccountAccessProfile]\r\n   account = <infra-account-id>\r\n   region = us-east-1\r\n   output = json\r\n   role_arn = arn:aws:iam::<infra-account-id>:role/CrossAccountRepositoryContributorRole\r\n   source_profile = default\r\n   ```\r\n6. Save your changes, and close the plain-text editor.\r\n7. Run *git clone* to clone the shared repository.\r\n   ```\r\n   > git clone codecommit://CrossAccountAccessProfile@DataBrew-Recipes-Repo \r\n   ```',
            },
            timeout: cdk.Duration.seconds(20),
            tracing: lambda.Tracing.ACTIVE,
        });
        this.function = commitHandlerFunction;
    }
}
exports.FirstCommitHandler = FirstCommitHandler;
_c = JSII_RTTI_SYMBOL_1;
FirstCommitHandler[_c] = { fqn: "cdk-databrew-cicd.FirstCommitHandler", version: "2.0.108" };
//# sourceMappingURL=data:application/json;base64,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